/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.MasterFactory;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.journal.Journal;
import alluxio.master.journal.ReadWriteJournal;
import alluxio.master.keyvalue.KeyValueMaster;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueMasterFactory
implements MasterFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public boolean isEnabled() {
        return MasterContext.getConf().getBoolean("alluxio.keyvalue.enabled");
    }

    public String getName() {
        return "KeyValueMaster";
    }

    public KeyValueMaster create(List<? extends Master> masters, String journalDirectory) {
        if (!this.isEnabled()) {
            return null;
        }
        Preconditions.checkArgument((journalDirectory != null ? 1 : 0) != 0, (Object)"journal path may not be null");
        LOG.info("Creating {} ", (Object)KeyValueMaster.class.getName());
        ReadWriteJournal journal = new ReadWriteJournal(KeyValueMaster.getJournalDirectory(journalDirectory));
        for (Master master : masters) {
            if (!(master instanceof FileSystemMaster)) continue;
            LOG.info("{} is created", (Object)KeyValueMaster.class.getName());
            return new KeyValueMaster((FileSystemMaster)master, (Journal)journal);
        }
        LOG.error("Fail to create {} due to missing {}", (Object)KeyValueMaster.class.getName(), (Object)FileSystemMaster.class.getName());
        return null;
    }
}

