/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.Configuration;
import alluxio.thrift.KeyValueWorkerClientService;
import alluxio.util.ThreadFactoryUtils;
import alluxio.worker.AbstractWorker;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.keyvalue.KeyValueWorkerClientServiceHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TProcessor;

@ThreadSafe
public final class KeyValueWorker
extends AbstractWorker {
    private final Configuration mConfiguration = WorkerContext.getConf();
    private final BlockWorker mBlockWorker;
    private final KeyValueWorkerClientServiceHandler mKeyValueServiceHandler;

    public KeyValueWorker(BlockWorker blockWorker) {
        super(Executors.newFixedThreadPool(1, ThreadFactoryUtils.build((String)"keyvalue-worker-heartbeat-%d", (boolean)true)));
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
        this.mKeyValueServiceHandler = new KeyValueWorkerClientServiceHandler(this.mBlockWorker);
    }

    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("KeyValueWorkerClient", (TProcessor)new KeyValueWorkerClientService.Processor((KeyValueWorkerClientService.Iface)this.mKeyValueServiceHandler));
        return services;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }
}

