/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.client.keyvalue.ByteBufferKeyValuePartitionReader;
import alluxio.client.keyvalue.Index;
import alluxio.client.keyvalue.PayloadReader;
import alluxio.exception.AlluxioException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.KeyValueWorkerClientService;
import alluxio.thrift.ThriftIOException;
import alluxio.util.io.BufferUtils;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueWorkerClientServiceHandler
implements KeyValueWorkerClientService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mBlockWorker;

    public KeyValueWorkerClientServiceHandler(BlockWorker blockWorker) {
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
    }

    public long getServiceVersion() {
        return 1L;
    }

    public ByteBuffer get(long blockId, ByteBuffer key) throws AlluxioTException, ThriftIOException {
        try {
            ByteBuffer value = this.getInternal(blockId, key);
            if (value == null) {
                return ByteBuffer.allocate(0);
            }
            return this.copyAsNonDirectBuffer(value);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    private ByteBuffer copyAsNonDirectBuffer(ByteBuffer directBuffer) {
        return BufferUtils.cloneByteBuffer((ByteBuffer)directBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getInternal(long blockId, ByteBuffer keyBuffer) throws BlockDoesNotExistException, IOException {
        long sessionId = -6L;
        long lockId = this.mBlockWorker.lockBlock(-6L, blockId);
        try {
            ByteBuffer byteBuffer = this.getReader(-6L, lockId, blockId).get(keyBuffer);
            return byteBuffer;
        }
        catch (InvalidWorkerStateException e) {
            LOG.error("Reaching invalid state to get a key", (Throwable)e);
        }
        finally {
            this.mBlockWorker.unlockBlock(lockId);
        }
        return null;
    }

    private ByteBufferKeyValuePartitionReader getReader(long sessionId, long lockId, long blockId) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        BlockReader blockReader = this.mBlockWorker.readBlockRemote(sessionId, blockId, lockId);
        ByteBuffer fileBuffer = blockReader.read(0L, blockReader.getLength());
        ByteBufferKeyValuePartitionReader reader = new ByteBufferKeyValuePartitionReader(fileBuffer);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ByteBuffer> getNextKeys(long blockId, ByteBuffer currentKey, int numKeys) throws AlluxioTException, ThriftIOException {
        ArrayList arrayList;
        long sessionId = -6L;
        long lockId = this.mBlockWorker.lockBlock(-6L, blockId);
        try {
            ByteBuffer nextKey;
            ByteBufferKeyValuePartitionReader reader = this.getReader(-6L, lockId, blockId);
            Index index = reader.getIndex();
            PayloadReader payloadReader = reader.getPayloadReader();
            ArrayList ret = Lists.newArrayListWithExpectedSize((int)numKeys);
            for (int i = 0; i < numKeys && (nextKey = index.nextKey(currentKey, payloadReader)) != null; ++i) {
                ret.add(this.copyAsNonDirectBuffer(nextKey));
                currentKey = nextKey;
            }
            arrayList = ret;
        }
        catch (InvalidWorkerStateException e) {
            try {
                try {
                    LOG.error("Reaching invalid state to get all keys", (Throwable)e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.mBlockWorker.unlockBlock(lockId);
                }
                return Collections.emptyList();
            }
            catch (AlluxioException e2) {
                throw e2.toAlluxioTException();
            }
            catch (IOException e3) {
                throw new ThriftIOException(e3.getMessage());
            }
        }
        this.mBlockWorker.unlockBlock(lockId);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(long blockId) throws AlluxioTException, ThriftIOException {
        int n;
        long sessionId = -6L;
        long lockId = this.mBlockWorker.lockBlock(-6L, blockId);
        try {
            n = this.getReader(-6L, lockId, blockId).size();
        }
        catch (InvalidWorkerStateException e) {
            try {
                try {
                    LOG.error("Reaching invalid state to get size", (Throwable)e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.mBlockWorker.unlockBlock(lockId);
                }
                return 0;
            }
            catch (AlluxioException e2) {
                throw e2.toAlluxioTException();
            }
            catch (IOException e3) {
                throw new ThriftIOException(e3.getMessage());
            }
        }
        this.mBlockWorker.unlockBlock(lockId);
        return n;
    }
}

