/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.worker.Worker;
import alluxio.worker.WorkerContext;
import alluxio.worker.WorkerFactory;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.keyvalue.KeyValueWorker;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueWorkerFactory
implements WorkerFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public KeyValueWorker create(List<? extends Worker> workers) {
        if (!WorkerContext.getConf().getBoolean("alluxio.keyvalue.enabled")) {
            return null;
        }
        LOG.info("Creating {} ", (Object)KeyValueWorker.class.getName());
        for (Worker worker : workers) {
            if (!(worker instanceof BlockWorker)) continue;
            LOG.info("{} is created", (Object)KeyValueWorker.class.getName());
            return new KeyValueWorker((BlockWorker)worker);
        }
        LOG.error("Fail to create {} due to missing {}", (Object)KeyValueWorker.class.getName(), (Object)BlockWorker.class.getName());
        return null;
    }
}

