/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PersistableBundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import java.util.List;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.bluetooth.BluetoothTestJob;

public class BluetoothMedic {
    public static final int NO_TEST = 0;
    public static final int TRANSMIT_TEST = 2;
    public static final int SCAN_TEST = 1;
    private static final String TAG = BluetoothMedic.class.getSimpleName();
    @Nullable
    private BluetoothAdapter mAdapter;
    @Nullable
    private LocalBroadcastManager mLocalBroadcastManager;
    @NonNull
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private int mTestType = 0;
    @Nullable
    private Boolean mTransmitterTestResult = null;
    @Nullable
    private Boolean mScanTestResult = null;
    private boolean mNotificationsEnabled = false;
    private boolean mNotificationChannelCreated = false;
    private int mNotificationIcon = 0;
    private long mLastBluetoothPowerCycleTime = 0L;
    private static final long MIN_MILLIS_BETWEEN_BLUETOOTH_POWER_CYCLES = 60000L;
    @Nullable
    private static BluetoothMedic sInstance;
    @RequiresApi(value=21)
    private BroadcastReceiver mBluetoothEventReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            LogManager.d(TAG, "Broadcast notification received.", new Object[0]);
            String action = intent.getAction();
            if (action != null) {
                if (action.equalsIgnoreCase("onScanFailed")) {
                    int errorCode = intent.getIntExtra("errorCode", -1);
                    if (errorCode == 2) {
                        BluetoothMedic.this.sendNotification(context, "scan failed", "Power cycling bluetooth");
                        LogManager.d(TAG, "Detected a SCAN_FAILED_APPLICATION_REGISTRATION_FAILED.  We need to cycle bluetooth to recover", new Object[0]);
                        if (!BluetoothMedic.this.cycleBluetoothIfNotTooSoon()) {
                            BluetoothMedic.this.sendNotification(context, "scan failed", "Cannot power cycle bluetooth again");
                        }
                    }
                } else if (action.equalsIgnoreCase("onStartFailed")) {
                    int errorCode = intent.getIntExtra("errorCode", -1);
                    if (errorCode == 4) {
                        BluetoothMedic.this.sendNotification(context, "advertising failed", "Expected failure.  Power cycling.");
                        if (!BluetoothMedic.this.cycleBluetoothIfNotTooSoon()) {
                            BluetoothMedic.this.sendNotification(context, "advertising failed", "Cannot power cycle bluetooth again");
                        }
                    }
                } else {
                    LogManager.d(TAG, "Unknown event.", new Object[0]);
                }
            }
        }
    };

    public static BluetoothMedic getInstance() {
        if (sInstance == null) {
            sInstance = new BluetoothMedic();
        }
        return sInstance;
    }

    private BluetoothMedic() {
    }

    @RequiresApi(value=21)
    private void initializeWithContext(Context context) {
        if (this.mAdapter == null || this.mLocalBroadcastManager == null) {
            BluetoothManager manager = (BluetoothManager)context.getSystemService("bluetooth");
            if (manager == null) {
                throw new NullPointerException("Cannot get BluetoothManager");
            }
            this.mAdapter = manager.getAdapter();
            this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        }
    }

    @RequiresApi(value=21)
    public void enablePowerCycleOnFailures(Context context) {
        this.initializeWithContext(context);
        if (this.mLocalBroadcastManager != null) {
            this.mLocalBroadcastManager.registerReceiver(this.mBluetoothEventReceiver, new IntentFilter("onScanFailed"));
            this.mLocalBroadcastManager.registerReceiver(this.mBluetoothEventReceiver, new IntentFilter("onStartFailure"));
            LogManager.d(TAG, "Medic monitoring for transmission and scan failure notifications with receiver: " + this.mBluetoothEventReceiver, new Object[0]);
        }
    }

    @RequiresApi(value=21)
    public void enablePeriodicTests(Context context, int testType) {
        this.initializeWithContext(context);
        this.mTestType = testType;
        LogManager.d(TAG, "Medic scheduling periodic tests of types " + testType, new Object[0]);
        this.scheduleRegularTests(context);
    }

    @RequiresApi(value=21)
    public boolean runScanTest(final Context context) {
        this.initializeWithContext(context);
        this.mScanTestResult = null;
        LogManager.i(TAG, "Starting scan test", new Object[0]);
        long testStartTime = System.currentTimeMillis();
        if (this.mAdapter != null) {
            final BluetoothLeScanner scanner = this.mAdapter.getBluetoothLeScanner();
            ScanCallback callback = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult result) {
                    super.onScanResult(callbackType, result);
                    BluetoothMedic.this.mScanTestResult = true;
                    LogManager.i(TAG, "Scan test succeeded", new Object[0]);
                    try {
                        scanner.stopScan((ScanCallback)this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    super.onBatchScanResults(results);
                }

                public void onScanFailed(int errorCode) {
                    super.onScanFailed(errorCode);
                    LogManager.d(TAG, "Sending onScanFailed broadcast with " + BluetoothMedic.this.mLocalBroadcastManager, new Object[0]);
                    Intent intent = new Intent("onScanFailed");
                    intent.putExtra("errorCode", errorCode);
                    if (BluetoothMedic.this.mLocalBroadcastManager != null) {
                        BluetoothMedic.this.mLocalBroadcastManager.sendBroadcast(intent);
                    }
                    LogManager.d(TAG, "broadcast: " + intent + " should be received by " + BluetoothMedic.this.mBluetoothEventReceiver, new Object[0]);
                    if (errorCode == 2) {
                        LogManager.w(TAG, "Scan test failed in a way we consider a failure", new Object[0]);
                        BluetoothMedic.this.sendNotification(context, "scan failed", "bluetooth not ok");
                        BluetoothMedic.this.mScanTestResult = false;
                    } else {
                        LogManager.i(TAG, "Scan test failed in a way we do not consider a failure", new Object[0]);
                        BluetoothMedic.this.mScanTestResult = true;
                    }
                }
            };
            if (scanner != null) {
                try {
                    scanner.startScan(callback);
                    while (this.mScanTestResult == null) {
                        LogManager.d(TAG, "Waiting for scan test to complete...", new Object[0]);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - testStartTime <= 5000L) continue;
                        LogManager.d(TAG, "Timeout running scan test", new Object[0]);
                        break;
                    }
                    scanner.stopScan(callback);
                }
                catch (IllegalStateException e) {
                    LogManager.d(TAG, "Bluetooth is off.  Cannot run scan test.", new Object[0]);
                }
                catch (NullPointerException e) {
                    LogManager.e(TAG, "NullPointerException. Cannot run scan test.", e);
                }
            } else {
                LogManager.d(TAG, "Cannot get scanner", new Object[0]);
            }
        }
        LogManager.d(TAG, "scan test complete", new Object[0]);
        return this.mScanTestResult == null || this.mScanTestResult != false;
    }

    @RequiresApi(value=21)
    public boolean runTransmitterTest(final Context context) {
        this.initializeWithContext(context);
        this.mTransmitterTestResult = null;
        long testStartTime = System.currentTimeMillis();
        if (this.mAdapter != null) {
            final BluetoothLeAdvertiser advertiser = this.getAdvertiserSafely(this.mAdapter);
            if (advertiser != null) {
                AdvertiseSettings settings = new AdvertiseSettings.Builder().setAdvertiseMode(0).build();
                AdvertiseData data = new AdvertiseData.Builder().addManufacturerData(0, new byte[]{0}).build();
                LogManager.i(TAG, "Starting transmitter test", new Object[0]);
                advertiser.startAdvertising(settings, data, new AdvertiseCallback(){

                    public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                        super.onStartSuccess(settingsInEffect);
                        LogManager.i(TAG, "Transmitter test succeeded", new Object[0]);
                        advertiser.stopAdvertising((AdvertiseCallback)this);
                        BluetoothMedic.this.mTransmitterTestResult = true;
                    }

                    public void onStartFailure(int errorCode) {
                        super.onStartFailure(errorCode);
                        Intent intent = new Intent("onStartFailed");
                        intent.putExtra("errorCode", errorCode);
                        LogManager.d(TAG, "Sending onStartFailure broadcast with " + BluetoothMedic.this.mLocalBroadcastManager, new Object[0]);
                        if (BluetoothMedic.this.mLocalBroadcastManager != null) {
                            BluetoothMedic.this.mLocalBroadcastManager.sendBroadcast(intent);
                        }
                        if (errorCode == 4) {
                            BluetoothMedic.this.mTransmitterTestResult = false;
                            LogManager.w(TAG, "Transmitter test failed in a way we consider a test failure", new Object[0]);
                            BluetoothMedic.this.sendNotification(context, "transmitter failed", "bluetooth not ok");
                        } else {
                            BluetoothMedic.this.mTransmitterTestResult = true;
                            LogManager.i(TAG, "Transmitter test failed, but not in a way we consider a test failure", new Object[0]);
                        }
                    }
                });
            } else {
                LogManager.d(TAG, "Cannot get advertiser", new Object[0]);
            }
            while (this.mTransmitterTestResult == null) {
                LogManager.d(TAG, "Waiting for transmitter test to complete...", new Object[0]);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - testStartTime <= 5000L) continue;
                LogManager.d(TAG, "Timeout running transmitter test", new Object[0]);
                break;
            }
        }
        LogManager.d(TAG, "transmitter test complete", new Object[0]);
        return this.mTransmitterTestResult != null && this.mTransmitterTestResult != false;
    }

    @RequiresApi(value=21)
    public void setNotificationsEnabled(boolean enabled, int icon) {
        this.mNotificationsEnabled = enabled;
        this.mNotificationIcon = icon;
    }

    @RequiresApi(value=21)
    private boolean cycleBluetoothIfNotTooSoon() {
        long millisSinceLastCycle = System.currentTimeMillis() - this.mLastBluetoothPowerCycleTime;
        if (millisSinceLastCycle < 60000L) {
            LogManager.d(TAG, "Not cycling bluetooth because we just did so " + millisSinceLastCycle + " milliseconds ago.", new Object[0]);
            return false;
        }
        this.mLastBluetoothPowerCycleTime = System.currentTimeMillis();
        LogManager.d(TAG, "Power cycling bluetooth", new Object[0]);
        this.cycleBluetooth();
        return true;
    }

    @RequiresApi(value=21)
    private void cycleBluetooth() {
        LogManager.d(TAG, "Power cycling bluetooth", new Object[0]);
        LogManager.d(TAG, "Turning Bluetooth off.", new Object[0]);
        if (this.mAdapter != null) {
            this.mAdapter.disable();
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LogManager.d(TAG, "Turning Bluetooth back on.", new Object[0]);
                    if (BluetoothMedic.this.mAdapter != null) {
                        BluetoothMedic.this.mAdapter.enable();
                    }
                }
            }, 1000L);
        } else {
            LogManager.w(TAG, "Cannot cycle bluetooth.  Manager is null.", new Object[0]);
        }
    }

    @RequiresApi(value=21)
    private void sendNotification(Context context, String message, String detail) {
        this.initializeWithContext(context);
        if (this.mNotificationsEnabled) {
            if (!this.mNotificationChannelCreated) {
                this.createNotificationChannel(context, "err");
            }
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, "err").setContentTitle((CharSequence)("BluetoothMedic: " + message)).setSmallIcon(this.mNotificationIcon).setVibrate(new long[]{200L, 100L, 200L}).setContentText((CharSequence)detail);
            TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)context);
            stackBuilder.addNextIntent(new Intent("NoOperation"));
            PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, 0x8000000);
            builder.setContentIntent(resultPendingIntent);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager != null) {
                notificationManager.notify(1, builder.build());
            }
        }
    }

    @RequiresApi(value=21)
    private void createNotificationChannel(Context context, String channelId) {
        if (Build.VERSION.SDK_INT >= 26) {
            String channelName = "Errors";
            String description = "Scan errors";
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, importance);
            channel.setDescription(description);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
            this.mNotificationChannelCreated = true;
        }
    }

    @RequiresApi(value=21)
    private void scheduleRegularTests(Context context) {
        this.initializeWithContext(context);
        ComponentName serviceComponent = new ComponentName(context, BluetoothTestJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(BluetoothTestJob.getJobId(context), serviceComponent);
        builder.setRequiresCharging(false);
        builder.setRequiresDeviceIdle(false);
        builder.setPeriodic(900000L);
        builder.setPersisted(true);
        PersistableBundle bundle = new PersistableBundle();
        bundle.putInt("test_type", this.mTestType);
        builder.setExtras(bundle);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    @RequiresApi(api=21)
    private BluetoothLeAdvertiser getAdvertiserSafely(BluetoothAdapter adapter) {
        try {
            return adapter.getBluetoothLeAdvertiser();
        }
        catch (Exception e) {
            LogManager.w(TAG, "Cannot get bluetoothLeAdvertiser", e);
            return null;
        }
    }
}

