/*
 * Decompiled with CFR 0.152.
 */
package org.antora.gradle;

import java.net.MalformedURLException;
import java.net.URL;
import org.gradle.api.provider.Property;

public abstract class AntoraPlaybookProvider {
    public abstract Property<String> getHost();

    public abstract Property<String> getRepository();

    public abstract Property<String> getBranch();

    public abstract Property<String> getPath();

    public abstract Property<Boolean> getCheckLocalBranch();

    public AntoraPlaybookProvider() {
        this.getHost().convention((Object)"github.com");
        this.getBranch().convention((Object)"docs-build");
        this.getPath().convention((Object)"antora-playbook-template.yml");
        this.getCheckLocalBranch().convention((Object)false);
    }

    public boolean isPresent() {
        return this.getRepository().isPresent() && this.getBranch().isPresent() && this.getPath().isPresent();
    }

    public URL getDownloadUrl() throws MalformedURLException {
        String format = ((String)this.getHost().get()).equals("gitlab.com") ? "https://gitlab.com/%s/-/raw/%s/%s" : "https://raw.githubusercontent.com/%s/%s/%s";
        return new URL(String.format(format, this.getRepository().get(), this.getBranch().get(), this.getPath().get()));
    }

    public String getRevPath() {
        return (String)this.getBranch().get() + ":" + (String)this.getPath().get();
    }

    public String toString() {
        return "{ host = '" + (String)this.getHost().get() + "' repository = '" + (String)this.getRepository().get() + "' branch = '" + (String)this.getBranch().get() + "' path = '" + (String)this.getPath().get() + "' }";
    }
}

