package org.apache.activemq.artemis.core.server;

import java.util.Locale;
import java.io.Serializable;
import org.apache.activemq.artemis.core.config.Configuration;
import org.w3c.dom.Node;
import java.lang.String;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import java.util.List;
import javax.naming.NamingException;
import java.net.SocketAddress;
import java.lang.Boolean;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import io.netty.channel.Channel;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage.BackupRegistrationProblem;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import java.lang.Byte;
import java.lang.Long;
import java.lang.Throwable;
import java.lang.Object;
import java.io.File;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import java.lang.IllegalStateException;
import org.apache.activemq.artemis.api.core.Message;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import java.net.URI;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import java.util.concurrent.Executor;
import org.jboss.logging.BasicLogger;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.api.core.Pair;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import java.lang.Exception;
import java.lang.Integer;
import javax.transaction.xa.Xid;
import java.lang.Runnable;
import java.util.concurrent.ExecutorService;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-12-14T22:55:54-0500")
public class ActiveMQServerLogger_$logger extends DelegatingBasicLogger implements ActiveMQServerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQServerLogger_$logger.class.getName();
    public ActiveMQServerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void interruptWhilstStoppingComponent(final String componentClassName) {
        super.log.logv(FQCN, DEBUG, null, interruptWhilstStoppingComponent$str(), componentClassName);
    }
    protected String interruptWhilstStoppingComponent$str() {
        return "AMQ223000: Received Interrupt Exception whilst waiting for component to shutdown: {0}";
    }
    @Override
    public final void ignoredQuorumVote(final ServerConnectVote vote) {
        super.log.logv(FQCN, DEBUG, null, ignoredQuorumVote$str(), vote);
    }
    protected String ignoredQuorumVote$str() {
        return "AMQ223001: Ignored quorum vote due to quorum reached or vote casted: {0}";
    }
    @Override
    public final void serverStarting(final String type, final Configuration configuration) {
        super.log.logv(FQCN, INFO, null, serverStarting$str(), type, configuration);
    }
    protected String serverStarting$str() {
        return "AMQ221000: {0} Message Broker is starting with configuration {1}";
    }
    @Override
    public final void serverStarted(final String fullVersion, final String name, final SimpleString nodeId, final String identity) {
        super.log.logv(FQCN, INFO, null, serverStarted$str(), fullVersion, name, nodeId, identity);
    }
    protected String serverStarted$str() {
        return "AMQ221001: Apache ActiveMQ Artemis Message Broker version {0} [{1}, nodeID={2}] {3}";
    }
    @Override
    public final void serverStopped(final String version, final SimpleString nodeId, final String uptime) {
        super.log.logv(FQCN, INFO, null, serverStopped$str(), version, nodeId, uptime);
    }
    protected String serverStopped$str() {
        return "AMQ221002: Apache ActiveMQ Artemis Message Broker version {0} [{1}] stopped, uptime {2}";
    }
    @Override
    public final void deployQueue(final String queueName, final String addressName, final String routingType) {
        super.log.logv(FQCN, INFO, null, deployQueue$str(), queueName, addressName, routingType);
    }
    protected String deployQueue$str() {
        return "AMQ221003: Deploying {2} queue {0} on address {1}";
    }
    @Override
    public final void dumpServerInfo(final String serverInfo) {
        super.log.logv(FQCN, INFO, null, dumpServerInfo$str(), serverInfo);
    }
    protected String dumpServerInfo$str() {
        return "AMQ221004: {0}";
    }
    @Override
    public final void deletingPendingMessage(final Pair<Long, Long> msgToDelete) {
        super.log.logv(FQCN, INFO, null, deletingPendingMessage$str(), msgToDelete);
    }
    protected String deletingPendingMessage$str() {
        return "AMQ221005: Deleting pending large message as it was not completed: {0}";
    }
    @Override
    public final void awaitingLiveLock() {
        super.log.logv(FQCN, INFO, null, awaitingLiveLock$str());
    }
    protected String awaitingLiveLock$str() {
        return "AMQ221006: Waiting to obtain live lock";
    }
    @Override
    public final void serverIsLive() {
        super.log.logv(FQCN, INFO, null, serverIsLive0$str());
    }
    protected String serverIsLive0$str() {
        return "AMQ221007: Server is now live";
    }
    @Override
    public final void awaitFailBack() {
        super.log.logv(FQCN, INFO, null, awaitFailBack$str());
    }
    protected String awaitFailBack$str() {
        return "AMQ221008: live server wants to restart, restarting server in backup";
    }
    @Override
    public final void backupServerStarted(final String version, final SimpleString nodeID) {
        super.log.logv(FQCN, INFO, null, backupServerStarted$str(), version, nodeID);
    }
    protected String backupServerStarted$str() {
        return "AMQ221109: Apache ActiveMQ Artemis Backup Server version {0} [{1}] started, waiting live to fail before it gets active";
    }
    @Override
    public final void backupServerIsLive() {
        super.log.logv(FQCN, INFO, null, backupServerIsLive$str());
    }
    protected String backupServerIsLive$str() {
        return "AMQ221010: Backup Server is now live";
    }
    @Override
    public final void serverIsLive(final String identity) {
        super.log.logv(FQCN, INFO, null, serverIsLive1$str(), identity);
    }
    protected String serverIsLive1$str() {
        return "AMQ221011: Server {0} is now live";
    }
    @Override
    public final void journalUseAIO() {
        super.log.logv(FQCN, INFO, null, journalUseAIO$str());
    }
    protected String journalUseAIO$str() {
        return "AMQ221012: Using AIO Journal";
    }
    @Override
    public final void journalUseNIO() {
        super.log.logv(FQCN, INFO, null, journalUseNIO$str());
    }
    protected String journalUseNIO$str() {
        return "AMQ221013: Using NIO Journal";
    }
    @Override
    public final void percentLoaded(final Long percent) {
        super.log.logv(FQCN, INFO, null, percentLoaded$str(), percent);
    }
    protected String percentLoaded$str() {
        return "AMQ221014: {0}% loaded";
    }
    @Override
    public final void journalCannotFindQueueReloading(final Long queueID) {
        super.log.logv(FQCN, INFO, null, journalCannotFindQueueReloading$str(), queueID);
    }
    protected String journalCannotFindQueueReloading$str() {
        return "AMQ221015: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR, deleting record now";
    }
    @Override
    public final void journalCannotFindQueueReloadingPage(final Long queueID) {
        super.log.logv(FQCN, INFO, null, journalCannotFindQueueReloadingPage$str(), queueID);
    }
    protected String journalCannotFindQueueReloadingPage$str() {
        return "AMQ221016: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now";
    }
    @Override
    public final void journalCannotFindQueueReloadingPageCursor(final Long queueID) {
        super.log.logv(FQCN, INFO, null, journalCannotFindQueueReloadingPageCursor$str(), queueID);
    }
    protected String journalCannotFindQueueReloadingPageCursor$str() {
        return "AMQ221017: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now";
    }
    @Override
    public final void largeMessageWithNoRef(final Long messageID) {
        super.log.logv(FQCN, INFO, null, largeMessageWithNoRef$str(), messageID);
    }
    protected String largeMessageWithNoRef$str() {
        return "AMQ221018: Large message: {0} did not have any associated reference, file will be deleted";
    }
    @Override
    public final void journalUnreferencedMessage(final Long messageID) {
        super.log.logv(FQCN, INFO, null, journalUnreferencedMessage$str(), messageID);
    }
    protected String journalUnreferencedMessage$str() {
        return "AMQ221019: Deleting unreferenced message id={0} from the journal";
    }
    @Override
    public final void startedAcceptor(final String acceptorType, final String host, final Integer port, final String enabledProtocols) {
        super.log.logv(FQCN, INFO, null, startedAcceptor$str(), acceptorType, host, port, enabledProtocols);
    }
    protected String startedAcceptor$str() {
        return "AMQ221020: Started {0} Acceptor at {1}:{2,number,#} for protocols [{3}]";
    }
    @Override
    public final void errorRemovingConnection() {
        super.log.logv(FQCN, INFO, null, errorRemovingConnection$str());
    }
    protected String errorRemovingConnection$str() {
        return "AMQ221021: failed to remove connection";
    }
    @Override
    public final void errorStartingConnectorService(final Throwable e, final String name) {
        super.log.logv(FQCN, INFO, e, errorStartingConnectorService$str(), name);
    }
    protected String errorStartingConnectorService$str() {
        return "AMQ221022: unable to start connector service: {0}";
    }
    @Override
    public final void errorStoppingConnectorService(final Throwable e, final String name) {
        super.log.logv(FQCN, INFO, e, errorStoppingConnectorService$str(), name);
    }
    protected String errorStoppingConnectorService$str() {
        return "AMQ221023: unable to stop connector service: {0}";
    }
    @Override
    public final void backupServerSynchronized(final ActiveMQServerImpl server, final String liveID) {
        super.log.logv(FQCN, INFO, null, backupServerSynchronized$str(), server, liveID);
    }
    protected String backupServerSynchronized$str() {
        return "AMQ221024: Backup server {0} is synchronized with live server, nodeID={1}.";
    }
    @Override
    public final void replicaSyncFile(final SequentialFile jf, final Long size) {
        super.log.logv(FQCN, INFO, null, replicaSyncFile$str(), jf, size);
    }
    protected String replicaSyncFile$str() {
        return "AMQ221025: Replication: sending {0} (size={1}) to replica.";
    }
    @Override
    public final void bridgeNoBindings(final SimpleString name, final SimpleString forwardingAddress, final SimpleString address) {
        super.log.logv(FQCN, INFO, null, bridgeNoBindings$str(), name, forwardingAddress, address);
    }
    protected String bridgeNoBindings$str() {
        return "AMQ221026: Bridge {0} connected to forwardingAddress={1}. {2} does not have any bindings. Messages will be ignored until a binding is created.";
    }
    @Override
    public final void bridgeConnected(final BridgeImpl name) {
        super.log.logv(FQCN, INFO, null, bridgeConnected$str(), name);
    }
    protected String bridgeConnected$str() {
        return "AMQ221027: Bridge {0} is connected";
    }
    @Override
    public final void bridgeStopping() {
        super.log.logv(FQCN, INFO, null, bridgeStopping$str());
    }
    protected String bridgeStopping$str() {
        return "AMQ221028: Bridge is stopping, will not retry";
    }
    @Override
    public final void bridgeStopped(final SimpleString name) {
        super.log.logv(FQCN, INFO, null, bridgeStopped$str(), name);
    }
    protected String bridgeStopped$str() {
        return "AMQ221029: stopped bridge {0}";
    }
    @Override
    public final void bridgePaused(final SimpleString name) {
        super.log.logv(FQCN, INFO, null, bridgePaused$str(), name);
    }
    protected String bridgePaused$str() {
        return "AMQ221030: paused bridge {0}";
    }
    @Override
    public final void backupAnnounced() {
        super.log.logv(FQCN, INFO, null, backupAnnounced$str());
    }
    protected String backupAnnounced$str() {
        return "AMQ221031: backup announced";
    }
    @Override
    public final void waitingToBecomeBackup() {
        super.log.logv(FQCN, INFO, null, waitingToBecomeBackup$str());
    }
    protected String waitingToBecomeBackup$str() {
        return "AMQ221032: Waiting to become backup node";
    }
    @Override
    public final void gotBackupLock() {
        super.log.logv(FQCN, INFO, null, gotBackupLock$str());
    }
    protected String gotBackupLock$str() {
        return "AMQ221033: ** got backup lock";
    }
    @Override
    public final void waitingToObtainLiveLock(final String timeoutMessage) {
        super.log.logv(FQCN, INFO, null, waitingToObtainLiveLock$str(), timeoutMessage);
    }
    protected String waitingToObtainLiveLock$str() {
        return "AMQ221034: Waiting {0} to obtain live lock";
    }
    @Override
    public final void obtainedLiveLock() {
        super.log.logv(FQCN, INFO, null, obtainedLiveLock$str());
    }
    protected String obtainedLiveLock$str() {
        return "AMQ221035: Live Server Obtained live lock";
    }
    @Override
    public final void messageWithDuplicateID(final Object duplicateProperty, final SimpleString toAddress, final SimpleString address, final SimpleString simpleString) {
        super.log.logv(FQCN, INFO, null, messageWithDuplicateID$str(), duplicateProperty, toAddress, address, simpleString);
    }
    protected String messageWithDuplicateID$str() {
        return "AMQ221036: Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored and message removed from {3}";
    }
    @Override
    public final void becomingLive(final org.apache.activemq.artemis.core.server.ActiveMQServer server) {
        super.log.logv(FQCN, INFO, null, becomingLive$str(), server);
    }
    protected String becomingLive$str() {
        return "AMQ221037: {0} to become ''live''";
    }
    @Override
    public final void deprecatedConfigurationOption(final String deprecatedOption) {
        super.log.logv(FQCN, INFO, null, deprecatedConfigurationOption$str(), deprecatedOption);
    }
    protected String deprecatedConfigurationOption$str() {
        return "AMQ221038: Configuration option ''{0}'' is deprecated. Consult the manual for details.";
    }
    @Override
    public final void restartingReplicatedBackupAfterFailback() {
        super.log.logv(FQCN, INFO, null, restartingReplicatedBackupAfterFailback$str());
    }
    protected String restartingReplicatedBackupAfterFailback$str() {
        return "AMQ221039: Restarting as Replicating backup server after live restart";
    }
    @Override
    public final void remoteGroupCoordinatorsNotStarted() {
        super.log.logv(FQCN, INFO, null, remoteGroupCoordinatorsNotStarted$str());
    }
    protected String remoteGroupCoordinatorsNotStarted$str() {
        return "AMQ221040: Remote group coordinators has not started.";
    }
    @Override
    public final void cantFindQueueOnPageComplete(final long queueID) {
        super.log.logv(FQCN, INFO, null, cantFindQueueOnPageComplete$str(), queueID);
    }
    protected String cantFindQueueOnPageComplete$str() {
        return "AMQ221041: Cannot find queue {0} while reloading PAGE_CURSOR_COMPLETE, deleting record now";
    }
    @Override
    public final void timedOutWaitingCompletions(final String bridgeName, final long numberOfMessages) {
        super.log.logv(FQCN, INFO, null, timedOutWaitingCompletions$str(), bridgeName, numberOfMessages);
    }
    protected String timedOutWaitingCompletions$str() {
        return "AMQ221042: Bridge {0} timed out waiting for the completion of {1} messages, we will just shutdown the bridge after 10 seconds wait";
    }
    @Override
    public final void addingProtocolSupport(final String protocolKey, final String moduleName) {
        super.log.logv(FQCN, INFO, null, addingProtocolSupport$str(), protocolKey, moduleName);
    }
    protected String addingProtocolSupport$str() {
        return "AMQ221043: Protocol module found: [{1}]. Adding protocol support for: {0}";
    }
    @Override
    public final void switchingNIO() {
        super.log.logv(FQCN, INFO, null, switchingNIO$str());
    }
    protected String switchingNIO$str() {
        return "AMQ221045: libaio is not available, switching the configuration into NIO";
    }
    @Override
    public final void unblockingMessageProduction(final SimpleString addressName, final long currentSize, final long maxSize) {
        super.log.logv(FQCN, INFO, null, unblockingMessageProduction$str(), addressName, currentSize, maxSize);
    }
    protected String unblockingMessageProduction$str() {
        return "AMQ221046: Unblocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}";
    }
    @Override
    public final void backupServerScaledDown() {
        super.log.logv(FQCN, INFO, null, backupServerScaledDown$str());
    }
    protected String backupServerScaledDown$str() {
        return "AMQ221047: Backup Server has scaled down to live server";
    }
    @Override
    public final void slowConsumerDetected(final String sessionID, final long consumerID, final String queueName, final String remoteAddress, final float slowConsumerThreshold, final float consumerRate) {
        super.log.logv(FQCN, INFO, null, slowConsumerDetected$str(), sessionID, consumerID, queueName, remoteAddress, slowConsumerThreshold, consumerRate);
    }
    protected String slowConsumerDetected$str() {
        return "AMQ221048: Consumer {0}:{1} attached to queue ''{2}'' from {3} identified as ''slow.'' Expected consumption rate: {4} msgs/second; actual consumption rate: {5} msgs/second.";
    }
    @Override
    public final void activatingReplica(final SimpleString nodeID) {
        super.log.logv(FQCN, INFO, null, activatingReplica$str(), nodeID);
    }
    protected String activatingReplica$str() {
        return "AMQ221049: Activating Replica for node: {0}";
    }
    @Override
    public final void activatingSharedStoreSlave() {
        super.log.logv(FQCN, INFO, null, activatingSharedStoreSlave$str());
    }
    protected String activatingSharedStoreSlave$str() {
        return "AMQ221050: Activating Shared Store Slave";
    }
    @Override
    public final void populatingSecurityRolesFromLDAP(final String url) {
        super.log.logv(FQCN, INFO, null, populatingSecurityRolesFromLDAP$str(), url);
    }
    protected String populatingSecurityRolesFromLDAP$str() {
        return "AMQ221051: Populating security roles from LDAP at: {0}";
    }
    @Override
    public final void deployTopic(final SimpleString topicName) {
        super.log.logv(FQCN, INFO, null, deployTopic$str(), topicName);
    }
    protected String deployTopic$str() {
        return "AMQ221052: Deploying topic {0}";
    }
    @Override
    public final void disallowedProtocol(final String protocol, final String acceptorName) {
        super.log.logv(FQCN, INFO, null, disallowedProtocol$str(), protocol, acceptorName);
    }
    protected String disallowedProtocol$str() {
        return "AMQ221053: Disallowing use of vulnerable protocol ''{0}'' on acceptor ''{1}''. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.";
    }
    @Override
    public final void switchingNIOonPath(final String journalPath) {
        super.log.logv(FQCN, INFO, null, switchingNIOonPath$str(), journalPath);
    }
    protected String switchingNIOonPath$str() {
        return "AMQ221054: libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {0}";
    }
    @Override
    public final void removingBackupData(final String path) {
        super.log.logv(FQCN, INFO, null, removingBackupData$str(), path);
    }
    protected String removingBackupData$str() {
        return "AMQ221055: There were too many old replicated folders upon startup, removing {0}";
    }
    @Override
    public final void reloadingConfiguration(final String module) {
        super.log.logv(FQCN, INFO, null, reloadingConfiguration$str(), module);
    }
    protected String reloadingConfiguration$str() {
        return "AMQ221056: Reloading configuration: {0}";
    }
    @Override
    public final void usingDefaultPaging(final long bytes) {
        super.log.logv(FQCN, INFO, null, usingDefaultPaging$str(), bytes);
    }
    protected String usingDefaultPaging$str() {
        return "AMQ221057: Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {0}";
    }
    @Override
    public final void invalidJournalFileSize(final int journalFileSize, final int fileSize, final int alignment) {
        super.log.logv(FQCN, INFO, null, invalidJournalFileSize$str(), journalFileSize, fileSize, alignment);
    }
    protected String invalidJournalFileSize$str() {
        return "AMQ221058: resetting Journal File size from {0} to {1} to fit with alignment of {2}";
    }
    @Override
    public final void backupDeletingData(final String oldPath) {
        super.log.logv(FQCN, INFO, null, backupDeletingData$str(), oldPath);
    }
    protected String backupDeletingData$str() {
        return "AMQ221059: Deleting old data directory {0} as the max folders is set to 0";
    }
    @Override
    public final void sendingQuorumVoteRequest(final String remoteAddress, final String vote) {
        super.log.logv(FQCN, INFO, null, sendingQuorumVoteRequest$str(), remoteAddress, vote);
    }
    protected String sendingQuorumVoteRequest$str() {
        return "AMQ221060: Sending quorum vote request to {0}: {1}";
    }
    @Override
    public final void receivedQuorumVoteResponse(final String remoteAddress, final String vote) {
        super.log.logv(FQCN, INFO, null, receivedQuorumVoteResponse$str(), remoteAddress, vote);
    }
    protected String receivedQuorumVoteResponse$str() {
        return "AMQ221061: Received quorum vote response from {0}: {1}";
    }
    @Override
    public final void receivedQuorumVoteRequest(final String vote) {
        super.log.logv(FQCN, INFO, null, receivedQuorumVoteRequest$str(), vote);
    }
    protected String receivedQuorumVoteRequest$str() {
        return "AMQ221062: Received quorum vote request: {0}";
    }
    @Override
    public final void sendingQuorumVoteResponse(final String vote) {
        super.log.logv(FQCN, INFO, null, sendingQuorumVoteResponse$str(), vote);
    }
    protected String sendingQuorumVoteResponse$str() {
        return "AMQ221063: Sending quorum vote response: {0}";
    }
    @Override
    public final void nodeFoundInClusterTopology(final String nodeId) {
        super.log.logv(FQCN, INFO, null, nodeFoundInClusterTopology$str(), nodeId);
    }
    protected String nodeFoundInClusterTopology$str() {
        return "AMQ221064: Node {0} found in cluster topology";
    }
    @Override
    public final void nodeNotFoundInClusterTopology(final String nodeId) {
        super.log.logv(FQCN, INFO, null, nodeNotFoundInClusterTopology$str(), nodeId);
    }
    protected String nodeNotFoundInClusterTopology$str() {
        return "AMQ221065: Node {0} not found in cluster topology";
    }
    @Override
    public final void initiatingQuorumVote(final SimpleString vote) {
        super.log.logv(FQCN, INFO, null, initiatingQuorumVote$str(), vote);
    }
    protected String initiatingQuorumVote$str() {
        return "AMQ221066: Initiating quorum vote: {0}";
    }
    @Override
    public final void waitingForQuorumVoteResults(final int timeout, final String unit) {
        super.log.logv(FQCN, INFO, null, waitingForQuorumVoteResults$str(), timeout, unit);
    }
    protected String waitingForQuorumVoteResults$str() {
        return "AMQ221067: Waiting {0} {1} for quorum vote results.";
    }
    @Override
    public final void receivedAllQuorumVotes() {
        super.log.logv(FQCN, INFO, null, receivedAllQuorumVotes$str());
    }
    protected String receivedAllQuorumVotes$str() {
        return "AMQ221068: Received all quorum votes.";
    }
    @Override
    public final void timeoutWaitingForQuorumVoteResponses() {
        super.log.logv(FQCN, INFO, null, timeoutWaitingForQuorumVoteResponses$str());
    }
    protected String timeoutWaitingForQuorumVoteResponses$str() {
        return "AMQ221069: Timeout waiting for quorum vote responses.";
    }
    @Override
    public final void restartingAsBackupBasedOnQuorumVoteResults() {
        super.log.logv(FQCN, INFO, null, restartingAsBackupBasedOnQuorumVoteResults$str());
    }
    protected String restartingAsBackupBasedOnQuorumVoteResults$str() {
        return "AMQ221070: Restarting as backup based on quorum vote results.";
    }
    @Override
    public final void failingOverBasedOnQuorumVoteResults() {
        super.log.logv(FQCN, INFO, null, failingOverBasedOnQuorumVoteResults$str());
    }
    protected String failingOverBasedOnQuorumVoteResults$str() {
        return "AMQ221071: Failing over based on quorum vote results.";
    }
    @Override
    public final void failedToFindRolesForTheSubject(final Exception e) {
        super.log.logv(FQCN, INFO, e, failedToFindRolesForTheSubject$str());
    }
    protected String failedToFindRolesForTheSubject$str() {
        return "AMQ221072: Can't find roles for the subject.";
    }
    @Override
    public final void failedAddRolePrincipal(final Exception e) {
        super.log.logv(FQCN, INFO, e, failedAddRolePrincipal$str());
    }
    protected String failedAddRolePrincipal$str() {
        return "AMQ221073: Can't add role principal.";
    }
    @Override
    public final void debugStarted(final Long globalSizeBytes, final Long numberOfMessages) {
        super.log.logv(FQCN, INFO, null, debugStarted$str(), globalSizeBytes, numberOfMessages);
    }
    protected String debugStarted$str() {
        return "AMQ221074: Debug started : size = {0} bytes, messages = {1}";
    }
    @Override
    public final void deprecatedWildcardRoutingEnabled() {
        super.log.logv(FQCN, INFO, null, deprecatedWildcardRoutingEnabled$str());
    }
    protected String deprecatedWildcardRoutingEnabled$str() {
        return "AMQ221075: Usage of wildcardRoutingEnabled configuration property is deprecated, please use wildCardConfiguration.enabled instead";
    }
    @Override
    public final void onDestroyConnectionWithSessionMetadata(final String msg) {
        super.log.logv(FQCN, INFO, null, onDestroyConnectionWithSessionMetadata$str(), msg);
    }
    protected String onDestroyConnectionWithSessionMetadata$str() {
        return "AMQ221076: {0}";
    }
    @Override
    public final void infoNoQueueWithID(final Long id, final Long record) {
        super.log.logv(FQCN, INFO, null, infoNoQueueWithID$str(), id, record);
    }
    protected String infoNoQueueWithID$str() {
        return "AMQ221077: There is no queue with ID {0}, deleting record {1}";
    }
    @Override
    public final void infoScaledDownMessages(final Long num) {
        super.log.logv(FQCN, INFO, null, infoScaledDownMessages$str(), num);
    }
    protected String infoScaledDownMessages$str() {
        return "AMQ221078: Scaled down {0} messages total.";
    }
    @Override
    public final void ignoringPrepareOnXidAlreadyCalled(final String xid) {
        super.log.logv(FQCN, INFO, null, ignoringPrepareOnXidAlreadyCalled$str(), xid);
    }
    protected String ignoringPrepareOnXidAlreadyCalled$str() {
        return "AMQ221079: Ignoring prepare on xid as already called : {0}";
    }
    @Override
    public final void deployAddress(final String addressName, final String routingTypes) {
        super.log.logv(FQCN, INFO, null, deployAddress$str(), addressName, routingTypes);
    }
    protected String deployAddress$str() {
        return "AMQ221080: Deploying address {0} supporting {1}";
    }
    @Override
    public final void infoNoAddressWithID(final Long id, final Long record) {
        super.log.logv(FQCN, INFO, null, infoNoAddressWithID$str(), id, record);
    }
    protected String infoNoAddressWithID$str() {
        return "AMQ221081: There is no address with ID {0}, deleting record {1}";
    }
    @Override
    public final void initializingMetricsPlugin(final String clazz, final String properties) {
        super.log.logv(FQCN, INFO, null, initializingMetricsPlugin$str(), clazz, properties);
    }
    protected String initializingMetricsPlugin$str() {
        return "AMQ221082: Initializing metrics plugin {0} with properties: {1}";
    }
    @Override
    public final void ignoringQuorumVote(final int maxClusterSize) {
        super.log.logv(FQCN, INFO, null, ignoringQuorumVote$str(), maxClusterSize);
    }
    protected String ignoringQuorumVote$str() {
        return "AMQ221083: ignoring quorum vote as max cluster size is {0}.";
    }
    @Override
    public final void requestedQuorumVotes(final int vote) {
        super.log.logv(FQCN, INFO, null, requestedQuorumVotes$str(), vote);
    }
    protected String requestedQuorumVotes$str() {
        return "AMQ221084: Requested {0} quorum votes";
    }
    @Override
    public final void redirectClientConnection(final Connection connection, final Target target) {
        super.log.logv(FQCN, INFO, null, redirectClientConnection$str(), connection, target);
    }
    protected String redirectClientConnection$str() {
        return "AMQ221085: Redirect {0} to {1}";
    }
    @Override
    public final void cannotRedirectClientConnection(final Connection connection) {
        super.log.logv(FQCN, INFO, null, cannotRedirectClientConnection$str(), connection);
    }
    protected String cannotRedirectClientConnection$str() {
        return "AMQ221086: Cannot redirect {0}";
    }
    @Override
    public final void serverFinalisedWIthoutBeingSTopped() {
        super.log.logv(FQCN, WARN, null, serverFinalisedWIthoutBeingSTopped$str());
    }
    protected String serverFinalisedWIthoutBeingSTopped$str() {
        return "AMQ222000: ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope";
    }
    @Override
    public final void errorClosingSessionsWhileStoppingServer(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorClosingSessionsWhileStoppingServer$str());
    }
    protected String errorClosingSessionsWhileStoppingServer$str() {
        return "AMQ222001: Error closing sessions while stopping server";
    }
    @Override
    public final void timedOutStoppingThreadpool(final ExecutorService service) {
        super.log.logv(FQCN, WARN, null, timedOutStoppingThreadpool$str(), service);
    }
    protected String timedOutStoppingThreadpool$str() {
        return "AMQ222002: Timed out waiting for pool to terminate {0}. Interrupting all its threads!";
    }
    @Override
    public final void divertWithNoAddress() {
        super.log.logv(FQCN, WARN, null, divertWithNoAddress$str());
    }
    protected String divertWithNoAddress$str() {
        return "AMQ222004: Must specify an address for each divert. This one will not be deployed.";
    }
    @Override
    public final void divertWithNoForwardingAddress() {
        super.log.logv(FQCN, WARN, null, divertWithNoForwardingAddress$str());
    }
    protected String divertWithNoForwardingAddress$str() {
        return "AMQ222005: Must specify a forwarding address for each divert. This one will not be deployed.";
    }
    @Override
    public final void divertBindingAlreadyExists(final SimpleString bindingName) {
        super.log.logv(FQCN, WARN, null, divertBindingAlreadyExists$str(), bindingName);
    }
    protected String divertBindingAlreadyExists$str() {
        return "AMQ222006: Binding already exists with name {0}, divert will not be deployed";
    }
    @Override
    public final void clusterSecurityRisk() {
        super.log.logv(FQCN, WARN, null, clusterSecurityRisk$str());
    }
    protected String clusterSecurityRisk$str() {
        return "AMQ222007: Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.";
    }
    @Override
    public final void serverRestartWarning(final Exception e) {
        super.log.logv(FQCN, WARN, e, serverRestartWarning$str());
    }
    protected String serverRestartWarning$str() {
        return "AMQ222008: unable to restart server, please kill and restart manually";
    }
    @Override
    public final void replicationStartProblem(final Exception e) {
        super.log.logv(FQCN, WARN, e, replicationStartProblem$str());
    }
    protected String replicationStartProblem$str() {
        return "AMQ222009: Unable to announce backup for replication. Trying to stop the server.";
    }
    @Override
    public final void ioCriticalIOError(final String message, final String file, final Throwable code) {
        super.log.logv(FQCN, WARN, code, ioCriticalIOError$str(), message, file);
    }
    protected String ioCriticalIOError$str() {
        return "AMQ222010: Critical IO Error, shutting down the server. file={1}, message={0}";
    }
    @Override
    public final void errorStoppingServer(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorStoppingServer$str());
    }
    protected String errorStoppingServer$str() {
        return "AMQ222011: Error stopping server";
    }
    @Override
    public final void backupActivationProblem() {
        super.log.logv(FQCN, WARN, null, backupActivationProblem$str());
    }
    protected String backupActivationProblem$str() {
        return "AMQ222012: Timed out waiting for backup activation to exit";
    }
    @Override
    public final void errorStartingReplication(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorStartingReplication0$str());
    }
    protected String errorStartingReplication0$str() {
        return "AMQ222013: Error when trying to start replication";
    }
    @Override
    public final void errorStoppingReplication(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorStoppingReplication$str());
    }
    protected String errorStoppingReplication$str() {
        return "AMQ222014: Error when trying to stop replication";
    }
    @Override
    public final void connectorWithNoName() {
        super.log.logv(FQCN, WARN, null, connectorWithNoName$str());
    }
    protected String connectorWithNoName$str() {
        return "AMQ222016: Cannot deploy a connector with no name specified.";
    }
    @Override
    public final void connectorAlreadyDeployed(final String name) {
        super.log.logv(FQCN, WARN, null, connectorAlreadyDeployed$str(), name);
    }
    protected String connectorAlreadyDeployed$str() {
        return "AMQ222017: There is already a connector with name {0} deployed. This one will not be deployed.";
    }
    @Override
    public final void AIONotFound() {
        super.log.logv(FQCN, WARN, null, AIONotFound$str());
    }
    protected String AIONotFound$str() {
        return "AMQ222018: AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal";
    }
    @Override
    public final void discoveryGroupAlreadyDeployed(final String name) {
        super.log.logv(FQCN, WARN, null, discoveryGroupAlreadyDeployed$str(), name);
    }
    protected String discoveryGroupAlreadyDeployed$str() {
        return "AMQ222019: There is already a discovery group with name {0} deployed. This one will not be deployed.";
    }
    @Override
    public final void errorScanningURLs(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorScanningURLs$str());
    }
    protected String errorScanningURLs$str() {
        return "AMQ222020: error scanning for URL''s";
    }
    @Override
    public final void problemUndeployingNode(final Exception e, final Node node) {
        super.log.logv(FQCN, WARN, e, problemUndeployingNode$str(), node);
    }
    protected String problemUndeployingNode$str() {
        return "AMQ222021: problem undeploying {0}";
    }
    @Override
    public final void timedOutStoppingPagingCursor(final Executor executor) {
        super.log.logv(FQCN, WARN, null, timedOutStoppingPagingCursor$str(), executor);
    }
    protected String timedOutStoppingPagingCursor$str() {
        return "AMQ222022: Timed out waiting for paging cursor to stop {0}";
    }
    @Override
    public final void problemCleaningPageAddress(final Exception e, final SimpleString address) {
        super.log.logv(FQCN, WARN, e, problemCleaningPageAddress$str(), address);
    }
    protected String problemCleaningPageAddress$str() {
        return "AMQ222023: problem cleaning page address {0}";
    }
    @Override
    public final void problemCompletingOperations(final OperationContext e) {
        super.log.logv(FQCN, WARN, null, problemCompletingOperations$str(), e);
    }
    protected String problemCompletingOperations$str() {
        return "AMQ222024: Could not complete operations on IO context {0}";
    }
    @Override
    public final void problemCleaningPagesubscriptionCounter(final Exception e) {
        super.log.logv(FQCN, WARN, e, problemCleaningPagesubscriptionCounter$str());
    }
    protected String problemCleaningPagesubscriptionCounter$str() {
        return "AMQ222025: Problem cleaning page subscription counter";
    }
    @Override
    public final void problemCleaningCursorPages(final Exception e) {
        super.log.logv(FQCN, WARN, e, problemCleaningCursorPages$str());
    }
    protected String problemCleaningCursorPages$str() {
        return "AMQ222026: Error on cleaning up cursor pages";
    }
    @Override
    public final void timedOutFlushingExecutorsPagingCursor(final PageSubscription pageSubscription) {
        super.log.logv(FQCN, WARN, null, timedOutFlushingExecutorsPagingCursor$str(), pageSubscription);
    }
    protected String timedOutFlushingExecutorsPagingCursor$str() {
        return "AMQ222027: Timed out flushing executors for paging cursor to stop {0}";
    }
    @Override
    public final void pageNotFound(final PagePosition pos, final long queueID, final String queue) {
        super.log.logv(FQCN, WARN, null, pageNotFound$str(), pos, queueID, queue);
    }
    protected String pageNotFound$str() {
        return "AMQ222028: Could not find page cache for page {0}, on queue {1}/{2} removing it from the journal";
    }
    @Override
    public final void pageSubscriptionCouldntLoad(final long transactionID, final PagePosition position, final SimpleString address, final SimpleString name) {
        super.log.logv(FQCN, WARN, null, pageSubscriptionCouldntLoad$str(), transactionID, position, address, name);
    }
    protected String pageSubscriptionCouldntLoad$str() {
        return "AMQ222029: Could not locate page transaction {0}, ignoring message on position {1} on address={2} queue={3}";
    }
    @Override
    public final void pageInvalid(final String fileName, final String name) {
        super.log.logv(FQCN, WARN, null, pageInvalid$str(), fileName, name);
    }
    protected String pageInvalid$str() {
        return "AMQ222030: File {0} being renamed to {1}.invalidPage as it was loaded partially. Please verify your data.";
    }
    @Override
    public final void pageDeleteError(final Exception e) {
        super.log.logv(FQCN, WARN, e, pageDeleteError$str());
    }
    protected String pageDeleteError$str() {
        return "AMQ222031: Error while deleting page file";
    }
    @Override
    public final void pageFinaliseError(final Exception e) {
        super.log.logv(FQCN, WARN, e, pageFinaliseError$str());
    }
    protected String pageFinaliseError$str() {
        return "AMQ222032: page finalise error";
    }
    @Override
    public final void pageSuspectFile(final String fileName, final int position, final int msgNumber) {
        super.log.logv(FQCN, WARN, null, pageSuspectFile$str(), fileName, position, msgNumber);
    }
    protected String pageSuspectFile$str() {
        return "AMQ222033: Page file {0} had incomplete records at position {1} at record number {2}";
    }
    @Override
    public final void pageTxDeleteError(final Exception e, final long recordID) {
        super.log.logv(FQCN, WARN, e, pageTxDeleteError$str(), recordID);
    }
    protected String pageTxDeleteError$str() {
        return "AMQ222034: Can not delete page transaction id={0}";
    }
    @Override
    public final void pageStoreFactoryNoIdFile(final String s, final String addressFile) {
        super.log.logv(FQCN, WARN, null, pageStoreFactoryNoIdFile$str(), s, addressFile);
    }
    protected String pageStoreFactoryNoIdFile$str() {
        return "AMQ222035: Directory {0} did not have an identification file {1}";
    }
    @Override
    public final void pageStoreTimeout(final SimpleString address) {
        super.log.logv(FQCN, WARN, null, pageStoreTimeout$str(), address);
    }
    protected String pageStoreTimeout$str() {
        return "AMQ222036: Timed out on waiting PagingStore {0} to shutdown";
    }
    @Override
    public final void pageStoreStartIOError(final Exception e) {
        super.log.logv(FQCN, WARN, e, pageStoreStartIOError$str());
    }
    protected String pageStoreStartIOError$str() {
        return "AMQ222037: IO Error, impossible to start paging";
    }
    @Override
    public final void pageStoreStart(final SimpleString storeName, final long addressSize, final long maxSize, final long globalMaxSize) {
        super.log.logv(FQCN, WARN, null, pageStoreStart$str(), storeName, addressSize, maxSize, globalMaxSize);
    }
    protected String pageStoreStart$str() {
        return "AMQ222038: Starting paging on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }
    @Override
    public final void pageStoreDropMessages(final SimpleString storeName, final long addressSize, final long maxSize, final long globalMaxSize) {
        super.log.logv(FQCN, WARN, null, pageStoreDropMessages$str(), storeName, addressSize, maxSize, globalMaxSize);
    }
    protected String pageStoreDropMessages$str() {
        return "AMQ222039: Messages sent to address ''{0}'' are being dropped; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }
    @Override
    public final void serverIsStopped() {
        super.log.logv(FQCN, WARN, null, serverIsStopped$str());
    }
    protected String serverIsStopped$str() {
        return "AMQ222040: Server is stopped";
    }
    @Override
    public final void journalCannotFindQueueDelCount(final Long queueID) {
        super.log.logv(FQCN, WARN, null, journalCannotFindQueueDelCount$str(), queueID);
    }
    protected String journalCannotFindQueueDelCount$str() {
        return "AMQ222041: Cannot find queue {0} to update delivery count";
    }
    @Override
    public final void journalCannotFindMessageDelCount(final Long msg) {
        super.log.logv(FQCN, WARN, null, journalCannotFindMessageDelCount$str(), msg);
    }
    protected String journalCannotFindMessageDelCount$str() {
        return "AMQ222042: Cannot find message {0} to update delivery count";
    }
    @Override
    public final void journalCannotFindQueueForMessage(final Long queueID) {
        super.log.logv(FQCN, WARN, null, journalCannotFindQueueForMessage$str(), queueID);
    }
    protected String journalCannotFindQueueForMessage$str() {
        return "AMQ222043: Message for queue {0} which does not exist. This message will be ignored.";
    }
    @Override
    public final void journalErrorDeletingMessage(final Exception e, final Long messageID) {
        super.log.logv(FQCN, WARN, e, journalErrorDeletingMessage$str(), messageID);
    }
    protected String journalErrorDeletingMessage$str() {
        return "AMQ222044: It was not possible to delete message {0}";
    }
    @Override
    public final void journalMessageInPreparedTX(final Long queueID) {
        super.log.logv(FQCN, WARN, null, journalMessageInPreparedTX$str(), queueID);
    }
    protected String journalMessageInPreparedTX$str() {
        return "AMQ222045: Message in prepared tx for queue {0} which does not exist. This message will be ignored.";
    }
    @Override
    public final void journalErrorRemovingRef(final Long messageID) {
        super.log.logv(FQCN, WARN, null, journalErrorRemovingRef$str(), messageID);
    }
    protected String journalErrorRemovingRef$str() {
        return "AMQ222046: Failed to remove reference for {0}";
    }
    @Override
    public final void journalCannotFindQueueReloadingACK(final Long queueID) {
        super.log.logv(FQCN, WARN, null, journalCannotFindQueueReloadingACK$str(), queueID);
    }
    protected String journalCannotFindQueueReloadingACK$str() {
        return "AMQ222047: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR";
    }
    @Override
    public final void journalPAGEOnPrepared() {
        super.log.logv(FQCN, WARN, null, journalPAGEOnPrepared$str());
    }
    protected String journalPAGEOnPrepared$str() {
        return "AMQ222048: PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state";
    }
    @Override
    public final void journalInvalidRecordType(final Byte recordType) {
        super.log.logv(FQCN, WARN, null, journalInvalidRecordType$str(), recordType);
    }
    protected String journalInvalidRecordType$str() {
        return "AMQ222049: InternalError: Record type {0} not recognized. Maybe you are using journal files created on a different version";
    }
    @Override
    public final void journalInvalidRecordTypeOnPreparedTX(final Byte recordType) {
        super.log.logv(FQCN, WARN, null, journalInvalidRecordTypeOnPreparedTX$str(), recordType);
    }
    protected String journalInvalidRecordTypeOnPreparedTX$str() {
        return "AMQ222050: Can not locate recordType={0} on loadPreparedTransaction//deleteRecords";
    }
    @Override
    public final void journalError(final Exception e) {
        super.log.logv(FQCN, WARN, e, journalError$str());
    }
    protected String journalError$str() {
        return "AMQ222051: Journal Error";
    }
    @Override
    public final void errorIncrementDelayDeletionCount(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorIncrementDelayDeletionCount$str());
    }
    protected String errorIncrementDelayDeletionCount$str() {
        return "AMQ222052: error incrementing delay detection";
    }
    @Override
    public final void lareMessageErrorCopying(final Exception e, final org.apache.activemq.artemis.core.server.LargeServerMessage largeServerMessage) {
        super.log.logv(FQCN, WARN, e, lareMessageErrorCopying$str(), largeServerMessage);
    }
    protected String lareMessageErrorCopying$str() {
        return "AMQ222053: Error on copying large message {0} for DLA or Expiry";
    }
    @Override
    public final void errorExecutingAIOCallback(final Throwable t) {
        super.log.logv(FQCN, WARN, t, errorExecutingAIOCallback$str());
    }
    protected String errorExecutingAIOCallback$str() {
        return "AMQ222054: Error on executing IOCallback";
    }
    @Override
    public final void errorDeletingDuplicateCache(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorDeletingDuplicateCache$str());
    }
    protected String errorDeletingDuplicateCache$str() {
        return "AMQ222055: Error on deleting duplicate cache";
    }
    @Override
    public final void noDLA(final SimpleString address) {
        super.log.logv(FQCN, WARN, null, noDLA$str(), address);
    }
    protected String noDLA$str() {
        return "AMQ222056: Did not route to any bindings for address {0} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.";
    }
    @Override
    public final void ioErrorAddingReferences(final Integer errorCode, final String errorMessage) {
        super.log.logv(FQCN, WARN, null, ioErrorAddingReferences$str(), errorCode, errorMessage);
    }
    protected String ioErrorAddingReferences$str() {
        return "AMQ222057: It was not possible to add references due to an IO error code {0} message = {1}";
    }
    @Override
    public final void duplicateMessageDetected(final Message message) {
        super.log.logv(FQCN, WARN, null, duplicateMessageDetected$str(), message);
    }
    protected String duplicateMessageDetected$str() {
        return "AMQ222059: Duplicate message detected - message will not be routed. Message information:\n{0}";
    }
    @Override
    public final void journalErrorConfirmingLargeMessage(final Throwable e, final Long messageID) {
        super.log.logv(FQCN, WARN, e, journalErrorConfirmingLargeMessage$str(), messageID);
    }
    protected String journalErrorConfirmingLargeMessage$str() {
        return "AMQ222060: Error while confirming large message completion on rollback for recordID={0}";
    }
    @Override
    public final void clientConnectionFailed(final String name) {
        super.log.logv(FQCN, WARN, null, clientConnectionFailed$str(), name);
    }
    protected String clientConnectionFailed$str() {
        return "AMQ222061: Client connection failed, clearing up resources for session {0}";
    }
    @Override
    public final void clearingUpSession(final String name) {
        super.log.logv(FQCN, WARN, null, clearingUpSession$str(), name);
    }
    protected String clearingUpSession$str() {
        return "AMQ222062: Cleared up resources for session {0}";
    }
    @Override
    public final void errorProcessingIOCallback(final Integer errorCode, final String errorMessage) {
        super.log.logv(FQCN, WARN, null, errorProcessingIOCallback$str(), errorCode, errorMessage);
    }
    protected String errorProcessingIOCallback$str() {
        return "AMQ222063: Error processing IOCallback code = {0} message = {1}";
    }
    @Override
    public final void incompatibleVersionAfterConnect(final int version, final int clientVersion) {
        super.log.logv(FQCN, DEBUG, null, incompatibleVersionAfterConnect$str(), version, clientVersion);
    }
    protected String incompatibleVersionAfterConnect$str() {
        return "AMQ222065: Client is not being consistent on the request versioning. It just sent a version id={0} while it informed {1} previously";
    }
    @Override
    public final void reattachRequestFailed(final String remoteAddress) {
        super.log.logv(FQCN, WARN, null, reattachRequestFailed$str(), remoteAddress);
    }
    protected String reattachRequestFailed$str() {
        return "AMQ222066: Reattach request from {0} failed as there is no confirmationWindowSize configured, which may be ok for your system";
    }
    @Override
    public final void connectionFailureDetected(final String message, final ActiveMQExceptionType type) {
        super.log.logv(FQCN, WARN, null, connectionFailureDetected$str(), message, type);
    }
    protected String connectionFailureDetected$str() {
        return "AMQ222067: Connection failure has been detected: {0} [code={1}]";
    }
    @Override
    public final void errorCleaningStompConn(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorCleaningStompConn$str());
    }
    protected String errorCleaningStompConn$str() {
        return "AMQ222069: error cleaning up stomp connection";
    }
    @Override
    public final void stompTXAckNorSupported() {
        super.log.logv(FQCN, WARN, null, stompTXAckNorSupported$str());
    }
    protected String stompTXAckNorSupported$str() {
        return "AMQ222070: Stomp Transactional acknowledgement is not supported";
    }
    @Override
    public final void errorOnStompHeartBeat(final InterruptedException e) {
        super.log.logv(FQCN, WARN, e, errorOnStompHeartBeat$str());
    }
    protected String errorOnStompHeartBeat$str() {
        return "AMQ222071: Interrupted while waiting for stomp heartbeat to die";
    }
    @Override
    public final void timedOutFlushingInvmChannel() {
        super.log.logv(FQCN, WARN, null, timedOutFlushingInvmChannel$str());
    }
    protected String timedOutFlushingInvmChannel$str() {
        return "AMQ222072: Timed out flushing channel on InVMConnection";
    }
    @Override
    public final void nettyChannelGroupError() {
        super.log.logv(FQCN, WARN, null, nettyChannelGroupError$str());
    }
    protected String nettyChannelGroupError$str() {
        return "AMQ212074: channel group did not completely close";
    }
    @Override
    public final void nettyChannelStillOpen(final Channel channel, final SocketAddress remoteAddress) {
        super.log.logv(FQCN, WARN, null, nettyChannelStillOpen$str(), channel, remoteAddress);
    }
    protected String nettyChannelStillOpen$str() {
        return "AMQ222075: {0} is still connected to {1}";
    }
    @Override
    public final void nettyChannelGroupBindError() {
        super.log.logv(FQCN, WARN, null, nettyChannelGroupBindError$str());
    }
    protected String nettyChannelGroupBindError$str() {
        return "AMQ222076: channel group did not completely unbind";
    }
    @Override
    public final void nettyChannelStillBound(final Channel channel, final SocketAddress remoteAddress) {
        super.log.logv(FQCN, WARN, null, nettyChannelStillBound$str(), channel, remoteAddress);
    }
    protected String nettyChannelStillBound$str() {
        return "AMQ222077: {0} is still bound to {1}";
    }
    @Override
    public final void errorCreatingRemotingInterceptor(final Exception e, final String interceptorClass) {
        super.log.logv(FQCN, WARN, e, errorCreatingRemotingInterceptor$str(), interceptorClass);
    }
    protected String errorCreatingRemotingInterceptor$str() {
        return "AMQ222078: Error instantiating remoting interceptor {0}";
    }
    @Override
    public final void invalidAcceptorKeys(final String s) {
        super.log.logv(FQCN, WARN, null, invalidAcceptorKeys$str(), s);
    }
    protected String invalidAcceptorKeys$str() {
        return "AMQ222079: The following keys are invalid for configuring the acceptor: {0} the acceptor will not be started.";
    }
    @Override
    public final void errorCreatingAcceptor(final Exception e, final String factoryClassName) {
        super.log.logv(FQCN, WARN, e, errorCreatingAcceptor$str(), factoryClassName);
    }
    protected String errorCreatingAcceptor$str() {
        return "AMQ222080: Error instantiating remoting acceptor {0}";
    }
    @Override
    public final void timeoutRemotingThreadPool() {
        super.log.logv(FQCN, WARN, null, timeoutRemotingThreadPool$str());
    }
    protected String timeoutRemotingThreadPool$str() {
        return "AMQ222081: Timed out waiting for remoting thread pool to terminate";
    }
    @Override
    public final void errorOnFailureCheck(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorOnFailureCheck$str());
    }
    protected String errorOnFailureCheck$str() {
        return "AMQ222082: error on connection failure check";
    }
    @Override
    public final void connectorKeysInvalid(final String s) {
        super.log.logv(FQCN, WARN, null, connectorKeysInvalid$str(), s);
    }
    protected String connectorKeysInvalid$str() {
        return "AMQ222083: The following keys are invalid for configuring the connector service: {0} the connector will not be started.";
    }
    @Override
    public final void connectorKeysMissing(final String s) {
        super.log.logv(FQCN, WARN, null, connectorKeysMissing$str(), s);
    }
    protected String connectorKeysMissing$str() {
        return "AMQ222084: The following keys are required for configuring the connector service: {0} the connector will not be started.";
    }
    @Override
    public final void invalidPacketForReplication(final Packet packet) {
        super.log.logv(FQCN, WARN, null, invalidPacketForReplication$str(), packet);
    }
    protected String invalidPacketForReplication$str() {
        return "AMQ222085: Packet {0} can not be processed by the ReplicationEndpoint";
    }
    @Override
    public final void errorHandlingReplicationPacket(final Exception e, final Packet packet) {
        super.log.logv(FQCN, WARN, e, errorHandlingReplicationPacket$str(), packet);
    }
    protected String errorHandlingReplicationPacket$str() {
        return "AMQ222086: error handling packet {0} for replication";
    }
    @Override
    public final void errorClosingPageOnReplication(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorClosingPageOnReplication$str());
    }
    protected String errorClosingPageOnReplication$str() {
        return "AMQ222087: Replication Error while closing the page on backup";
    }
    @Override
    public final void journalcomparisonMismatch(final String s) {
        super.log.logv(FQCN, WARN, null, journalcomparisonMismatch$str(), s);
    }
    protected String journalcomparisonMismatch$str() {
        return "AMQ222088: Journal comparison mismatch:\n{0}";
    }
    @Override
    public final void errorDeletingLargeMessage(final Exception e, final long messageId) {
        super.log.logv(FQCN, WARN, e, errorDeletingLargeMessage$str(), messageId);
    }
    protected String errorDeletingLargeMessage$str() {
        return "AMQ222089: Replication Error deleting large message ID = {0}";
    }
    @Override
    public final void largeMessageNotAvailable(final long messageId) {
        super.log.logv(FQCN, WARN, null, largeMessageNotAvailable$str(), messageId);
    }
    protected String largeMessageNotAvailable$str() {
        return "AMQ222090: Replication Large MessageID {0}  is not available on backup server. Ignoring replication message";
    }
    @Override
    public final void replicationStopOnBackupShutdown() {
        super.log.logv(FQCN, WARN, null, replicationStopOnBackupShutdown$str());
    }
    protected String replicationStopOnBackupShutdown$str() {
        return "AMQ222091: The backup node has been shut-down, replication will now stop";
    }
    @Override
    public final void replicationStopOnBackupFail(final Exception e) {
        super.log.logv(FQCN, WARN, e, replicationStopOnBackupFail$str());
    }
    protected String replicationStopOnBackupFail$str() {
        return "AMQ222092: Connection to the backup node failed, removing replication now";
    }
    @Override
    public final void timedOutWaitingToStopBridge() {
        super.log.logv(FQCN, WARN, null, timedOutWaitingToStopBridge$str());
    }
    protected String timedOutWaitingToStopBridge$str() {
        return "AMQ222093: Timed out waiting to stop Bridge";
    }
    @Override
    public final void bridgeUnableToSendMessage(final Exception e, final org.apache.activemq.artemis.core.server.MessageReference ref) {
        super.log.logv(FQCN, WARN, e, bridgeUnableToSendMessage$str(), ref);
    }
    protected String bridgeUnableToSendMessage$str() {
        return "AMQ222094: Bridge unable to send message {0}, will try again once bridge reconnects";
    }
    @Override
    public final void bridgeConnectionFailed(final Boolean failedOver) {
        super.log.logv(FQCN, WARN, null, bridgeConnectionFailed$str(), failedOver);
    }
    protected String bridgeConnectionFailed$str() {
        return "AMQ222095: Connection failed with failedOver={0}";
    }
    @Override
    public final void errorQueryingBridge(final Throwable t, final SimpleString name) {
        super.log.logv(FQCN, WARN, t, errorQueryingBridge1$str(), name);
    }
    protected String errorQueryingBridge1$str() {
        return "AMQ222096: Error on querying binding on bridge {0}. Retrying in 100 milliseconds";
    }
    @Override
    public final void errorQueryingBridge(final SimpleString address, final Integer retryCount) {
        super.log.logv(FQCN, WARN, null, errorQueryingBridge2$str(), address, retryCount);
    }
    protected String errorQueryingBridge2$str() {
        return "AMQ222097: Address {0} does not have any bindings, retry #({1})";
    }
    @Override
    public final void errorStartingBridge(final SimpleString name) {
        super.log.logv(FQCN, WARN, null, errorStartingBridge$str(), name);
    }
    protected String errorStartingBridge$str() {
        return "AMQ222098: Server is starting, retry to create the session for bridge {0}";
    }
    @Override
    public final void errorConnectingBridge(final Exception e, final Bridge bridge) {
        super.log.logv(FQCN, WARN, e, errorConnectingBridge$str(), bridge);
    }
    protected String errorConnectingBridge$str() {
        return "AMQ222099: Bridge {0} is unable to connect to destination. It will be disabled.";
    }
    @Override
    public final void bridgeLocatorShutdown() {
        super.log.logv(FQCN, WARN, null, bridgeLocatorShutdown$str());
    }
    protected String bridgeLocatorShutdown$str() {
        return "AMQ222100: ServerLocator was shutdown, can not retry on opening connection for bridge";
    }
    @Override
    public final void bridgeAbortStart(final SimpleString name, final Integer retryCount, final Integer reconnectAttempts) {
        super.log.logv(FQCN, WARN, null, bridgeAbortStart$str(), name, retryCount, reconnectAttempts);
    }
    protected String bridgeAbortStart$str() {
        return "AMQ222101: Bridge {0} achieved {1} maxattempts={2} it will stop retrying to reconnect";
    }
    @Override
    public final void errorReConnecting(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorReConnecting$str());
    }
    protected String errorReConnecting$str() {
        return "AMQ222102: Unexpected exception while trying to reconnect";
    }
    @Override
    public final void timedOutXID(final Xid xid) {
        super.log.logv(FQCN, WARN, null, timedOutXID$str(), xid);
    }
    protected String timedOutXID$str() {
        return "AMQ222103: transaction with xid {0} timed out";
    }
    @Override
    public final void ioErrorOnTX(final Integer errorCode, final String errorMessage) {
        super.log.logv(FQCN, WARN, null, ioErrorOnTX$str(), errorCode, errorMessage);
    }
    protected String ioErrorOnTX$str() {
        return "AMQ222104: IO Error completing the transaction, code = {0}, message = {1}";
    }
    @Override
    public final void replacingIncompleteLargeMessage(final Long messageID) {
        super.log.logv(FQCN, WARN, null, replacingIncompleteLargeMessage$str(), messageID);
    }
    protected String replacingIncompleteLargeMessage$str() {
        return "AMQ222106: Replacing incomplete LargeMessage with ID={0}";
    }
    @Override
    public final void clientConnectionFailedClearingSession(final String name) {
        super.log.logv(FQCN, WARN, null, clientConnectionFailedClearingSession$str(), name);
    }
    protected String clientConnectionFailedClearingSession$str() {
        return "AMQ222107: Cleared up resources for session {0}";
    }
    @Override
    public final void broadcastGroupClosed(final Exception e) {
        super.log.logv(FQCN, WARN, e, broadcastGroupClosed$str());
    }
    protected String broadcastGroupClosed$str() {
        return "AMQ222108: unable to send notification when broadcast group is stopped";
    }
    @Override
    public final void timeoutLockingConsumer(final String consumer, final String remoteAddress) {
        super.log.logv(FQCN, WARN, null, timeoutLockingConsumer$str(), consumer, remoteAddress);
    }
    protected String timeoutLockingConsumer$str() {
        return "AMQ222109: Timed out waiting for write lock on consumer {0} from {1}. Check the Thread dump";
    }
    @Override
    public final void noQueueIdDefined(final Message message, final Message messageCopy, final SimpleString idsHeaderName) {
        super.log.logv(FQCN, WARN, null, noQueueIdDefined$str(), message, messageCopy, idsHeaderName);
    }
    protected String noQueueIdDefined$str() {
        return "AMQ222110: no queue IDs defined!,  originalMessage  = {0}, copiedMessage = {1}, props={2}";
    }
    @Override
    public final void managementOperationError(final Exception e, final String op, final String resourceName) {
        super.log.logv(FQCN, TRACE, e, managementOperationError$str(), op, resourceName);
    }
    protected String managementOperationError$str() {
        return "AMQ222111: exception while invoking {0} on {1}";
    }
    @Override
    public final void managementAttributeError(final Exception e, final String att, final String resourceName) {
        super.log.logv(FQCN, WARN, e, managementAttributeError$str(), att, resourceName);
    }
    protected String managementAttributeError$str() {
        return "AMQ222112: exception while retrieving attribute {0} on {1}";
    }
    @Override
    public final void managementStopError(final Integer size, final List<String> unexpectedResourceNames) {
        super.log.logv(FQCN, WARN, null, managementStopError$str(), size, unexpectedResourceNames);
    }
    protected String managementStopError$str() {
        return "AMQ222113: On ManagementService stop, there are {0} unexpected registered MBeans: {1}";
    }
    @Override
    public final void unableToDeleteGroupBindings(final Exception e, final SimpleString groupId) {
        super.log.logv(FQCN, WARN, e, unableToDeleteGroupBindings$str(), groupId);
    }
    protected String unableToDeleteGroupBindings$str() {
        return "AMQ222114: Unable to delete group binding info {0}";
    }
    @Override
    public final void errorClosingServerLocator(final Exception e, final ServerLocatorInternal clusterLocator) {
        super.log.logv(FQCN, WARN, e, errorClosingServerLocator$str(), clusterLocator);
    }
    protected String errorClosingServerLocator$str() {
        return "AMQ222115: Error closing serverLocator={0}";
    }
    @Override
    public final void unableToStartBroadcastGroup(final Exception e, final String name) {
        super.log.logv(FQCN, WARN, e, unableToStartBroadcastGroup$str(), name);
    }
    protected String unableToStartBroadcastGroup$str() {
        return "AMQ222116: unable to start broadcast group {0}";
    }
    @Override
    public final void unableToStartClusterConnection(final Exception e, final SimpleString name) {
        super.log.logv(FQCN, WARN, e, unableToStartClusterConnection$str(), name);
    }
    protected String unableToStartClusterConnection$str() {
        return "AMQ222117: unable to start cluster connection {0}";
    }
    @Override
    public final void unableToStartBridge(final Exception e, final SimpleString name) {
        super.log.logv(FQCN, WARN, e, unableToStartBridge$str(), name);
    }
    protected String unableToStartBridge$str() {
        return "AMQ222118: unable to start Bridge {0}";
    }
    @Override
    public final void announceBackupNoConnector(final String connectorName) {
        super.log.logv(FQCN, WARN, null, announceBackupNoConnector$str(), connectorName);
    }
    protected String announceBackupNoConnector$str() {
        return "AMQ222119: No connector with name {0}. backup cannot be announced.";
    }
    @Override
    public final void announceBackupNoClusterConnections() {
        super.log.logv(FQCN, WARN, null, announceBackupNoClusterConnections$str());
    }
    protected String announceBackupNoClusterConnections$str() {
        return "AMQ222120: no cluster connections defined, unable to announce backup";
    }
    @Override
    public final void bridgeNotUnique() {
        super.log.logv(FQCN, WARN, null, bridgeNotUnique$str());
    }
    protected String bridgeNotUnique$str() {
        return "AMQ222121: Must specify a unique name for each bridge. This one will not be deployed.";
    }
    @Override
    public final void bridgeNoQueue(final String name) {
        super.log.logv(FQCN, WARN, null, bridgeNoQueue$str(), name);
    }
    protected String bridgeNoQueue$str() {
        return "AMQ222122: Must specify a queue name for each bridge. This one {0} will not be deployed.";
    }
    @Override
    public final void bridgeNoForwardAddress(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeNoForwardAddress$str(), bridgeName);
    }
    protected String bridgeNoForwardAddress$str() {
        return "AMQ222123: Forward address is not specified on bridge {0}. Will use original message address instead";
    }
    @Override
    public final void bridgeAlreadyDeployed(final String name) {
        super.log.logv(FQCN, WARN, null, bridgeAlreadyDeployed$str(), name);
    }
    protected String bridgeAlreadyDeployed$str() {
        return "AMQ222124: There is already a bridge with name {0} deployed. This one will not be deployed.";
    }
    @Override
    public final void bridgeQueueNotFound(final String queueName, final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeQueueNotFound$str(), queueName, bridgeName);
    }
    protected String bridgeQueueNotFound$str() {
        return "AMQ222125: No queue found with name {0} bridge {1} will not be deployed.";
    }
    @Override
    public final void bridgeNoDiscoveryGroup(final String name) {
        super.log.logv(FQCN, WARN, null, bridgeNoDiscoveryGroup$str(), name);
    }
    protected String bridgeNoDiscoveryGroup$str() {
        return "AMQ222126: No discovery group found with name {0} bridge will not be deployed.";
    }
    @Override
    public final void clusterConnectionNotUnique() {
        super.log.logv(FQCN, WARN, null, clusterConnectionNotUnique$str());
    }
    protected String clusterConnectionNotUnique$str() {
        return "AMQ222127: Must specify a unique name for each cluster connection. This one will not be deployed.";
    }
    @Override
    public final void clusterConnectionNoForwardAddress() {
        super.log.logv(FQCN, WARN, null, clusterConnectionNoForwardAddress$str());
    }
    protected String clusterConnectionNoForwardAddress$str() {
        return "AMQ222128: Must specify an address for each cluster connection. This one will not be deployed.";
    }
    @Override
    public final void clusterConnectionNoConnector(final String connectorName) {
        super.log.logv(FQCN, WARN, null, clusterConnectionNoConnector$str(), connectorName);
    }
    protected String clusterConnectionNoConnector$str() {
        return "AMQ222129: No connector with name {0}. The cluster connection will not be deployed.";
    }
    @Override
    public final void clusterConnectionAlreadyExists(final String connectorName) {
        super.log.logv(FQCN, WARN, null, clusterConnectionAlreadyExists$str(), connectorName);
    }
    protected String clusterConnectionAlreadyExists$str() {
        return "AMQ222130: Cluster Configuration  {0} already exists. The cluster connection will not be deployed.";
    }
    @Override
    public final void clusterConnectionNoDiscoveryGroup(final String discoveryGroupName) {
        super.log.logv(FQCN, WARN, null, clusterConnectionNoDiscoveryGroup$str(), discoveryGroupName);
    }
    protected String clusterConnectionNoDiscoveryGroup$str() {
        return "AMQ222131: No discovery group with name {0}. The cluster connection will not be deployed.";
    }
    @Override
    public final void broadcastGroupAlreadyExists(final String name) {
        super.log.logv(FQCN, WARN, null, broadcastGroupAlreadyExists$str(), name);
    }
    protected String broadcastGroupAlreadyExists$str() {
        return "AMQ222132: There is already a broadcast-group with name {0} deployed. This one will not be deployed.";
    }
    @Override
    public final void broadcastGroupNoConnector(final String connectorName, final String bgName) {
        super.log.logv(FQCN, WARN, null, broadcastGroupNoConnector$str(), connectorName, bgName);
    }
    protected String broadcastGroupNoConnector$str() {
        return "AMQ222133: There is no connector deployed with name {0}. The broadcast group with name {1} will not be deployed.";
    }
    @Override
    public final void noConnector(final String name) {
        super.log.logv(FQCN, WARN, null, noConnector$str(), name);
    }
    protected String noConnector$str() {
        return "AMQ222134: No connector defined with name {0}. The bridge will not be deployed.";
    }
    @Override
    public final void errorStoppingRedistributor() {
        super.log.logv(FQCN, WARN, null, errorStoppingRedistributor$str());
    }
    protected String errorStoppingRedistributor$str() {
        return "AMQ222135: Stopping Redistributor, Timed out waiting for tasks to complete";
    }
    @Override
    public final void ioErrorRedistributing(final Integer errorCode, final String errorMessage) {
        super.log.logv(FQCN, WARN, null, ioErrorRedistributing$str(), errorCode, errorMessage);
    }
    protected String ioErrorRedistributing$str() {
        return "AMQ222136: IO Error during redistribution, errorCode = {0} message = {1}";
    }
    @Override
    public final void errorAnnouncingBackup(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorAnnouncingBackup0$str());
    }
    protected String errorAnnouncingBackup0$str() {
        return "AMQ222137: Unable to announce backup, retrying";
    }
    @Override
    public final void noLocalMemborOnClusterConnection(final ClusterConnectionImpl clusterConnection) {
        super.log.logv(FQCN, WARN, null, noLocalMemborOnClusterConnection$str(), clusterConnection);
    }
    protected String noLocalMemborOnClusterConnection$str() {
        return "AMQ222138: Local Member is not set at on ClusterConnection {0}";
    }
    @Override
    public final void remoteQueueAlreadyBoundOnClusterConnection(final Object messageFlowRecord, final SimpleString clusterName) {
        super.log.logv(FQCN, WARN, null, remoteQueueAlreadyBoundOnClusterConnection$str(), messageFlowRecord, clusterName);
    }
    protected String remoteQueueAlreadyBoundOnClusterConnection$str() {
        return "AMQ222139: {0}::Remote queue binding {1} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses";
    }
    @Override
    public final void nodeManagerCantOpenFile(final Exception e, final File file) {
        super.log.logv(FQCN, WARN, e, nodeManagerCantOpenFile$str(), file);
    }
    protected String nodeManagerCantOpenFile$str() {
        return "AMQ222141: Node Manager can not open file {0}";
    }
    @Override
    public final void errorResttingLargeMessage(final Throwable e, final Object deliverer) {
        super.log.logv(FQCN, WARN, e, errorResttingLargeMessage$str(), deliverer);
    }
    protected String errorResttingLargeMessage$str() {
        return "AMQ222142: Error on resetting large message deliver - {0}";
    }
    @Override
    public final void errorTransferringConsumer() {
        super.log.logv(FQCN, WARN, null, errorTransferringConsumer$str());
    }
    protected String errorTransferringConsumer$str() {
        return "AMQ222143: Timed out waiting for executor to complete";
    }
    @Override
    public final void errorFlushingExecutorsOnQueue() {
        super.log.logv(FQCN, WARN, null, errorFlushingExecutorsOnQueue$str());
    }
    protected String errorFlushingExecutorsOnQueue$str() {
        return "AMQ222144: Queue could not finish waiting executors. Try increasing the thread pool size";
    }
    @Override
    public final void errorExpiringReferencesOnQueue(final Exception e, final org.apache.activemq.artemis.core.server.MessageReference ref) {
        super.log.logv(FQCN, WARN, e, errorExpiringReferencesOnQueue$str(), ref);
    }
    protected String errorExpiringReferencesOnQueue$str() {
        return "AMQ222145: Error expiring reference {0} on queue";
    }
    @Override
    public final void errorExpiringReferencesNoBindings(final SimpleString expiryAddress) {
        super.log.logv(FQCN, WARN, null, errorExpiringReferencesNoBindings$str(), expiryAddress);
    }
    protected String errorExpiringReferencesNoBindings$str() {
        return "AMQ222146: Message has expired. No bindings for Expiry Address {0} so dropping it";
    }
    @Override
    public final void errorExpiringReferencesNoAddress(final SimpleString name) {
        super.log.logv(FQCN, WARN, null, errorExpiringReferencesNoAddress$str(), name);
    }
    protected String errorExpiringReferencesNoAddress$str() {
        return "AMQ222147: Messages are being expired on queue {0}, but there is no Expiry Address configured so messages will be dropped.";
    }
    @Override
    public final void messageExceededMaxDelivery(final org.apache.activemq.artemis.core.server.MessageReference ref, final SimpleString name) {
        super.log.logv(FQCN, WARN, null, messageExceededMaxDelivery$str(), ref, name);
    }
    protected String messageExceededMaxDelivery$str() {
        return "AMQ222148: Message {0} has exceeded max delivery attempts. No bindings for Dead Letter Address {1} so dropping it";
    }
    @Override
    public final void messageExceededMaxDeliverySendtoDLA(final org.apache.activemq.artemis.core.server.MessageReference ref, final SimpleString name, final SimpleString simpleString) {
        super.log.logv(FQCN, WARN, null, messageExceededMaxDeliverySendtoDLA$str(), ref, name, simpleString);
    }
    protected String messageExceededMaxDeliverySendtoDLA$str() {
        return "AMQ222149: Message {0} has reached maximum delivery attempts, sending it to Dead Letter Address {1} from {2}";
    }
    @Override
    public final void messageExceededMaxDeliveryNoDLA(final org.apache.activemq.artemis.core.server.MessageReference ref, final SimpleString name) {
        super.log.logv(FQCN, WARN, null, messageExceededMaxDeliveryNoDLA$str(), ref, name);
    }
    protected String messageExceededMaxDeliveryNoDLA$str() {
        return "AMQ222150: Message {0} has exceeded max delivery attempts. No Dead Letter Address configured for queue {1} so dropping it";
    }
    @Override
    public final void removingBadConsumer(final Throwable e, final org.apache.activemq.artemis.core.server.Consumer consumer, final Object reference) {
        super.log.logv(FQCN, WARN, e, removingBadConsumer$str(), consumer, reference);
    }
    protected String removingBadConsumer$str() {
        return "AMQ222151: removing consumer which did not handle a message, consumer={0}, message={1}";
    }
    @Override
    public final void errorDecrementingRefCount(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorDecrementingRefCount$str());
    }
    protected String errorDecrementingRefCount$str() {
        return "AMQ222152: Unable to decrement reference counting on queue";
    }
    @Override
    public final void cannotFindMessageOnJournal(final Throwable e, final Long messageID) {
        super.log.logv(FQCN, WARN, e, cannotFindMessageOnJournal$str(), messageID);
    }
    protected String cannotFindMessageOnJournal$str() {
        return "AMQ222153: Cannot locate record for message id = {0} on Journal";
    }
    @Override
    public final void errorCheckingDLQ(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCheckingDLQ$str());
    }
    protected String errorCheckingDLQ$str() {
        return "AMQ222154: Error checking DLQ";
    }
    @Override
    public final void errorRegisteringBackup() {
        super.log.logv(FQCN, WARN, null, errorRegisteringBackup$str());
    }
    protected String errorRegisteringBackup$str() {
        return "AMQ222155: Failed to register as backup. Stopping the server.";
    }
    @Override
    public final void memoryError(final Integer memoryWarningThreshold, final String info) {
        super.log.logv(FQCN, WARN, null, memoryError$str(), memoryWarningThreshold, info);
    }
    protected String memoryError$str() {
        return "AMQ222156: Less than {0}%\n{1}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)";
    }
    @Override
    public final void errorCompletingCallbackOnReplicationManager(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCompletingCallbackOnReplicationManager$str());
    }
    protected String errorCompletingCallbackOnReplicationManager$str() {
        return "AMQ222157: Error completing callback on replication manager";
    }
    @Override
    public final void activationDidntFinish(final org.apache.activemq.artemis.core.server.ActiveMQServer server) {
        super.log.logv(FQCN, WARN, null, activationDidntFinish$str(), server);
    }
    protected String activationDidntFinish$str() {
        return "AMQ222158: {0} activation thread did not finish.";
    }
    @Override
    public final void broadcastBridgeStoppedError(final Exception e) {
        super.log.logv(FQCN, WARN, e, broadcastBridgeStoppedError$str());
    }
    protected String broadcastBridgeStoppedError$str() {
        return "AMQ222159: unable to send notification when broadcast group is stopped";
    }
    @Override
    public final void notificationBridgeStoppedError(final Exception e) {
        super.log.logv(FQCN, WARN, e, notificationBridgeStoppedError$str());
    }
    protected String notificationBridgeStoppedError$str() {
        return "AMQ222160: unable to send notification when broadcast group is stopped";
    }
    @Override
    public final void groupHandlerSendTimeout() {
        super.log.logv(FQCN, WARN, null, groupHandlerSendTimeout$str());
    }
    protected String groupHandlerSendTimeout$str() {
        return "AMQ222161: Group Handler timed-out waiting for sendCondition";
    }
    @Override
    public final void backupMovingDataAway(final String oldPath, final String newPath) {
        super.log.logv(FQCN, INFO, null, backupMovingDataAway$str(), oldPath, newPath);
    }
    protected String backupMovingDataAway$str() {
        return "AMQ222162: Moving data directory {0} to {1}";
    }
    @Override
    public final void stopReplicatedBackupAfterFailback() {
        super.log.logv(FQCN, WARN, null, stopReplicatedBackupAfterFailback$str());
    }
    protected String stopReplicatedBackupAfterFailback$str() {
        return "AMQ222163: Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.";
    }
    @Override
    public final void errorStartingReplication(final BackupRegistrationProblem problem) {
        super.log.logv(FQCN, WARN, null, errorStartingReplication1$str(), problem);
    }
    protected String errorStartingReplication1$str() {
        return "AMQ222164: Error when trying to start replication {0}";
    }
    @Override
    public final void AddressSettingsNoDLA(final SimpleString name) {
        super.log.logv(FQCN, WARN, null, AddressSettingsNoDLA$str(), name);
    }
    protected String AddressSettingsNoDLA$str() {
        return "AMQ222165: No Dead Letter Address configured for queue {0} in AddressSettings";
    }
    @Override
    public final void AddressSettingsNoExpiryAddress(final SimpleString name) {
        super.log.logv(FQCN, WARN, null, AddressSettingsNoExpiryAddress$str(), name);
    }
    protected String AddressSettingsNoExpiryAddress$str() {
        return "AMQ222166: No Expiry Address configured for queue {0} in AddressSettings";
    }
    @Override
    public final void groupingQueueRemoved(final int size, final SimpleString clusterName) {
        super.log.logv(FQCN, WARN, null, groupingQueueRemoved$str(), size, clusterName);
    }
    protected String groupingQueueRemoved$str() {
        return "AMQ222167: Group Binding not available so deleting {0} groups from {1}, groups will be bound to another node";
    }
    @Override
    public final void warnDeprecatedProtocol() {
        super.log.logv(FQCN, WARN, null, warnDeprecatedProtocol$str());
    }
    protected String warnDeprecatedProtocol$str() {
        return "AMQ222168: The ''protocol'' property is deprecated. If you want this Acceptor to support multiple protocols, use the ''protocols'' property, e.g. with value ''CORE,AMQP,STOMP''";
    }
    @Override
    public final void warnDisconnectOldClient(final String queueName) {
        super.log.logv(FQCN, WARN, null, warnDisconnectOldClient$str(), queueName);
    }
    protected String warnDisconnectOldClient$str() {
        return "AMQ222169: You have old legacy clients connected to the queue {0} and we can''t disconnect them, these clients may just hang";
    }
    @Override
    public final void bridgeConfirmationWindowTooSmall(final String bridgeName, final String address, final int windowConfirmation, final long maxSizeBytes) {
        super.log.logv(FQCN, WARN, null, bridgeConfirmationWindowTooSmall$str(), bridgeName, address, windowConfirmation, maxSizeBytes);
    }
    protected String bridgeConfirmationWindowTooSmall$str() {
        return "AMQ222170: Bridge {0} forwarding address {1} has confirmation-window-size ({2}) greater than address'' max-size-bytes'' ({3})";
    }
    @Override
    public final void bridgeCantFindAddressConfig(final String bridgeName, final String forwardingAddress) {
        super.log.logv(FQCN, WARN, null, bridgeCantFindAddressConfig$str(), bridgeName, forwardingAddress);
    }
    protected String bridgeCantFindAddressConfig$str() {
        return "AMQ222171: Bridge {0} forwarding address {1} could not be resolved on address-settings configuration";
    }
    @Override
    public final void queueBusy(final String name, final long timeout) {
        super.log.logv(FQCN, WARN, null, queueBusy$str(), name, timeout);
    }
    protected String queueBusy$str() {
        return "AMQ222172: Queue {0} was busy for more than {1} milliseconds. There are possibly consumers hanging on a network operation";
    }
    @Override
    public final void queueDuplicatedRenaming(final String name, final String newName) {
        super.log.logv(FQCN, WARN, null, queueDuplicatedRenaming$str(), name, newName);
    }
    protected String queueDuplicatedRenaming$str() {
        return "AMQ222173: Queue {0} is duplicated during reload. This queue will be renamed as {1}";
    }
    @Override
    public final void timeoutFlushInTransit(final String queueName, final String addressName) {
        super.log.logv(FQCN, WARN, null, timeoutFlushInTransit$str(), queueName, addressName);
    }
    protected String timeoutFlushInTransit$str() {
        return "AMQ222174: Queue {0}, on address={1}, is taking too long to flush deliveries. Watch out for frozen clients.";
    }
    @Override
    public final void bridgeCantFindConnectors(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeCantFindConnectors$str(), bridgeName);
    }
    protected String bridgeCantFindConnectors$str() {
        return "AMQ222175: Bridge {0} could not find configured connectors";
    }
    @Override
    public final void xidReplacedOnXStart(final String xidOriginalToString, final String xidReplacedToString) {
        super.log.logv(FQCN, WARN, null, xidReplacedOnXStart$str(), xidOriginalToString, xidReplacedToString);
    }
    protected String xidReplacedOnXStart$str() {
        return "AMQ222176: A session that was already doing XA work on {0} is replacing the xid by {1} . This was most likely caused from a previous communication timeout";
    }
    @Override
    public final void rolePermissionConfigurationError(final String permission) {
        super.log.logv(FQCN, WARN, null, rolePermissionConfigurationError$str(), permission);
    }
    protected String rolePermissionConfigurationError$str() {
        return "AMQ222177: Wrong configuration for role, {0} is not a valid permission";
    }
    @Override
    public final void errorRecoveringPageCounter(final Throwable error) {
        super.log.logv(FQCN, WARN, error, errorRecoveringPageCounter$str());
    }
    protected String errorRecoveringPageCounter$str() {
        return "AMQ222178: Error during recovery of page counters";
    }
    @Override
    public final void failedToScaleDown(final Throwable e) {
        super.log.logv(FQCN, WARN, e, failedToScaleDown$str());
    }
    protected String failedToScaleDown$str() {
        return "AMQ222181: Unable to scaleDown messages";
    }
    @Override
    public final void missingClusterConfigForScaleDown(final String scaleDownCluster) {
        super.log.logv(FQCN, WARN, null, missingClusterConfigForScaleDown$str(), scaleDownCluster);
    }
    protected String missingClusterConfigForScaleDown$str() {
        return "AMQ222182: Missing cluster-configuration for scale-down-clustername {0}";
    }
    @Override
    public final void blockingMessageProduction(final SimpleString addressName, final long currentSize, final long maxSize, final long globalMaxSize) {
        super.log.logv(FQCN, WARN, null, blockingMessageProduction$str(), addressName, currentSize, maxSize, globalMaxSize);
    }
    protected String blockingMessageProduction$str() {
        return "AMQ222183: Blocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes on address: {2}, global-max-size is {3}";
    }
    @Override
    public final void groupBindingsOnRecovery() {
        super.log.logv(FQCN, WARN, null, groupBindingsOnRecovery$str());
    }
    protected String groupBindingsOnRecovery$str() {
        return "AMQ222184: Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this";
    }
    @Override
    public final void noClusterConnectionForReplicationCluster() {
        super.log.logv(FQCN, WARN, null, noClusterConnectionForReplicationCluster$str());
    }
    protected String noClusterConnectionForReplicationCluster$str() {
        return "AMQ222185: no cluster connection for specified replication cluster";
    }
    @Override
    public final void clusterControlAuthfailure(final String causeMessage) {
        super.log.logv(FQCN, WARN, null, clusterControlAuthfailure$str(), causeMessage);
    }
    protected String clusterControlAuthfailure$str() {
        return "AMQ222186: unable to authorise cluster control: {0}";
    }
    @Override
    public final void activateReplicatedBackupFailed(final Throwable e) {
        super.log.logv(FQCN, WARN, e, activateReplicatedBackupFailed$str());
    }
    protected String activateReplicatedBackupFailed$str() {
        return "AMQ222187: Failed to activate replicated backup";
    }
    @Override
    public final void unableToFindTargetQueue(final String targetNodeID) {
        super.log.logv(FQCN, WARN, null, unableToFindTargetQueue$str(), targetNodeID);
    }
    protected String unableToFindTargetQueue$str() {
        return "AMQ222188: Unable to find target queue for node {0}";
    }
    @Override
    public final void activateSharedStoreSlaveFailed(final Throwable e) {
        super.log.logv(FQCN, WARN, e, activateSharedStoreSlaveFailed$str());
    }
    protected String activateSharedStoreSlaveFailed$str() {
        return "AMQ222189: Failed to activate shared store slave";
    }
    @Override
    public final void cannotFindRoleForUser(final String user) {
        super.log.logv(FQCN, WARN, null, cannotFindRoleForUser$str(), user);
    }
    protected String cannotFindRoleForUser$str() {
        return "AMQ222191: Could not find any configured role for user {0}.";
    }
    @Override
    public final void couldNotDeleteTempFile(final String tempFileName) {
        super.log.logv(FQCN, WARN, null, couldNotDeleteTempFile$str(), tempFileName);
    }
    protected String couldNotDeleteTempFile$str() {
        return "AMQ222192: Could not delete: {0}";
    }
    @Override
    public final void memoryLimitReached(final String producerID, final String address, final long duration) {
        super.log.logv(FQCN, WARN, null, memoryLimitReached$str(), producerID, address, duration);
    }
    protected String memoryLimitReached$str() {
        return "AMQ222193: Memory Limit reached. Producer ({0}) stopped to prevent flooding {1} (blocking for {2}s). See http://activemq.apache.org/producer-flow-control.html for more info.";
    }
    @Override
    public final void nullPageCursorInfo(final String address, final String position, final long id) {
        super.log.logv(FQCN, WARN, null, nullPageCursorInfo$str(), address, position, id);
    }
    protected String nullPageCursorInfo$str() {
        return "AMQ222194: PageCursorInfo == null on address {0}, pos = {1}, queue = {2}.";
    }
    @Override
    public final void largeMessageNotFound(final long id) {
        super.log.logv(FQCN, WARN, null, largeMessageNotFound$str(), id);
    }
    protected String largeMessageNotFound$str() {
        return "AMQ222195: Large message {0} wasn''t found when dealing with add pending large message";
    }
    @Override
    public final void bindingNotFound(final long id, final String message, final String binding) {
        super.log.logv(FQCN, WARN, null, bindingNotFound$str(), id, message, binding);
    }
    protected String bindingNotFound$str() {
        return "AMQ222196: Could not find binding with id={0} on routeFromCluster for message={1} binding = {2}";
    }
    @Override
    public final void nonDeliveryHandled() {
        super.log.logv(FQCN, WARN, null, nonDeliveryHandled$str());
    }
    protected String nonDeliveryHandled$str() {
        return "AMQ222197: Internal error! Delivery logic has identified a non delivery and still handled a consumer!";
    }
    @Override
    public final void couldNotFlushClusterManager(final String manager) {
        super.log.logv(FQCN, WARN, null, couldNotFlushClusterManager$str(), manager);
    }
    protected String couldNotFlushClusterManager$str() {
        return "AMQ222198: Could not flush ClusterManager executor ({0}) in 10 seconds, verify your thread pool size";
    }
    @Override
    public final void threadDump(final String manager) {
        super.log.logv(FQCN, WARN, null, threadDump$str(), manager);
    }
    protected String threadDump$str() {
        return "AMQ222199: Thread dump: {0}";
    }
    @Override
    public final void couldNotFinishExecutor(final String clusterConnection) {
        super.log.logv(FQCN, WARN, null, couldNotFinishExecutor$str(), clusterConnection);
    }
    protected String couldNotFinishExecutor$str() {
        return "AMQ222200: Could not finish executor on {0}";
    }
    @Override
    public final void activationTimeout() {
        super.log.logv(FQCN, WARN, null, activationTimeout$str());
    }
    protected String activationTimeout$str() {
        return "AMQ222201: Timed out waiting for activation to exit";
    }
    @Override
    public final void connectionTTLEqualsCheckPeriod(final String connectionName, final String ttl, final String checkPeriod) {
        super.log.logv(FQCN, WARN, null, connectionTTLEqualsCheckPeriod$str(), connectionName, ttl, checkPeriod);
    }
    protected String connectionTTLEqualsCheckPeriod$str() {
        return "AMQ222202: {0}: <{1}> should not be set to the same value as <{2}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.";
    }
    @Override
    public final void noProtocolManagerFound(final String protocol, final String host) {
        super.log.logv(FQCN, WARN, null, noProtocolManagerFound$str(), protocol, host);
    }
    protected String noProtocolManagerFound$str() {
        return "AMQ222203: Classpath lacks a protocol-manager for protocol {0}, Protocol being ignored on acceptor {1}";
    }
    @Override
    public final void duplicatedAcceptor(final String name, final String parameters, final String classFactory) {
        super.log.logv(FQCN, WARN, null, duplicatedAcceptor$str(), name, parameters, classFactory);
    }
    protected String duplicatedAcceptor$str() {
        return "AMQ222204: Duplicated Acceptor {0} with parameters {1} classFactory={2} duplicated on the configuration";
    }
    @Override
    public final void potentialOOME(final long addressCount, final long totalMaxSizeBytes, final long maxMemory) {
        super.log.logv(FQCN, WARN, null, potentialOOME$str(), addressCount, totalMaxSizeBytes, maxMemory);
    }
    protected String potentialOOME$str() {
        return "AMQ222205: OutOfMemoryError possible! There are currently {0} addresses with a total max-size-bytes of {1} bytes, but the maximum memory available is {2} bytes.";
    }
    @Override
    public final void connectionLimitReached(final long connectionsAllowed, final String address) {
        super.log.logv(FQCN, WARN, null, connectionLimitReached$str(), connectionsAllowed, address);
    }
    protected String connectionLimitReached$str() {
        return "AMQ222206: Connection limit of {0} reached. Refusing connection from {1}.";
    }
    @Override
    public final void slowReplicationResponse() {
        super.log.logv(FQCN, WARN, null, slowReplicationResponse$str());
    }
    protected String slowReplicationResponse$str() {
        return "AMQ222207: The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.";
    }
    @Override
    public final void sslHandshakeFailed(final String clientAddress, final String cause) {
        super.log.logv(FQCN, WARN, null, sslHandshakeFailed$str(), clientAddress, cause);
    }
    protected String sslHandshakeFailed$str() {
        return "AMQ222208: SSL handshake failed for client from {0}: {1}.";
    }
    @Override
    public final void impossibleToRouteGrouped() {
        super.log.logv(FQCN, WARN, null, impossibleToRouteGrouped$str());
    }
    protected String impossibleToRouteGrouped$str() {
        return "AMQ222209: Could not contact group handler coordinator after 10 retries, message being routed without grouping information";
    }
    @Override
    public final void diskBeyondCapacity(final String usableSpace, final String totalSpace, final String usage) {
        super.log.logv(FQCN, WARN, null, diskBeyondCapacity$str(), usableSpace, totalSpace, usage);
    }
    protected String diskBeyondCapacity$str() {
        return "AMQ222210: Free storage space is at {0} of {1} total. Usage rate is {2} which is beyond the configured <max-disk-usage>. System will start blocking producers.";
    }
    @Override
    public final void diskCapacityRestored(final String usableSpace, final String totalSpace, final String usage) {
        super.log.logv(FQCN, INFO, null, diskCapacityRestored$str(), usableSpace, totalSpace, usage);
    }
    protected String diskCapacityRestored$str() {
        return "AMQ222211: Free storage space is at {0} of {1} total. Usage rate is {2} which is below the configured <max-disk-usage>.";
    }
    @Override
    public final void blockingDiskFull(final SimpleString addressName) {
        super.log.logv(FQCN, WARN, null, blockingDiskFull$str(), addressName);
    }
    protected String blockingDiskFull$str() {
        return "AMQ222212: Disk Full! Blocking message production on address ''{0}''. Clients will report blocked.";
    }
    @Override
    public final void serverIsolatedOnNetwork() {
        super.log.logv(FQCN, WARN, null, serverIsolatedOnNetwork$str());
    }
    protected String serverIsolatedOnNetwork$str() {
        return "AMQ222213: There was an issue on the network, server is isolated!";
    }
    @Override
    public final void negativeAddressSize(final long size, final String destination) {
        super.log.logv(FQCN, WARN, null, negativeAddressSize$str(), size, destination);
    }
    protected String negativeAddressSize$str() {
        return "AMQ222214: Destination {1} has an inconsistent and negative address size={0}.";
    }
    @Override
    public final void negativeGlobalAddressSize(final long size) {
        super.log.logv(FQCN, WARN, null, negativeGlobalAddressSize$str(), size);
    }
    protected String negativeGlobalAddressSize$str() {
        return "AMQ222215: Global Address Size has negative and inconsistent value as {0}";
    }
    @Override
    public final void securityProblemWhileAuthenticating(final String message) {
        super.log.logv(FQCN, WARN, null, securityProblemWhileAuthenticating$str(), message);
    }
    protected String securityProblemWhileAuthenticating$str() {
        return "AMQ222216: Security problem while authenticating: {0}";
    }
    @Override
    public final void connectorRefNotFound(final String connectorRef, final String clusterConnection) {
        super.log.logv(FQCN, WARN, null, connectorRefNotFound$str(), connectorRef, clusterConnection);
    }
    protected String connectorRefNotFound$str() {
        return "AMQ222217: Cannot find connector-ref {0}. The cluster-connection {1} will not be deployed.";
    }
    @Override
    public final void disconnectCritical(final String reason, final Exception e) {
        super.log.logv(FQCN, WARN, e, disconnectCritical$str(), reason);
    }
    protected String disconnectCritical$str() {
        return "AMQ222218: Server disconnecting: {0}";
    }
    @Override
    public final void fileDoesNotExist(final String path) {
        super.log.logv(FQCN, WARN, null, fileDoesNotExist$str(), path);
    }
    protected String fileDoesNotExist$str() {
        return "AMQ222219: File {0} does not exist";
    }
    @Override
    public final void errorCleaningPagingOnQueue(final Exception e, final String queue) {
        super.log.logv(FQCN, WARN, e, errorCleaningPagingOnQueue$str(), queue);
    }
    protected String errorCleaningPagingOnQueue$str() {
        return "AMQ222220:    Error while cleaning paging on queue {0}";
    }
    @Override
    public final void errorCleaningPagingDuringCommit(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorCleaningPagingDuringCommit$str());
    }
    protected String errorCleaningPagingDuringCommit$str() {
        return "AMQ222221: Error while cleaning page, during the commit";
    }
    @Override
    public final void errorDeletingPageCompleteRecord(final Exception e) {
        super.log.logv(FQCN, WARN, e, errorDeletingPageCompleteRecord$str());
    }
    protected String errorDeletingPageCompleteRecord$str() {
        return "AMQ222222: Error while deleting page-complete-record";
    }
    @Override
    public final void errorCalculateMessageMemoryEstimate(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCalculateMessageMemoryEstimate$str());
    }
    protected String errorCalculateMessageMemoryEstimate$str() {
        return "AMQ222223: Failed to calculate message memory estimate";
    }
    @Override
    public final void errorCalculateScheduledDeliveryTime(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCalculateScheduledDeliveryTime$str());
    }
    protected String errorCalculateScheduledDeliveryTime$str() {
        return "AMQ222224: Failed to calculate scheduled delivery time";
    }
    @Override
    public final void sendingUnexpectedExceptionToClient(final Throwable e) {
        super.log.logv(FQCN, WARN, e, sendingUnexpectedExceptionToClient$str());
    }
    protected String sendingUnexpectedExceptionToClient$str() {
        return "AMQ222225: Sending unexpected exception to the client";
    }
    @Override
    public final void connectionConfigurationIsNull(final String connectorName) {
        super.log.logv(FQCN, WARN, null, connectionConfigurationIsNull$str(), connectorName);
    }
    protected String connectionConfigurationIsNull$str() {
        return "AMQ222226: Connection configuration is null for connectorName {0}";
    }
    @Override
    public final void failedToProcessEvent(final NamingException e) {
        super.log.logv(FQCN, WARN, e, failedToProcessEvent$str());
    }
    protected String failedToProcessEvent$str() {
        return "AMQ222227: Failed to process an event";
    }
    @Override
    public final void missingReplicationTokenOnQueue() {
        super.log.logv(FQCN, WARN, null, missingReplicationTokenOnQueue$str());
    }
    protected String missingReplicationTokenOnQueue$str() {
        return "AMQ222228: Missing replication token on queue";
    }
    @Override
    public final void failedToPerformRollback(final IllegalStateException e) {
        super.log.logv(FQCN, WARN, e, failedToPerformRollback$str());
    }
    protected String failedToPerformRollback$str() {
        return "AMQ222229: Failed to perform rollback";
    }
    @Override
    public final void failedToSendNotification(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToSendNotification$str());
    }
    protected String failedToSendNotification$str() {
        return "AMQ222230: Failed to send notification";
    }
    @Override
    public final void failedToFlushOutstandingDataFromTheConnection(final Throwable e) {
        super.log.logv(FQCN, WARN, e, failedToFlushOutstandingDataFromTheConnection$str());
    }
    protected String failedToFlushOutstandingDataFromTheConnection$str() {
        return "AMQ222231: Failed to flush outstanding data from the connection";
    }
    @Override
    public final void unableToAcquireLock(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToAcquireLock$str());
    }
    protected String unableToAcquireLock$str() {
        return "AMQ222232: Unable to acquire lock";
    }
    @Override
    public final void unableDestroyConnectionWithSessionMetadata(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableDestroyConnectionWithSessionMetadata$str());
    }
    protected String unableDestroyConnectionWithSessionMetadata$str() {
        return "AMQ222233: Unable to destroy connection with session metadata";
    }
    @Override
    public final void unableToInvokeCallback(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToInvokeCallback$str());
    }
    protected String unableToInvokeCallback$str() {
        return "AMQ222234: Unable to invoke a callback";
    }
    @Override
    public final void unableToInjectMonitor(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToInjectMonitor$str());
    }
    protected String unableToInjectMonitor$str() {
        return "AMQ222235: Unable to inject a monitor";
    }
    @Override
    public final void unableToFlushDeliveries(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToFlushDeliveries$str());
    }
    protected String unableToFlushDeliveries$str() {
        return "AMQ222236: Unable to flush deliveries";
    }
    @Override
    public final void unableToCancelRedistributor(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCancelRedistributor$str());
    }
    protected String unableToCancelRedistributor$str() {
        return "AMQ222237: Unable to stop redistributor";
    }
    @Override
    public final void unableToCommitTransaction(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCommitTransaction$str());
    }
    protected String unableToCommitTransaction$str() {
        return "AMQ222238: Unable to commit transaction";
    }
    @Override
    public final void unableToDeleteQueueStatus(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToDeleteQueueStatus$str());
    }
    protected String unableToDeleteQueueStatus$str() {
        return "AMQ222239: Unable to delete Queue status";
    }
    @Override
    public final void unableToPauseQueue(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToPauseQueue$str());
    }
    protected String unableToPauseQueue$str() {
        return "AMQ222240: Unable to pause a Queue";
    }
    @Override
    public final void unableToResumeQueue(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToResumeQueue$str());
    }
    protected String unableToResumeQueue$str() {
        return "AMQ222241: Unable to resume a Queue";
    }
    @Override
    public final void unableToGetMessagePriority(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToGetMessagePriority$str());
    }
    protected String unableToGetMessagePriority$str() {
        return "AMQ222242: Unable to obtain message priority, using default ";
    }
    @Override
    public final void unableToExtractGroupID(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToExtractGroupID$str());
    }
    protected String unableToExtractGroupID$str() {
        return "AMQ222243: Unable to extract GroupID from message";
    }
    @Override
    public final void unableToCheckIfMessageExpired(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToCheckIfMessageExpired$str());
    }
    protected String unableToCheckIfMessageExpired$str() {
        return "AMQ222244: Unable to check if message expired";
    }
    @Override
    public final void unableToPerformPostAcknowledge(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToPerformPostAcknowledge$str());
    }
    protected String unableToPerformPostAcknowledge$str() {
        return "AMQ222245: Unable to perform post acknowledge";
    }
    @Override
    public final void unableToRollbackOnClose(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToRollbackOnClose$str());
    }
    protected String unableToRollbackOnClose$str() {
        return "AMQ222246: Unable to rollback on close";
    }
    @Override
    public final void unableToCloseConsumer(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToCloseConsumer$str());
    }
    protected String unableToCloseConsumer$str() {
        return "AMQ222247: Unable to close consumer";
    }
    @Override
    public final void unableToRemoveConsumer(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToRemoveConsumer$str());
    }
    protected String unableToRemoveConsumer$str() {
        return "AMQ222248: Unable to remove consumer";
    }
    @Override
    public final void unableToRollbackOnTxTimedOut(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToRollbackOnTxTimedOut$str());
    }
    protected String unableToRollbackOnTxTimedOut$str() {
        return "AMQ222249: Unable to rollback on TX timed out";
    }
    @Override
    public final void unableToDeleteHeuristicCompletion(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToDeleteHeuristicCompletion$str());
    }
    protected String unableToDeleteHeuristicCompletion$str() {
        return "AMQ222250: Unable to delete heuristic completion from storage manager";
    }
    @Override
    public final void unableToStartReplication(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToStartReplication$str());
    }
    protected String unableToStartReplication$str() {
        return "AMQ222251: Unable to start replication";
    }
    @Override
    public final void unableToCalculateFileSize(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCalculateFileSize$str());
    }
    protected String unableToCalculateFileSize$str() {
        return "AMQ222252: Unable to calculate file size";
    }
    @Override
    public final void errorWhileSyncingData(final String target, final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorWhileSyncingData$str(), target);
    }
    protected String errorWhileSyncingData$str() {
        return "AMQ222253: Error while syncing data on largeMessageInSync:: {0}";
    }
    @Override
    public final void invalidRecordType(final byte type, final Throwable e) {
        super.log.logv(FQCN, WARN, e, invalidRecordType$str(), type);
    }
    protected String invalidRecordType$str() {
        return "AMQ222254: Invalid record type {0}";
    }
    @Override
    public final void unableToCalculateFileStoreUsage(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCalculateFileStoreUsage$str());
    }
    protected String unableToCalculateFileStoreUsage$str() {
        return "AMQ222255: Unable to calculate file store usage";
    }
    @Override
    public final void failedToUnregisterAcceptors(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToUnregisterAcceptors$str());
    }
    protected String failedToUnregisterAcceptors$str() {
        return "AMQ222256: Failed to unregister acceptors";
    }
    @Override
    public final void failedToDecrementMessageReferenceCount(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToDecrementMessageReferenceCount$str());
    }
    protected String failedToDecrementMessageReferenceCount$str() {
        return "AMQ222257: Failed to decrement message reference count";
    }
    @Override
    public final void errorOnDeletingQueue(final String queueName, final Exception e) {
        super.log.logv(FQCN, WARN, e, errorOnDeletingQueue$str(), queueName);
    }
    protected String errorOnDeletingQueue$str() {
        return "AMQ222258: Error on deleting queue {0}";
    }
    @Override
    public final void failedToFlushExecutor(final InterruptedException e) {
        super.log.logv(FQCN, WARN, e, failedToFlushExecutor$str());
    }
    protected String failedToFlushExecutor$str() {
        return "AMQ222259: Failed to flush the executor";
    }
    @Override
    public final void failedToRollback(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToRollback$str());
    }
    protected String failedToRollback$str() {
        return "AMQ222260: Failed to perform rollback";
    }
    @Override
    public final void failedToActivateBackup(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToActivateBackup$str());
    }
    protected String failedToActivateBackup$str() {
        return "AMQ222261: Failed to activate a backup";
    }
    @Override
    public final void failedToStopClusterManager(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToStopClusterManager$str());
    }
    protected String failedToStopClusterManager$str() {
        return "AMQ222262: Failed to stop cluster manager";
    }
    @Override
    public final void failedToStopClusterConnection(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToStopClusterConnection$str());
    }
    protected String failedToStopClusterConnection$str() {
        return "AMQ222263: Failed to stop cluster connection";
    }
    @Override
    public final void failedToProcessMessageReferenceAfterRollback(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToProcessMessageReferenceAfterRollback$str());
    }
    protected String failedToProcessMessageReferenceAfterRollback$str() {
        return "AMQ222264: Failed to process message reference after rollback";
    }
    @Override
    public final void failedToFinishDelivery(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToFinishDelivery$str());
    }
    protected String failedToFinishDelivery$str() {
        return "AMQ222265: Failed to finish delivery, unable to lock delivery";
    }
    @Override
    public final void failedToSendRequestToNode(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToSendRequestToNode$str());
    }
    protected String failedToSendRequestToNode$str() {
        return "AMQ222266: Failed to send request to the node";
    }
    @Override
    public final void failedToDisconnectBindings(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToDisconnectBindings$str());
    }
    protected String failedToDisconnectBindings$str() {
        return "AMQ222267: Failed to disconnect bindings";
    }
    @Override
    public final void failedToRemoveRecord(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToRemoveRecord$str());
    }
    protected String failedToRemoveRecord$str() {
        return "AMQ222268: Failed to remove a record";
    }
    @Override
    public final void useFixedValueOnJournalPoolFiles() {
        super.log.logv(FQCN, WARN, null, useFixedValueOnJournalPoolFiles$str());
    }
    protected String useFixedValueOnJournalPoolFiles$str() {
        return "AMQ222269: Please use a fixed value for \"journal-pool-files\". Default changed per https://issues.apache.org/jira/browse/ARTEMIS-1628";
    }
    @Override
    public final void unableToCreateManagementNotificationAddress(final SimpleString addressName, final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToCreateManagementNotificationAddress$str(), addressName);
    }
    protected String unableToCreateManagementNotificationAddress$str() {
        return "AMQ222270: Unable to create management notification address: {0}";
    }
    @Override
    public final void journalMessageAckMissingQueueInPreparedTX(final Long queueID) {
        super.log.logv(FQCN, WARN, null, journalMessageAckMissingQueueInPreparedTX$str(), queueID);
    }
    protected String journalMessageAckMissingQueueInPreparedTX$str() {
        return "AMQ022272: Message ack in prepared tx for queue {0} which does not exist. This ack will be ignored.";
    }
    @Override
    public final void bridgeAddressFull(final String addressName, final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeAddressFull$str(), addressName, bridgeName);
    }
    protected String bridgeAddressFull$str() {
        return "AMQ022273: Address \"{0}\" is full. Bridge {1} will disconnect";
    }
    @Override
    public final void problemDeployingAddress(final String addressName, final String message) {
        super.log.logv(FQCN, WARN, null, problemDeployingAddress$str(), addressName, message);
    }
    protected String problemDeployingAddress$str() {
        return "AMQ222274: Failed to deploy address {0}: {1}";
    }
    @Override
    public final void problemDeployingQueue(final String queueName, final String message) {
        super.log.logv(FQCN, WARN, null, problemDeployingQueue$str(), queueName, message);
    }
    protected String problemDeployingQueue$str() {
        return "AMQ222275: Failed to deploy queue {0}: {1}";
    }
    @Override
    public final void loggingReloadFailed(final String configFile, final Exception e) {
        super.log.logv(FQCN, WARN, e, loggingReloadFailed$str(), configFile);
    }
    protected String loggingReloadFailed$str() {
        return "AMQ222276: Failed to process changes to the logging configuration file: {0}";
    }
    @Override
    public final void problemAddingConfigReloadCallback(final String propertyName, final Exception e) {
        super.log.logv(FQCN, WARN, e, problemAddingConfigReloadCallback$str(), propertyName);
    }
    protected String problemAddingConfigReloadCallback$str() {
        return "AMQ222277: Problem initializing automatic logging configuration reload for {0}";
    }
    @Override
    public final void unableToExtractGroupSequence(final Throwable e) {
        super.log.logv(FQCN, WARN, e, unableToExtractGroupSequence$str());
    }
    protected String unableToExtractGroupSequence$str() {
        return "AMQ222278: Unable to extract GroupSequence from message";
    }
    @Override
    public final void federationCantFindPolicyRef(final String upstreamName, final String policyRef) {
        super.log.logv(FQCN, WARN, null, federationCantFindPolicyRef$str(), upstreamName, policyRef);
    }
    protected String federationCantFindPolicyRef$str() {
        return "AMQ222279: Federation upstream {0} policy ref {1} could not be resolved in federation configuration";
    }
    @Override
    public final void federationUnknownPolicyType(final String upstreamName, final String policyRef) {
        super.log.logv(FQCN, WARN, null, federationUnknownPolicyType$str(), upstreamName, policyRef);
    }
    protected String federationUnknownPolicyType$str() {
        return "AMQ222280: Federation upstream {0} policy ref {1} is of unknown type in federation configuration";
    }
    @Override
    public final void federationAvoidStackOverflowPolicyRef(final String upstreamName, final String policyRef) {
        super.log.logv(FQCN, WARN, null, federationAvoidStackOverflowPolicyRef$str(), upstreamName, policyRef);
    }
    protected String federationAvoidStackOverflowPolicyRef$str() {
        return "AMQ222281: Federation upstream {0} policy ref {1} are too self referential, avoiding stack overflow , ";
    }
    @Override
    public final void federationCantFindUpstreamConnector(final String downstreamName, final String upstreamRef) {
        super.log.logv(FQCN, WARN, null, federationCantFindUpstreamConnector$str(), downstreamName, upstreamRef);
    }
    protected String federationCantFindUpstreamConnector$str() {
        return "AMQ222282: Federation downstream {0} upstream transport configuration ref {1} could not be resolved in federation configuration";
    }
    @Override
    public final void federationDownstreamDeployed(final String downstreamName) {
        super.log.logv(FQCN, INFO, null, federationDownstreamDeployed$str(), downstreamName);
    }
    protected String federationDownstreamDeployed$str() {
        return "AMQ222283: Federation downstream {0} has been deployed";
    }
    @Override
    public final void federationDownstreamUnDeployed(final String downstreamName) {
        super.log.logv(FQCN, INFO, null, federationDownstreamUnDeployed$str(), downstreamName);
    }
    protected String federationDownstreamUnDeployed$str() {
        return "AMQ222284: Federation downstream {0} has been undeployed";
    }
    @Override
    public final void emptyAddressFile(final String addressFile, final String directory) {
        super.log.logv(FQCN, WARN, null, emptyAddressFile$str(), addressFile, directory);
    }
    protected String emptyAddressFile$str() {
        return "AMQ222285: File {0} at {1} is empty. Delete the empty file to stop this message.";
    }
    @Override
    public final void federationPluginExecutionError(final Throwable e, final String pluginMethod) {
        super.log.logv(FQCN, WARN, e, federationPluginExecutionError$str(), pluginMethod);
    }
    protected String federationPluginExecutionError$str() {
        return "AMQ222286: Error executing {0} federation plugin method.";
    }
    @Override
    public final void federationBindingsLookupError(final Throwable e, final SimpleString address) {
        super.log.logv(FQCN, WARN, e, federationBindingsLookupError$str(), address);
    }
    protected String federationBindingsLookupError$str() {
        return "AMQ222287: Error looking up bindings for address {}.";
    }
    @Override
    public final void pageLookupError(final int pageNr, final int messageNr, final int offset, final int startNr) {
        super.log.logv(FQCN, WARN, null, pageLookupError$str(), pageNr, messageNr, offset, startNr);
    }
    protected String pageLookupError$str() {
        return "AMQ222288: Page {0}, message {1} could not be found on offset {2}, with starting message {3}. This represents a logic error or inconsistency on the data, and the system will try once again from the beggining of the page file.";
    }
    @Override
    public final void noMatchingBindingsOnDLAWithAutoCreateDLAResources(final SimpleString address, final String message) {
        super.log.logv(FQCN, WARN, null, noMatchingBindingsOnDLAWithAutoCreateDLAResources$str(), address, message);
    }
    protected String noMatchingBindingsOnDLAWithAutoCreateDLAResources$str() {
        return "AMQ222289: Did not route to any matching bindings on dead-letter-address {0} and auto-create-dead-letter-resources is true; dropping message: {1}";
    }
    @Override
    public final void failedToFindClusterConnection(final String packet) {
        super.log.logv(FQCN, WARN, null, failedToFindClusterConnection$str(), packet);
    }
    protected String failedToFindClusterConnection$str() {
        return "AMQ222290: Failed to find cluster-connection when handling cluster-connect packet. Ignoring: {0}";
    }
    @Override
    public final void metricsPluginElementDeprecated() {
        super.log.logv(FQCN, WARN, null, metricsPluginElementDeprecated$str());
    }
    protected String metricsPluginElementDeprecated$str() {
        return "AMQ222291: The metrics-plugin element is deprecated and replaced by the metrics element";
    }
    @Override
    public final void metricsPluginElementIgnored() {
        super.log.logv(FQCN, WARN, null, metricsPluginElementIgnored$str());
    }
    protected String metricsPluginElementIgnored$str() {
        return "AMQ222292: The metrics-plugin element is ignored because the metrics element is defined";
    }
    @Override
    public final void possibleSplitBrain(final String nodeID, final String connectionPairInformation) {
        super.log.logv(FQCN, WARN, null, possibleSplitBrain2$str(), nodeID, connectionPairInformation);
    }
    protected String possibleSplitBrain2$str() {
        return "AMQ222294: \n**************************************************************************************************************************************************************************************************************************************************************\nThere is a possible split brain on nodeID {0}, coming from connectors {1}. Topology update ignored.\n**************************************************************************************************************************************************************************************************************************************************************";
    }
    @Override
    public final void possibleSplitBrain(final String nodeID) {
        super.log.logv(FQCN, WARN, null, possibleSplitBrain1$str(), nodeID);
    }
    protected String possibleSplitBrain1$str() {
        return "AMQ222295: \n**************************************************************************************************************************************************************************************************************************************************************\nThere is a possible split brain on nodeID {0}. Topology update ignored.\n**************************************************************************************************************************************************************************************************************************************************************";
    }
    @Override
    public final void unableToDeployHawtioMBean(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableToDeployHawtioMBean$str());
    }
    protected String unableToDeployHawtioMBean$str() {
        return "AMQ222296: Unable to deploy Hawtio MBeam, console client side RBAC not available";
    }
    @Override
    public final void unableStartManagementContext(final Exception e) {
        super.log.logv(FQCN, WARN, e, unableStartManagementContext$str());
    }
    protected String unableStartManagementContext$str() {
        return "AMQ222297: Unable to start Management Context, RBAC not available";
    }
    @Override
    public final void failedToCreateBootstrapCredentials(final Exception e, final String user) {
        super.log.logv(FQCN, WARN, e, failedToCreateBootstrapCredentials$str(), user);
    }
    protected String failedToCreateBootstrapCredentials$str() {
        return "AMQ222298: Failed to create bootstrap user \"{0}\". User management may not function.";
    }
    @Override
    public final void noBootstrapCredentialsFound() {
        super.log.logv(FQCN, WARN, null, noBootstrapCredentialsFound$str());
    }
    protected String noBootstrapCredentialsFound$str() {
        return "AMQ222299: No bootstrap credentials found. User management may not function.";
    }
    @Override
    public final void gettingSslHandlerFailed(final String clientAddress, final String cause) {
        super.log.logv(FQCN, WARN, null, gettingSslHandlerFailed$str(), clientAddress, cause);
    }
    protected String gettingSslHandlerFailed$str() {
        return "AMQ222300: Getting SSL handler failed when serving client from {0}: {1}.";
    }
    @Override
    public final void duplicateAddressSettingMatch(final String match) {
        super.log.logv(FQCN, WARN, null, duplicateAddressSettingMatch$str(), match);
    }
    protected String duplicateAddressSettingMatch$str() {
        return "AMQ222301: Duplicate address-setting match found: {0}. These settings will be ignored! Please review your broker.xml and consolidate any duplicate address-setting elements.";
    }
    @Override
    public final void failedToDealWithObjectProperty(final SimpleString property, final String exceptionMessage) {
        super.log.logv(FQCN, WARN, null, failedToDealWithObjectProperty$str(), property, exceptionMessage);
    }
    protected String failedToDealWithObjectProperty$str() {
        return "AMQ222302: Failed to deal with property {0} when converting message from core to OpenWire: {1}";
    }
    @Override
    public final void errorRedistributing(final Throwable t, final String queueName, final long m) {
        super.log.logv(FQCN, WARN, t, errorRedistributing$str(), queueName, m);
    }
    protected String errorRedistributing$str() {
        return "AMQ222303: Redistribution by {0} of messageID = {1} failed";
    }
    @Override
    public final void unableToLoadMessageFromJournal(final Throwable t) {
        super.log.logv(FQCN, WARN, t, unableToLoadMessageFromJournal$str());
    }
    protected String unableToLoadMessageFromJournal$str() {
        return "AMQ222304: Unable to load message from journal";
    }
    @Override
    public final void federationDispatchError(final Throwable e, final String message) {
        super.log.logv(FQCN, WARN, e, federationDispatchError$str(), message);
    }
    protected String federationDispatchError$str() {
        return "AMQ222305: Error federating message {0}.";
    }
    @Override
    public final void failedToLoadPreparedTX(final Throwable e, final String message) {
        super.log.logv(FQCN, WARN, e, failedToLoadPreparedTX$str(), message);
    }
    protected String failedToLoadPreparedTX$str() {
        return "AMQ222306: Failed to load prepared TX and it will be rolled back: {0}";
    }
    @Override
    public final void initializationError(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, initializationError$str());
    }
    protected String initializationError$str() {
        return "AMQ224000: Failure in initialisation";
    }
    @Override
    public final void errorDeployingURI(final Throwable e, final URI uri) {
        super.log.logv(FQCN, ERROR, e, errorDeployingURI1$str(), uri);
    }
    protected String errorDeployingURI1$str() {
        return "AMQ224001: Error deploying URI {0}";
    }
    @Override
    public final void errorDeployingURI(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorDeployingURI0$str());
    }
    protected String errorDeployingURI0$str() {
        return "AMQ224002: Error deploying URI";
    }
    @Override
    public final void errorUnDeployingURI(final Throwable e, final URI a) {
        super.log.logv(FQCN, ERROR, e, errorUnDeployingURI$str(), a);
    }
    protected String errorUnDeployingURI$str() {
        return "AMQ224003: Error undeploying URI {0}";
    }
    @Override
    public final void unableToDeployNode(final Exception e, final Node node) {
        super.log.logv(FQCN, ERROR, e, unableToDeployNode$str(), node);
    }
    protected String unableToDeployNode$str() {
        return "AMQ224005: Unable to deploy node {0}";
    }
    @Override
    public final void invalidFilter(final SimpleString filter) {
        super.log.logv(FQCN, ERROR, null, invalidFilter$str(), filter);
    }
    protected String invalidFilter$str() {
        return "AMQ224006: Invalid filter: {0}";
    }
    @Override
    public final void pageSubscriptionError(final IOCallback IOCallback, final String error) {
        super.log.logv(FQCN, ERROR, null, pageSubscriptionError$str(), IOCallback, error);
    }
    protected String pageSubscriptionError$str() {
        return "AMQ224007: page subscription = {0} error={1}";
    }
    @Override
    public final void batchingIdError(final Exception e) {
        super.log.logv(FQCN, ERROR, e, batchingIdError$str());
    }
    protected String batchingIdError$str() {
        return "AMQ224008: Failed to store id";
    }
    @Override
    public final void cannotFindMessage(final Long id) {
        super.log.logv(FQCN, ERROR, null, cannotFindMessage$str(), id);
    }
    protected String cannotFindMessage$str() {
        return "AMQ224009: Cannot find message {0}";
    }
    @Override
    public final void journalCannotFindQueue(final Long queue, final Long id) {
        super.log.logv(FQCN, ERROR, null, journalCannotFindQueue$str(), queue, id);
    }
    protected String journalCannotFindQueue$str() {
        return "AMQ224010: Cannot find queue messages for queueID={0} on ack for messageID={1}";
    }
    @Override
    public final void journalCannotFindQueueScheduled(final Long queue, final Long id) {
        super.log.logv(FQCN, ERROR, null, journalCannotFindQueueScheduled$str(), queue, id);
    }
    protected String journalCannotFindQueueScheduled$str() {
        return "AMQ224011: Cannot find queue messages {0} for message {1} while processing scheduled messages";
    }
    @Override
    public final void largeMessageErrorReleasingResources(final Exception e) {
        super.log.logv(FQCN, ERROR, e, largeMessageErrorReleasingResources$str());
    }
    protected String largeMessageErrorReleasingResources$str() {
        return "AMQ224012: error releasing resources";
    }
    @Override
    public final void errorExpiringMessages(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorExpiringMessages$str());
    }
    protected String errorExpiringMessages$str() {
        return "AMQ224013: failed to expire messages for queue";
    }
    @Override
    public final void errorClosingSession(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorClosingSession$str());
    }
    protected String errorClosingSession$str() {
        return "AMQ224014: Failed to close session";
    }
    @Override
    public final void caughtXaException(final Exception e) {
        super.log.logv(FQCN, ERROR, e, caughtXaException$str());
    }
    protected String caughtXaException$str() {
        return "AMQ224015: Caught XA exception";
    }
    @Override
    public final void caughtException(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, caughtException$str());
    }
    protected String caughtException$str() {
        return "AMQ224016: Caught exception";
    }
    @Override
    public final void invalidPacket(final Packet packet) {
        super.log.logv(FQCN, ERROR, null, invalidPacket$str(), packet);
    }
    protected String invalidPacket$str() {
        return "AMQ224017: Invalid packet {0}";
    }
    @Override
    public final void failedToCreateSession(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToCreateSession$str());
    }
    protected String failedToCreateSession$str() {
        return "AMQ224018: Failed to create session";
    }
    @Override
    public final void failedToReattachSession(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToReattachSession$str());
    }
    protected String failedToReattachSession$str() {
        return "AMQ224019: Failed to reattach session";
    }
    @Override
    public final void failedToHandleCreateQueue(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToHandleCreateQueue$str());
    }
    protected String failedToHandleCreateQueue$str() {
        return "AMQ224020: Failed to handle create queue";
    }
    @Override
    public final void errorDecodingPacket(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorDecodingPacket$str());
    }
    protected String errorDecodingPacket$str() {
        return "AMQ224021: Failed to decode packet";
    }
    @Override
    public final void errorCallingFailureListener(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCallingFailureListener$str());
    }
    protected String errorCallingFailureListener$str() {
        return "AMQ224022: Failed to execute failure listener";
    }
    @Override
    public final void stompErrorTXExists(final String txID) {
        super.log.logv(FQCN, ERROR, null, stompErrorTXExists$str(), txID);
    }
    protected String stompErrorTXExists$str() {
        return "AMQ224024: Stomp Error, tx already exist! {0}";
    }
    @Override
    public final void errorWritingToInvmConnector(final Exception e, final Runnable runnable) {
        super.log.logv(FQCN, ERROR, e, errorWritingToInvmConnector$str(), runnable);
    }
    protected String errorWritingToInvmConnector$str() {
        return "AMQ224027: Failed to write to handler on invm connector {0}";
    }
    @Override
    public final void errorStoppingAcceptor(final String name) {
        super.log.logv(FQCN, ERROR, null, errorStoppingAcceptor$str(), name);
    }
    protected String errorStoppingAcceptor$str() {
        return "AMQ224028: Failed to stop acceptor {0}";
    }
    @Override
    public final void largeMessageIncompatible() {
        super.log.logv(FQCN, ERROR, null, largeMessageIncompatible$str());
    }
    protected String largeMessageIncompatible$str() {
        return "AMQ224029: large message sync: largeMessage instance is incompatible with it, ignoring data";
    }
    @Override
    public final void errorCancellingRefOnBridge(final Exception e, final org.apache.activemq.artemis.core.server.MessageReference ref2) {
        super.log.logv(FQCN, ERROR, e, errorCancellingRefOnBridge$str(), ref2);
    }
    protected String errorCancellingRefOnBridge$str() {
        return "AMQ224030: Could not cancel reference {0}";
    }
    @Override
    public final void errorPausingBridge(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorPausingBridge$str());
    }
    protected String errorPausingBridge$str() {
        return "AMQ224032: Failed to pause bridge";
    }
    @Override
    public final void errorBroadcastingConnectorConfigs(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorBroadcastingConnectorConfigs$str());
    }
    protected String errorBroadcastingConnectorConfigs$str() {
        return "AMQ224033: Failed to broadcast connector configs";
    }
    @Override
    public final void errorClosingConsumer(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorClosingConsumer$str());
    }
    protected String errorClosingConsumer$str() {
        return "AMQ224034: Failed to close consumer";
    }
    @Override
    public final void errorClosingFlowRecord(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorClosingFlowRecord$str());
    }
    protected String errorClosingFlowRecord$str() {
        return "AMQ224035: Failed to close cluster connection flow record";
    }
    @Override
    public final void errorUpdatingTopology(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorUpdatingTopology$str());
    }
    protected String errorUpdatingTopology$str() {
        return "AMQ224036: Failed to update cluster connection topology";
    }
    @Override
    public final void errorHandlingMessage(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorHandlingMessage$str());
    }
    protected String errorHandlingMessage$str() {
        return "AMQ224037: cluster connection Failed to handle message";
    }
    @Override
    public final void errorAckingOldReference(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorAckingOldReference$str());
    }
    protected String errorAckingOldReference$str() {
        return "AMQ224038: Failed to ack old reference";
    }
    @Override
    public final void errorExpiringRef(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorExpiringRef$str());
    }
    protected String errorExpiringRef$str() {
        return "AMQ224039: Failed to expire message reference";
    }
    @Override
    public final void errorRemovingConsumer(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorRemovingConsumer$str());
    }
    protected String errorRemovingConsumer$str() {
        return "AMQ224040: Failed to remove consumer";
    }
    @Override
    public final void errorDelivering(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorDelivering$str());
    }
    protected String errorDelivering$str() {
        return "AMQ224041: Failed to deliver";
    }
    @Override
    public final void errorRestartingBackupServer(final Exception e, final org.apache.activemq.artemis.core.server.ActiveMQServer backup) {
        super.log.logv(FQCN, ERROR, e, errorRestartingBackupServer$str(), backup);
    }
    protected String errorRestartingBackupServer$str() {
        return "AMQ224042: Error while restarting the backup server: {0}";
    }
    @Override
    public final void errorSendingForcedDelivery(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorSendingForcedDelivery$str());
    }
    protected String errorSendingForcedDelivery$str() {
        return "AMQ224043: Failed to send forced delivery message";
    }
    @Override
    public final void errorAckingMessage(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorAckingMessage$str());
    }
    protected String errorAckingMessage$str() {
        return "AMQ224044: error acknowledging message";
    }
    @Override
    public final void errorRunningLargeMessageDeliverer(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorRunningLargeMessageDeliverer$str());
    }
    protected String errorRunningLargeMessageDeliverer$str() {
        return "AMQ224045: Failed to run large message deliverer";
    }
    @Override
    public final void errorBrowserHandlingMessage(final Exception e, final org.apache.activemq.artemis.core.server.MessageReference current) {
        super.log.logv(FQCN, ERROR, e, errorBrowserHandlingMessage$str(), current);
    }
    protected String errorBrowserHandlingMessage$str() {
        return "AMQ224046: Exception while browser handled from {0}";
    }
    @Override
    public final void errorDeletingLargeMessageFile(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorDeletingLargeMessageFile$str());
    }
    protected String errorDeletingLargeMessageFile$str() {
        return "AMQ224047: Failed to delete large message file";
    }
    @Override
    public final void errorRemovingTempQueue(final Exception e, final SimpleString bindingName) {
        super.log.logv(FQCN, ERROR, e, errorRemovingTempQueue$str(), bindingName);
    }
    protected String errorRemovingTempQueue$str() {
        return "AMQ224048: Failed to remove temporary queue {0}";
    }
    @Override
    public final void cannotFindConsumer(final long consumerID) {
        super.log.logv(FQCN, ERROR, null, cannotFindConsumer$str(), consumerID);
    }
    protected String cannotFindConsumer$str() {
        return "AMQ224049: Cannot find consumer with id {0}";
    }
    @Override
    public final void errorClosingConnection(final ServerSessionImpl serverSession) {
        super.log.logv(FQCN, ERROR, null, errorClosingConnection$str(), serverSession);
    }
    protected String errorClosingConnection$str() {
        return "AMQ224050: Failed to close connection {0}";
    }
    @Override
    public final void errorCallingNotifListener(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorCallingNotifListener$str());
    }
    protected String errorCallingNotifListener$str() {
        return "AMQ224051: Failed to call notification listener";
    }
    @Override
    public final void errorCallingRepoListener(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCallingRepoListener$str());
    }
    protected String errorCallingRepoListener$str() {
        return "AMQ224052: Unable to call Hierarchical Repository Change Listener";
    }
    @Override
    public final void errorTimingOutTX(final Exception e, final Xid xid) {
        super.log.logv(FQCN, ERROR, e, errorTimingOutTX$str(), xid);
    }
    protected String errorTimingOutTX$str() {
        return "AMQ224053: failed to timeout transaction, xid:{0}";
    }
    @Override
    public final void errorStoppingReplicationManager(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, errorStoppingReplicationManager$str());
    }
    protected String errorStoppingReplicationManager$str() {
        return "AMQ224054: exception while stopping the replication manager";
    }
    @Override
    public final void bridgeFailedToAck(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, bridgeFailedToAck$str());
    }
    protected String bridgeFailedToAck$str() {
        return "AMQ224055: Bridge Failed to ack";
    }
    @Override
    public final void autoFailBackDenied() {
        super.log.logv(FQCN, ERROR, null, autoFailBackDenied$str());
    }
    protected String autoFailBackDenied$str() {
        return "AMQ224056: Live server will not fail-back automatically";
    }
    @Override
    public final void failbackMissedBackupAnnouncement() {
        super.log.logv(FQCN, ERROR, null, failbackMissedBackupAnnouncement$str());
    }
    protected String failbackMissedBackupAnnouncement$str() {
        return "AMQ224057: Backup server that requested fail-back was not announced. Server will not stop for fail-back.";
    }
    @Override
    public final void clusterManagerAuthenticationError(final String msg) {
        super.log.logv(FQCN, ERROR, null, clusterManagerAuthenticationError$str(), msg);
    }
    protected String clusterManagerAuthenticationError$str() {
        return "AMQ224058: Stopping ClusterManager. As it failed to authenticate with the cluster: {0}";
    }
    @Override
    public final void invalidCipherSuite(final String validSuites) {
        super.log.logv(FQCN, ERROR, null, invalidCipherSuite$str(), validSuites);
    }
    protected String invalidCipherSuite$str() {
        return "AMQ224059: Invalid cipher suite specified. Supported cipher suites are: {0}";
    }
    @Override
    public final void invalidProtocol(final String validProtocols) {
        super.log.logv(FQCN, ERROR, null, invalidProtocol$str(), validProtocols);
    }
    protected String invalidProtocol$str() {
        return "AMQ224060: Invalid protocol specified. Supported protocols are: {0}";
    }
    @Override
    public final void incompatibleWithHAPolicy(final String parameter) {
        super.log.logv(FQCN, ERROR, null, incompatibleWithHAPolicy$str(), parameter);
    }
    protected String incompatibleWithHAPolicy$str() {
        return "AMQ224061: Setting both <{0}> and <ha-policy> is invalid. Please use <ha-policy> exclusively as <{0}> is deprecated. Ignoring <{0}> value.";
    }
    @Override
    public final void failedToSendSlowConsumerNotification(final Notification notification, final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToSendSlowConsumerNotification$str(), notification);
    }
    protected String failedToSendSlowConsumerNotification$str() {
        return "AMQ224062: Failed to send SLOW_CONSUMER notification: {0}";
    }
    @Override
    public final void failedToCloseConsumerConnectionsForAddress(final String address, final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToCloseConsumerConnectionsForAddress$str(), address);
    }
    protected String failedToCloseConsumerConnectionsForAddress$str() {
        return "AMQ224063: Failed to close consumer connections for address {0}";
    }
    @Override
    public final void incompatibleWithHAPolicyChosen(final String parameter) {
        super.log.logv(FQCN, ERROR, null, incompatibleWithHAPolicyChosen$str(), parameter);
    }
    protected String incompatibleWithHAPolicyChosen$str() {
        return "AMQ224064: Setting <{0}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring <{0}> value.";
    }
    @Override
    public final void errorRemovingAutoCreatedDestination(final Exception e, final SimpleString bindingName, final String destinationType) {
        super.log.logv(FQCN, ERROR, e, errorRemovingAutoCreatedDestination$str(), bindingName, destinationType);
    }
    protected String errorRemovingAutoCreatedDestination$str() {
        return "AMQ224065: Failed to remove auto-created {1} {0}";
    }
    @Override
    public final void errorOpeningContextForLDAP(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorOpeningContextForLDAP$str());
    }
    protected String errorOpeningContextForLDAP$str() {
        return "AMQ224066: Error opening context for LDAP";
    }
    @Override
    public final void errorPopulatingSecurityRolesFromLDAP(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorPopulatingSecurityRolesFromLDAP$str());
    }
    protected String errorPopulatingSecurityRolesFromLDAP$str() {
        return "AMQ224067: Error populating security roles from LDAP";
    }
    @Override
    public final void errorStoppingComponent(final Throwable t, final String componentClassName) {
        super.log.logv(FQCN, ERROR, t, errorStoppingComponent$str(), componentClassName);
    }
    protected String errorStoppingComponent$str() {
        return "AMQ224068: Unable to stop component: {0}";
    }
    @Override
    public final void configurationReloadFailed(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, configurationReloadFailed$str());
    }
    protected String configurationReloadFailed$str() {
        return "AMQ224069: Change detected in broker configuration file, but reload failed";
    }
    @Override
    public final void invalidMessageCounterPeriod(final long value) {
        super.log.logv(FQCN, WARN, null, invalidMessageCounterPeriod$str(), value);
    }
    protected String invalidMessageCounterPeriod$str() {
        return "AMQ224072: Message Counter Sample Period too short: {0}";
    }
    @Override
    public final void journalUseMAPPED() {
        super.log.logv(FQCN, INFO, null, journalUseMAPPED$str());
    }
    protected String journalUseMAPPED$str() {
        return "AMQ224073: Using MAPPED Journal";
    }
    @Override
    public final void failedToPurgeQueue(final Exception e, final SimpleString bindingName) {
        super.log.logv(FQCN, ERROR, e, failedToPurgeQueue$str(), bindingName);
    }
    protected String failedToPurgeQueue$str() {
        return "AMQ224074: Failed to purge queue {0} on no consumers";
    }
    @Override
    public final void journalCannotFindPageTX(final Long id) {
        super.log.logv(FQCN, ERROR, null, journalCannotFindPageTX$str(), id);
    }
    protected String journalCannotFindPageTX$str() {
        return "AMQ224075: Cannot find pageTX id = {0}";
    }
    @Override
    public final void criticalSystemHalt(final Object component) {
        super.log.logv(FQCN, ERROR, null, criticalSystemHalt$str(), component);
    }
    protected String criticalSystemHalt$str() {
        return "AMQ224079: The process for the virtual machine will be killed, as component {0} is not responsive";
    }
    @Override
    public final void criticalSystemShutdown(final Object component) {
        super.log.logv(FQCN, ERROR, null, criticalSystemShutdown$str(), component);
    }
    protected String criticalSystemShutdown$str() {
        return "AMQ224080: The server process will now be stopped, as component {0} is not responsive";
    }
    @Override
    public final void criticalSystemLog(final Object component) {
        super.log.logv(FQCN, WARN, null, criticalSystemLog$str(), component);
    }
    protected String criticalSystemLog$str() {
        return "AMQ224081: The component {0} is not responsive";
    }
    @Override
    public final void undeployAddress(final SimpleString addressName) {
        super.log.logv(FQCN, INFO, null, undeployAddress$str(), addressName);
    }
    protected String undeployAddress$str() {
        return "AMQ224076: Undeploying address {0}";
    }
    @Override
    public final void undeployQueue(final SimpleString queueName) {
        super.log.logv(FQCN, INFO, null, undeployQueue$str(), queueName);
    }
    protected String undeployQueue$str() {
        return "AMQ224077: Undeploying queue {0}";
    }
    @Override
    public final void duplicateCacheSizeWarning(final int idCacheSize, final int confirmationWindowSize) {
        super.log.logv(FQCN, WARN, null, duplicateCacheSizeWarning$str(), idCacheSize, confirmationWindowSize);
    }
    protected String duplicateCacheSizeWarning$str() {
        return "AMQ224078: The size of duplicate cache detection (<id_cache-size/>) appears to be too large {0}. It should be no greater than the number of messages that can be squeezed into confirmation window buffer (<confirmation-window-size/>) {1}.";
    }
    @Override
    public final void failedToInvokeAnInterceptor(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToInvokeAnInterceptor$str());
    }
    protected String failedToInvokeAnInterceptor$str() {
        return "AMQ224082: Failed to invoke an interceptor";
    }
    @Override
    public final void failedToCloseContext(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToCloseContext$str());
    }
    protected String failedToCloseContext$str() {
        return "AMQ224083: Failed to close context";
    }
    @Override
    public final void failedToOpenContext(final Exception e) {
        super.log.logv(FQCN, ERROR, e, failedToOpenContext$str());
    }
    protected String failedToOpenContext$str() {
        return "AMQ224084: Failed to open context";
    }
    @Override
    public final void failedToLoadProperty(final Exception e, final String key, final String reason) {
        super.log.logv(FQCN, ERROR, e, failedToLoadProperty$str(), key, reason);
    }
    protected String failedToLoadProperty$str() {
        return "AMQ224085: Failed to load property {0}, reason: {1}";
    }
    @Override
    public final void caughtUnexpectedException(final NamingException e) {
        super.log.logv(FQCN, ERROR, e, caughtUnexpectedException$str());
    }
    protected String caughtUnexpectedException$str() {
        return "AMQ224086: Caught unexpected exception";
    }
    @Override
    public final void errorAnnouncingBackup(final String backupManager) {
        super.log.logv(FQCN, ERROR, null, errorAnnouncingBackup1$str(), backupManager);
    }
    protected String errorAnnouncingBackup1$str() {
        return "AMQ224087: Error announcing backup: backupServerLocator is null. {0}";
    }
    @Override
    public final void handshakeTimeout(final int timeout, final String acceptorName, final String remoteAddress) {
        super.log.logv(FQCN, ERROR, null, handshakeTimeout$str(), timeout, acceptorName, remoteAddress);
    }
    protected String handshakeTimeout$str() {
        return "AMQ224088: Timeout ({0} seconds) on acceptor \"{1}\" during protocol handshake with {2} has occurred.";
    }
    @Override
    public final void errorCalculatePersistentSize(final Throwable e) {
        super.log.logv(FQCN, WARN, e, errorCalculatePersistentSize$str());
    }
    protected String errorCalculatePersistentSize$str() {
        return "AMQ224089: Failed to calculate persistent size";
    }
    @Override
    public final void noVoteHandlerConfigured() {
        super.log.logv(FQCN, WARN, null, noVoteHandlerConfigured$str());
    }
    protected String noVoteHandlerConfigured$str() {
        return "AMQ224090: This node is not configured for Quorum Voting, all nodes must be configured for HA";
    }
    @Override
    public final void errorConnectingBridgeRetry(final Bridge bridge) {
        super.log.logv(FQCN, WARN, null, errorConnectingBridgeRetry$str(), bridge);
    }
    protected String errorConnectingBridgeRetry$str() {
        return "AMQ224091: Bridge {0} is unable to connect to destination. Retrying";
    }
    @Override
    public final void pageWillBePersisted() {
        super.log.logv(FQCN, INFO, null, pageWillBePersisted$str());
    }
    protected String pageWillBePersisted$str() {
        return "AMQ224092: Despite disabled persistence, page files will be persisted.";
    }
    @Override
    public final void nullRefMessage() {
        super.log.logv(FQCN, ERROR, null, nullRefMessage$str());
    }
    protected String nullRefMessage$str() {
        return "AMQ224093: Reference to message is null";
    }
    @Override
    public final void quorumVoteAwaitInterrupted() {
        super.log.logv(FQCN, TRACE, null, quorumVoteAwaitInterrupted$str());
    }
    protected String quorumVoteAwaitInterrupted$str() {
        return "AMQ224094: Quorum vote result await is interrupted";
    }
    @Override
    public final void consumerCountError(final String reason) {
        super.log.logv(FQCN, ERROR, null, consumerCountError$str(), reason);
    }
    protected String consumerCountError$str() {
        return "AMQ224095: Error updating Consumer Count: {0}";
    }
    @Override
    public final void failedToFindProtocolManager(final String remoteAddress, final String localAddress, final String intendedProtocolManager, final String protocolMap) {
        super.log.logv(FQCN, ERROR, null, failedToFindProtocolManager$str(), remoteAddress, localAddress, intendedProtocolManager, protocolMap);
    }
    protected String failedToFindProtocolManager$str() {
        return "AMQ224096: Error setting up connection from {0} to {1}; protocol {2} not found in map: {3}";
    }
    @Override
    public final void failedToStartServer(final Throwable t) {
        super.log.logv(FQCN, ERROR, t, failedToStartServer$str());
    }
    protected String failedToStartServer$str() {
        return "AMQ224097: Failed to start server";
    }
    @Override
    public final void quorumBackupIsLive(final String liveConnector) {
        super.log.logv(FQCN, INFO, null, quorumBackupIsLive$str(), liveConnector);
    }
    protected String quorumBackupIsLive$str() {
        return "AMQ224098: Received a vote saying the backup is live with connector: {0}";
    }
    @Override
    public final void messageWithHeaderTooLarge(final Long messageID, final String loggerClass) {
        super.log.logv(FQCN, WARN, null, messageWithHeaderTooLarge$str(), messageID, loggerClass);
    }
    protected String messageWithHeaderTooLarge$str() {
        return "AMQ224099: Message with ID {0} has a header too large. More information available on debug level for class {1}";
    }
    @Override
    public final void timedOutWaitingForLargeMessagesDeletion(final List<Long> largeMessageIds) {
        super.log.logv(FQCN, INFO, null, timedOutWaitingForLargeMessagesDeletion$str(), largeMessageIds);
    }
    protected String timedOutWaitingForLargeMessagesDeletion$str() {
        return "AMQ224100: Timed out waiting for large messages deletion with IDs {0}, might not be deleted if broker crashes atm";
    }
    @Override
    public final void scheduledPoolWithNoRemoveOnCancelPolicy() {
        super.log.logv(FQCN, WARN, null, scheduledPoolWithNoRemoveOnCancelPolicy$str());
    }
    protected String scheduledPoolWithNoRemoveOnCancelPolicy$str() {
        return "AMQ224101: Apache ActiveMQ Artemis is using a scheduled pool without remove on cancel policy, so a cancelled task could be not automatically removed from the work queue, it may also cause unbounded retention of cancelled tasks.";
    }
    @Override
    public final void unableToUndeployAddress(final SimpleString addressName, final String reason) {
        super.log.logv(FQCN, INFO, null, unableToUndeployAddress$str(), addressName, reason);
    }
    protected String unableToUndeployAddress$str() {
        return "AMQ224102: unable to undeploy address {0} : reason {1}";
    }
    @Override
    public final void unableToUndeployQueue(final SimpleString queueName, final String reason) {
        super.log.logv(FQCN, INFO, null, unableToUndeployQueue$str(), queueName, reason);
    }
    protected String unableToUndeployQueue$str() {
        return "AMQ224103: unable to undeploy queue {0} : reason {1}";
    }
    @Override
    public final void errorStartingAcceptor(final String name, final Object configuration) {
        super.log.logv(FQCN, ERROR, null, errorStartingAcceptor$str(), name, configuration);
    }
    protected String errorStartingAcceptor$str() {
        return "AMQ224104: Error starting the Acceptor {0} {1}";
    }
    @Override
    public final void failedConnectingToCluster(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedConnectingToCluster$str());
    }
    protected String failedConnectingToCluster$str() {
        return "AMQ224105: Connecting to cluster failed";
    }
    @Override
    public final void errorRemovingTX(final Exception e, final Xid xid) {
        super.log.logv(FQCN, ERROR, e, errorRemovingTX$str(), xid);
    }
    protected String errorRemovingTX$str() {
        return "AMQ224106: failed to remove transaction, xid:{0}";
    }
    @Override
    public final void enableTraceForCriticalAnalyzer() {
        super.log.logv(FQCN, INFO, null, enableTraceForCriticalAnalyzer$str());
    }
    protected String enableTraceForCriticalAnalyzer$str() {
        return "AMQ224107: The Critical Analyzer detected slow paths on the broker.  It is recommended that you enable trace logs on org.apache.activemq.artemis.utils.critical while you troubleshoot this issue. You should disable the trace logs when you have finished troubleshooting.";
    }
    @Override
    public final void pageStoreStop(final SimpleString storeName, final long addressSize, final long maxSize, final long globalMaxSize) {
        super.log.logv(FQCN, WARN, null, pageStoreStop$str(), storeName, addressSize, maxSize, globalMaxSize);
    }
    protected String pageStoreStop$str() {
        return "AMQ224108: Stopped paging on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}; global-size-bytes: {3}";
    }
    @Override
    public final void brokerBalancerNotFound(final String name) {
        super.log.logv(FQCN, WARN, null, brokerBalancerNotFound$str(), name);
    }
    protected String brokerBalancerNotFound$str() {
        return "AMQ224109: BrokerBalancer {0} not found";
    }
    @Override
    public final void useAllowList() {
        super.log.logv(FQCN, WARN, null, useAllowList$str());
    }
    protected String useAllowList$str() {
        return "AMQ224110: Configuration 'whitelist' is deprecated, please use the 'allowlist' configuration";
    }
    @Override
    public final void useOnlyAllowList() {
        super.log.logv(FQCN, WARN, null, useOnlyAllowList$str());
    }
    protected String useOnlyAllowList$str() {
        return "AMQ224111: Both 'whitelist' and 'allowlist' detected. Configuration 'whitelist' is deprecated, please use only the 'allowlist' configuration";
    }
    @Override
    public final void autoRemoveQueue(final String name, final long queueID, final String address) {
        super.log.logv(FQCN, INFO, null, autoRemoveQueue$str(), name, queueID, address);
    }
    protected String autoRemoveQueue$str() {
        return "AMQ224112: Auto removing Queue {0} with queueID={1} on address={2}";
    }
    @Override
    public final void autoRemoveAddress(final String name) {
        super.log.logv(FQCN, INFO, null, autoRemoveAddress$str(), name);
    }
    protected String autoRemoveAddress$str() {
        return "AMQ224113: Auto removing Address {0}";
    }
    @Override
    public final void blockingViaControl(final SimpleString addressName) {
        super.log.logv(FQCN, INFO, null, blockingViaControl$str(), addressName);
    }
    protected String blockingViaControl$str() {
        return "AMQ224114: Address control block, blocking message production on address ''{0}''. Clients will not get further credit.";
    }
    @Override
    public final void unblockingViaControl(final SimpleString addressName) {
        super.log.logv(FQCN, INFO, null, unblockingViaControl$str(), addressName);
    }
    protected String unblockingViaControl$str() {
        return "AMQ224115: Address control unblock of address ''{0}''. Clients will be granted credit as normal.";
    }
}
