// automatically generated, do not modify

package org.apache.arrow.flatbuf;

import java.nio.*;
import java.lang.*;
import java.util.*;
import com.google.flatbuffers.*;

@SuppressWarnings("unused")
/**
 * A data header describing the shared memory layout of a "record" or "row"
 * batch. Some systems call this a "row batch" internally and others a "record
 * batch".
 */
public final class RecordBatch extends Table {
  public static RecordBatch getRootAsRecordBatch(ByteBuffer _bb) { return getRootAsRecordBatch(_bb, new RecordBatch()); }
  public static RecordBatch getRootAsRecordBatch(ByteBuffer _bb, RecordBatch obj) { _bb.order(ByteOrder.LITTLE_ENDIAN); return (obj.__init(_bb.getInt(_bb.position()) + _bb.position(), _bb)); }
  public RecordBatch __init(int _i, ByteBuffer _bb) { bb_pos = _i; bb = _bb; return this; }

  /**
   * number of records / rows. The arrays in the batch should all have this
   * length
   */
  public long length() { int o = __offset(4); return o != 0 ? bb.getLong(o + bb_pos) : 0; }
  /**
   * Nodes correspond to the pre-ordered flattened logical schema
   */
  public FieldNode nodes(int j) { return nodes(new FieldNode(), j); }
  public FieldNode nodes(FieldNode obj, int j) { int o = __offset(6); return o != 0 ? obj.__init(__vector(o) + j * 16, bb) : null; }
  public int nodesLength() { int o = __offset(6); return o != 0 ? __vector_len(o) : 0; }
  /**
   * Buffers correspond to the pre-ordered flattened buffer tree
   *
   * The number of buffers appended to this list depends on the schema. For
   * example, most primitive arrays will have 2 buffers, 1 for the validity
   * bitmap and 1 for the values. For struct arrays, there will only be a
   * single buffer for the validity (nulls) bitmap
   */
  public Buffer buffers(int j) { return buffers(new Buffer(), j); }
  public Buffer buffers(Buffer obj, int j) { int o = __offset(8); return o != 0 ? obj.__init(__vector(o) + j * 16, bb) : null; }
  public int buffersLength() { int o = __offset(8); return o != 0 ? __vector_len(o) : 0; }

  public static int createRecordBatch(FlatBufferBuilder builder,
      long length,
      int nodes,
      int buffers) {
    builder.startObject(3);
    RecordBatch.addLength(builder, length);
    RecordBatch.addBuffers(builder, buffers);
    RecordBatch.addNodes(builder, nodes);
    return RecordBatch.endRecordBatch(builder);
  }

  public static void startRecordBatch(FlatBufferBuilder builder) { builder.startObject(3); }
  public static void addLength(FlatBufferBuilder builder, long length) { builder.addLong(0, length, 0); }
  public static void addNodes(FlatBufferBuilder builder, int nodesOffset) { builder.addOffset(1, nodesOffset, 0); }
  public static void startNodesVector(FlatBufferBuilder builder, int numElems) { builder.startVector(16, numElems, 8); }
  public static void addBuffers(FlatBufferBuilder builder, int buffersOffset) { builder.addOffset(2, buffersOffset, 0); }
  public static void startBuffersVector(FlatBufferBuilder builder, int numElems) { builder.startVector(16, numElems, 8); }
  public static int endRecordBatch(FlatBufferBuilder builder) {
    int o = builder.endObject();
    return o;
  }
};

