/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.atlas.authorize.simple.AtlasSimpleAuthzPolicy;

public class AtlasSimpleAuthzUpdateTool {
    public static void main(String[] args) {
        if (args != null & args.length > 0) {
            AtlasSimpleAuthzUpdateTool.updateSimpleAuthzJsonWithRelationshipPermissions(args[0]);
        } else {
            System.out.println("Provide Atlas conf path");
        }
    }

    public static void updateSimpleAuthzJsonWithRelationshipPermissions(String jsonConfPath) {
        ArrayList<String> wildCard = new ArrayList<String>();
        wildCard.add(".*");
        try {
            ObjectMapper mapper = new ObjectMapper();
            AtlasSimpleAuthzPolicy authzPolicy = (AtlasSimpleAuthzPolicy)mapper.readValue(new File(jsonConfPath + "/atlas-simple-authz-policy.json"), AtlasSimpleAuthzPolicy.class);
            AtlasSimpleAuthzPolicy.AtlasAuthzRole dataAdmin = authzPolicy.getRoles().get("ROLE_ADMIN");
            boolean permissionUpdated = false;
            if (dataAdmin != null && dataAdmin.getRelationshipPermissions() == null) {
                AtlasSimpleAuthzPolicy.AtlasRelationshipPermission relationshipPermissions = new AtlasSimpleAuthzPolicy.AtlasRelationshipPermission();
                relationshipPermissions.setPrivileges(wildCard);
                relationshipPermissions.setRelationshipTypes(wildCard);
                relationshipPermissions.setEnd1EntityClassification(wildCard);
                relationshipPermissions.setEnd1EntityId(wildCard);
                relationshipPermissions.setEnd1EntityType(wildCard);
                relationshipPermissions.setEnd2EntityClassification(wildCard);
                relationshipPermissions.setEnd2EntityId(wildCard);
                relationshipPermissions.setEnd2EntityType(wildCard);
                ArrayList<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission> relationshipPermissionsList = new ArrayList<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission>();
                relationshipPermissionsList.add(relationshipPermissions);
                dataAdmin.setRelationshipPermissions(relationshipPermissionsList);
                permissionUpdated = true;
            }
            AtlasSimpleAuthzPolicy.AtlasAuthzRole dataSteward = authzPolicy.getRoles().get("DATA_STEWARD");
            ArrayList<String> permissiondataSteward = new ArrayList<String>();
            permissiondataSteward.add("add-relationship");
            permissiondataSteward.add("update-relationship");
            permissiondataSteward.add("remove-relationship");
            if (dataSteward != null && dataSteward.getRelationshipPermissions() == null) {
                AtlasSimpleAuthzPolicy.AtlasRelationshipPermission relationshipPermissions = new AtlasSimpleAuthzPolicy.AtlasRelationshipPermission();
                relationshipPermissions.setPrivileges(permissiondataSteward);
                relationshipPermissions.setRelationshipTypes(wildCard);
                relationshipPermissions.setEnd1EntityClassification(wildCard);
                relationshipPermissions.setEnd1EntityId(wildCard);
                relationshipPermissions.setEnd1EntityType(wildCard);
                relationshipPermissions.setEnd2EntityClassification(wildCard);
                relationshipPermissions.setEnd2EntityId(wildCard);
                relationshipPermissions.setEnd2EntityType(wildCard);
                ArrayList<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission> relationshipPermissionsList = new ArrayList<AtlasSimpleAuthzPolicy.AtlasRelationshipPermission>();
                relationshipPermissionsList.add(relationshipPermissions);
                dataSteward.setRelationshipPermissions(relationshipPermissionsList);
                permissionUpdated = true;
            }
            if (permissionUpdated) {
                AtlasSimpleAuthzUpdateTool.writeUsingFiles(jsonConfPath + "/atlas-simple-authz-policy.json", AtlasSimpleAuthzUpdateTool.toJson(authzPolicy, mapper));
            }
        }
        catch (Exception e) {
            System.err.println(" Error while updating JSON " + e.getMessage());
        }
    }

    public static String toJson(Object obj, ObjectMapper mapper) {
        String ret;
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            ret = obj instanceof JsonNode && ((JsonNode)obj).isTextual() ? ((JsonNode)obj).textValue() : mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            ret = null;
        }
        return ret;
    }

    private static void writeUsingFiles(String file, String data) {
        try {
            Files.write(Paths.get(file, new String[0]), data.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println(" Error while writeUsingFiles JSON " + e.getMessage());
        }
    }
}

