/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChildServiceSupport
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ChildServiceSupport.class);
    protected volatile List<Service> childServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 4) {
                LOG.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 3) {
                LOG.trace("Service: {} already starting", (Object)this);
                return;
            }
            try {
                this.initService(this.childServices);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while initializing service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            try {
                this.status = (byte)3;
                LOG.trace("Starting service: {}", (Object)this);
                ServiceHelper.startService(this.childServices);
                this.doStart();
                this.status = (byte)4;
                LOG.trace("Service: {} started", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while starting service: " + (Object)((Object)this), (Throwable)e);
                ServiceHelper.stopService(this.childServices);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 8 || this.status == 9 || this.status == 10) {
                LOG.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 7) {
                LOG.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = (byte)7;
            LOG.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                ServiceHelper.stopService(this.childServices);
                this.status = (byte)8;
                LOG.trace("Service: {} stopped service", (Object)this);
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error while stopping service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 10) {
                LOG.trace("Service: {} already shut down", (Object)this);
                return;
            }
            if (this.status == 9) {
                LOG.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = (byte)10;
            LOG.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                ServiceHelper.stopAndShutdownServices(this.childServices);
                LOG.trace("Service: {} shut down", (Object)this);
                this.status = (byte)10;
            }
            catch (Exception e) {
                this.status = (byte)11;
                LOG.trace("Error shutting down service: " + (Object)((Object)this), (Throwable)e);
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildService(Object childService) {
        if (childService instanceof Service) {
            if (this.childServices == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.childServices == null) {
                        this.childServices = new ArrayList<Service>();
                    }
                }
            }
            this.childServices.add((Service)childService);
        }
    }

    protected boolean removeChildService(Object childService) {
        return this.childServices != null && this.childServices.remove(childService);
    }

    private void initService(List<Service> services) {
        if (services != null) {
            services.forEach(Service::init);
        }
    }
}

