/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.invoker;

import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.exception.InvokerException;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class XmlRpcInvoker
implements Invoker {
    private final XmlRpcHandler handler;
    private final String handlerName;

    public XmlRpcInvoker(XmlRpcHandler handler, String handlerName) {
        this.handler = handler;
        this.handlerName = handlerName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = this.handler.execute(this.handlerName + "." + method.getName(), this.toArgumentVector(args));
        if (returnValue instanceof XmlRpcException) {
            throw new InvokerException("Unable to execute XML-RPC call.", (Throwable)((XmlRpcException)returnValue));
        }
        return returnValue;
    }

    private Vector toArgumentVector(Object[] args) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            v.addElement(arg);
        }
        return v;
    }
}

