/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trust13Builder
implements AssertionBuilder {
    public PolicyAssertion build(Element element) {
        if ((element = PolicyConstants.findPolicyElement((Element)element)) == null) {
            throw new IllegalArgumentException("Trust13 assertion doesn't contain any Policy");
        }
        Trust13 trust13 = new Trust13(SP12Constants.INSTANCE);
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.MUST_SUPPORT_CLIENT_CHALLENGE) != null) {
            trust13.setMustSupportClientChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.MUST_SUPPORT_SERVER_CHALLENGE) != null) {
            trust13.setMustSupportServerChallenge(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.REQUIRE_CLIENT_ENTROPY) != null) {
            trust13.setRequireClientEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.REQUIRE_SERVER_ENTROPY) != null) {
            trust13.setRequireServerEntropy(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.MUST_SUPPORT_ISSUED_TOKENS) != null) {
            trust13.setMustSupportIssuedTokens(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.REQUIRE_REQUEST_SECURITY_TOKEN_COLLECTION) != null) {
            trust13.setRequireRequestSecurityTokenCollection(true);
        }
        if (DOMUtils.getFirstChildWithName((Element)element, (QName)SP12Constants.REQUIRE_APPLIES_TO) != null) {
            trust13.setRequireAppliesTo(true);
        }
        return trust13;
    }

    public List<QName> getKnownElements() {
        return Collections.singletonList(SP12Constants.TRUST_13);
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

