/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.File;
import java.io.IOException;
import javax.naming.NamingException;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.LdapServerFactory;
import org.apache.directory.server.integ.state.AbstractState;
import org.apache.directory.server.integ.state.TestServerContext;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonExistentState
extends AbstractState {
    private static final Logger LOG = LoggerFactory.getLogger(NonExistentState.class);

    public NonExistentState(TestServerContext context) {
        super(context);
    }

    public void create(InheritableServerSettings settings) throws NamingException {
        LOG.debug("calling create()");
        try {
            LdapServerFactory factory = settings.getFactory();
            this.context.setLdapServer(factory.newInstance());
        }
        catch (InstantiationException ie) {
            throw new NamingException(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new NamingException(iae.getMessage());
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
    }

    public void cleanup() throws IOException {
        LOG.debug("calling cleanup()");
        IntegrationUtils.doDelete((File)this.context.getLdapServer().getDirectoryService().getWorkingDirectory());
    }

    public void startup() throws Exception {
        LOG.debug("calling startup()");
        this.context.getLdapServer().getDirectoryService().startup();
        this.context.getLdapServer().start();
    }

    public void test(TestClass testClass, Statement statement, RunNotifier notifier, InheritableServerSettings settings) {
        LOG.debug("calling test(): {}, mode {}", (Object)settings.getDescription().getDisplayName(), (Object)settings.getMode());
        switch (settings.getMode()) {
            case CUMULATIVE: 
            case RESTART: {
                try {
                    this.create(settings);
                }
                catch (NamingException ne) {
                    LOG.error("Failed to create and start new server instance: " + ne);
                    this.testAborted(notifier, settings.getDescription(), ne);
                    return;
                }
                try {
                    this.startup();
                }
                catch (Exception e) {
                    LOG.error("Failed to create and start new server instance: " + e);
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                this.context.setState(this.context.getStartedNormalState());
                this.context.getState().test(testClass, statement, notifier, settings);
                return;
            }
            case PRISTINE: 
            case ROLLBACK: {
                try {
                    this.create(settings);
                }
                catch (NamingException ne) {
                    LOG.error("Failed to create and start new server instance: " + ne);
                    this.testAborted(notifier, settings.getDescription(), ne);
                    return;
                }
                try {
                    this.cleanup();
                }
                catch (IOException ioe) {
                    LOG.error("Failed to create and start new server instance: " + ioe);
                    this.testAborted(notifier, settings.getDescription(), ioe);
                    return;
                }
                try {
                    this.startup();
                }
                catch (Exception e) {
                    LOG.error("Failed to create and start new server instance: " + e);
                    this.testAborted(notifier, settings.getDescription(), e);
                    return;
                }
                this.context.setState(this.context.getStartedPristineState());
                this.context.getState().test(testClass, statement, notifier, settings);
                return;
            }
        }
    }
}

