/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.abandon;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonRequestCodec
extends LdapMessageCodec {
    private static Logger log = LoggerFactory.getLogger(AbandonRequestCodec.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private int abandonedMessageId;

    public int getAbandonedMessageId() {
        return this.abandonedMessageId;
    }

    public int getMessageType() {
        return 0;
    }

    public void setAbandonedMessageId(int abandonedMessageId) {
        this.abandonedMessageId = abandonedMessageId;
    }

    public int computeLength() {
        int length = 2 + Value.getNbBytes((int)this.abandonedMessageId);
        if (IS_DEBUG) {
            log.debug("Message length : {}", (Object)length);
        }
        return length;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            log.error("Cannot put a PDU in a null buffer !");
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)80);
            buffer.put((byte)Value.getNbBytes((int)this.abandonedMessageId));
            buffer.put(Value.getBytes((int)this.abandonedMessageId));
        }
        catch (BufferOverflowException boe) {
            log.error("The PDU buffer size is too small !");
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Abandon Request :\n");
        sb.append("        Message Id : ").append(this.abandonedMessageId).append('\n');
        return sb.toString();
    }
}

