/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.del;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DelRequestCodec
extends LdapMessageCodec {
    private LdapDN entry;

    public int getMessageType() {
        return 7;
    }

    public LdapDN getEntry() {
        return this.entry;
    }

    public void setEntry(LdapDN entry) {
        this.entry = entry;
    }

    public int computeLength() {
        return 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.entry)) + LdapDN.getNbBytes(this.entry);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)74);
            buffer.put(TLV.getBytes((int)LdapDN.getNbBytes(this.entry)));
            buffer.put(LdapDN.getBytes(this.entry));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Del request\n");
        sb.append("        Entry : '").append(this.entry).append("'\n");
        return sb.toString();
    }
}

