/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.UnsupportedEncodingException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.LdifAttributesReader;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdifUtils {
    private static boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET;
    private static boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET;
    private static final int DEFAULT_LINE_LENGTH = 80;

    public static boolean isLDIFSafe(String str) {
        if (StringTools.isEmpty(str)) {
            return true;
        }
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            currentChar = str.charAt(i);
            if (currentChar <= '\u007f' && LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) continue;
            return false;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws NamingException {
        return LdifUtils.convertAttributesToLdif(AttributeUtils.toClientEntry(attrs, null), 80);
    }

    public static String convertToLdif(Attributes attrs, int length) throws NamingException {
        return LdifUtils.convertAttributesToLdif(AttributeUtils.toClientEntry(attrs, null), length);
    }

    public static String convertToLdif(Attributes attrs, LdapDN dn, int length) throws NamingException {
        return LdifUtils.convertEntryToLdif(AttributeUtils.toClientEntry(attrs, dn), length);
    }

    public static String convertToLdif(Attributes attrs, LdapDN dn) throws NamingException {
        return LdifUtils.convertEntryToLdif(AttributeUtils.toClientEntry(attrs, dn), 80);
    }

    public static String convertEntryToLdif(Entry entry) throws NamingException {
        return LdifUtils.convertEntryToLdif(entry, 80);
    }

    public static String convertAttributesToLdif(Entry entry) throws NamingException {
        return LdifUtils.convertAttributesToLdif(entry, 80);
    }

    public static Attributes convertAttributesFromLdif(String ldif) throws NamingException {
        LdifAttributesReader reader = new LdifAttributesReader();
        return reader.parseAttributes(ldif);
    }

    public static String convertEntryToLdif(Entry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        if (entry.getDn() != null) {
            if (LdifUtils.isLDIFSafe(entry.getDn().getUpName())) {
                sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn().getUpName(), length));
            } else {
                sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn().getUpName()), length));
            }
            sb.append('\n');
        }
        for (EntryAttribute attribute : entry) {
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertAttributesToLdif(Entry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        for (EntryAttribute attribute : entry) {
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertToLdif(LdifEntry entry) throws NamingException {
        return LdifUtils.convertToLdif(entry, 80);
    }

    public static String convertToLdif(LdifEntry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        if (LdifUtils.isLDIFSafe(entry.getDn().getUpName())) {
            sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn(), length));
        } else {
            sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn().getUpName()), length));
        }
        sb.append('\n');
        String changeType = entry.getChangeType().toString().toLowerCase();
        sb.append(LdifUtils.stripLineToNChars("changetype: " + changeType, length));
        sb.append('\n');
        switch (entry.getChangeType()) {
            case Delete: {
                if (entry.getEntry() == null) break;
                throw new NamingException("Invalid Entry : a deleted entry should not contain attributes");
            }
            case Add: {
                if (entry.getEntry() == null) {
                    throw new NamingException("Invalid Entry : a added or modified entry should contain attributes");
                }
                for (EntryAttribute attribute : entry.getEntry()) {
                    sb.append(LdifUtils.convertToLdif(attribute, length));
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (entry.getEntry() != null) {
                    throw new NamingException("Invalid Entry : a modifyDN operation entry should not contain attributes");
                }
                DefaultClientAttribute newRdn = new DefaultClientAttribute("newrdn", entry.getNewRdn());
                sb.append(LdifUtils.convertToLdif(newRdn, length));
                sb.append("deleteoldrdn: ");
                if (entry.isDeleteOldRdn()) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append('\n');
                if (StringTools.isEmpty(entry.getNewSuperior())) break;
                DefaultClientAttribute newSuperior = new DefaultClientAttribute("newsuperior", entry.getNewSuperior());
                sb.append(LdifUtils.convertToLdif(newSuperior, length));
                break;
            }
            case Modify: {
                for (Modification modification : entry.getModificationItems()) {
                    switch (modification.getOperation()) {
                        case ADD_ATTRIBUTE: {
                            sb.append("add: ");
                            break;
                        }
                        case REMOVE_ATTRIBUTE: {
                            sb.append("delete: ");
                            break;
                        }
                        case REPLACE_ATTRIBUTE: {
                            sb.append("replace: ");
                            break;
                        }
                    }
                    sb.append(modification.getAttribute().getId());
                    sb.append('\n');
                    sb.append(LdifUtils.convertToLdif(modification.getAttribute()));
                    sb.append("-\n");
                }
                break;
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String encodeBase64(String str) {
        char[] encoded = null;
        try {
            encoded = Base64.encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            encoded = Base64.encode(str.getBytes());
        }
        return new String(encoded);
    }

    public static String convertToLdif(EntryAttribute attr) throws NamingException {
        return LdifUtils.convertToLdif(attr, 80);
    }

    public static String convertToLdif(EntryAttribute attr, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        for (Value value : attr) {
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(attr.getId());
            if (value.isNull()) {
                lineBuffer.append(':');
            } else if (value.isBinary()) {
                char[] encoded = Base64.encode(value.getBytes());
                lineBuffer.append(":: " + new String(encoded));
            } else if (!value.isBinary()) {
                String str = value.getString();
                if (!LdifUtils.isLDIFSafe(str)) {
                    lineBuffer.append(":: " + LdifUtils.encodeBase64(str));
                } else {
                    lineBuffer.append(":");
                    if (str != null) {
                        lineBuffer.append(" ").append(str);
                    }
                }
            }
            lineBuffer.append("\n");
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), length));
        }
        return sb.toString();
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        if (nbChars < 2) {
            throw new IllegalArgumentException("The length of each line must be at least 2 chars long");
        }
        int charsPerLine = nbChars - 1;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        for (int i = 0; i < nbLines - 2; ++i) {
            buffer[posDst++] = 10;
            buffer[posDst++] = 32;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
        }
        buffer[posDst++] = 10;
        buffer[posDst++] = 32;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }

    static {
        int i;
        LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
        LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }
}

