/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;

public class CsnSidSyntaxChecker
extends AbstractSyntaxChecker {
    public static final SyntaxChecker INSTANCE = new CsnSidSyntaxChecker();

    public CsnSidSyntaxChecker() {
        super("1.3.6.1.4.1.4203.666.11.2.4");
    }

    protected CsnSidSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String sidStr = (String)value;
        if (sidStr.length() > 3) {
            return false;
        }
        try {
            int sid = Integer.parseInt(sidStr, 16);
            if (sid < 0 || sid > 4095) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

