/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.flink.api.java.io.jdbc.AbstractJDBCOutputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCUtils;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCOutputFormat
extends AbstractJDBCOutputFormat<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCOutputFormat.class);
    private final String query;
    private final int batchInterval;
    private final int[] typesArray;
    private PreparedStatement upload;
    private int batchCount = 0;

    public JDBCOutputFormat(String username, String password, String drivername, String dbURL, String query, int batchInterval, int[] typesArray) {
        super(username, password, drivername, dbURL);
        this.query = query;
        this.batchInterval = batchInterval;
        this.typesArray = typesArray;
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            this.establishConnection();
            this.upload = this.connection.prepareStatement(this.query);
        }
        catch (SQLException sqe) {
            throw new IllegalArgumentException("open() failed.", sqe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC driver class not found.", cnfe);
        }
    }

    public void writeRecord(Row row) throws IOException {
        try {
            JDBCUtils.setRecordToStatement(this.upload, this.typesArray, row);
            this.upload.addBatch();
        }
        catch (SQLException e) {
            throw new RuntimeException("Preparation of JDBC statement failed.", e);
        }
        ++this.batchCount;
        if (this.batchCount >= this.batchInterval) {
            this.flush();
        }
    }

    void flush() {
        try {
            this.upload.executeBatch();
            this.batchCount = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Execution of JDBC statement failed.", e);
        }
    }

    int[] getTypesArray() {
        return this.typesArray;
    }

    public void close() throws IOException {
        if (this.upload != null) {
            this.flush();
            try {
                this.upload.close();
            }
            catch (SQLException e) {
                LOG.info("JDBC statement could not be closed: " + e.getMessage());
            }
            finally {
                this.upload = null;
            }
        }
        this.closeDbConnection();
    }

    public static JDBCOutputFormatBuilder buildJDBCOutputFormat() {
        return new JDBCOutputFormatBuilder();
    }

    public static class JDBCOutputFormatBuilder {
        private String username;
        private String password;
        private String drivername;
        private String dbURL;
        private String query;
        private int batchInterval = 5000;
        private int[] typesArray;

        protected JDBCOutputFormatBuilder() {
        }

        public JDBCOutputFormatBuilder setUsername(String username) {
            this.username = username;
            return this;
        }

        public JDBCOutputFormatBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public JDBCOutputFormatBuilder setDrivername(String drivername) {
            this.drivername = drivername;
            return this;
        }

        public JDBCOutputFormatBuilder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public JDBCOutputFormatBuilder setQuery(String query) {
            this.query = query;
            return this;
        }

        public JDBCOutputFormatBuilder setBatchInterval(int batchInterval) {
            this.batchInterval = batchInterval;
            return this;
        }

        public JDBCOutputFormatBuilder setSqlTypes(int[] typesArray) {
            this.typesArray = typesArray;
            return this;
        }

        public JDBCOutputFormat finish() {
            if (this.username == null) {
                LOG.info("Username was not supplied.");
            }
            if (this.password == null) {
                LOG.info("Password was not supplied.");
            }
            if (this.dbURL == null) {
                throw new IllegalArgumentException("No database URL supplied.");
            }
            if (this.query == null) {
                throw new IllegalArgumentException("No query supplied.");
            }
            if (this.drivername == null) {
                throw new IllegalArgumentException("No driver supplied.");
            }
            return new JDBCOutputFormat(this.username, this.password, this.drivername, this.dbURL, this.query, this.batchInterval, this.typesArray);
        }
    }
}

