/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.jdbc.JDBCInputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCLookupFunction;
import org.apache.flink.api.java.io.jdbc.JDBCLookupOptions;
import org.apache.flink.api.java.io.jdbc.JDBCOptions;
import org.apache.flink.api.java.io.jdbc.JDBCReadOptions;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialect;
import org.apache.flink.api.java.io.jdbc.split.NumericBetweenParametersProvider;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JDBCTableSource
implements StreamTableSource<Row>,
ProjectableTableSource<Row>,
LookupableTableSource<Row> {
    private final JDBCOptions options;
    private final JDBCReadOptions readOptions;
    private final JDBCLookupOptions lookupOptions;
    private final TableSchema schema;
    private final int[] selectFields;
    private final RowTypeInfo returnType;

    private JDBCTableSource(JDBCOptions options, JDBCReadOptions readOptions, JDBCLookupOptions lookupOptions, TableSchema schema) {
        this(options, readOptions, lookupOptions, schema, (int[])null);
    }

    private JDBCTableSource(JDBCOptions options, JDBCReadOptions readOptions, JDBCLookupOptions lookupOptions, TableSchema schema, int[] selectFields) {
        this.options = options;
        this.readOptions = readOptions;
        this.lookupOptions = lookupOptions;
        this.schema = schema;
        this.selectFields = selectFields;
        TypeInformation[] schemaTypeInfos = schema.getFieldTypes();
        String[] schemaFieldNames = schema.getFieldNames();
        if (selectFields != null) {
            TypeInformation[] typeInfos = new TypeInformation[selectFields.length];
            String[] typeNames = new String[selectFields.length];
            for (int i = 0; i < selectFields.length; ++i) {
                typeInfos[i] = schemaTypeInfos[selectFields[i]];
                typeNames[i] = schemaFieldNames[selectFields[i]];
            }
            this.returnType = new RowTypeInfo(typeInfos, typeNames);
        } else {
            this.returnType = new RowTypeInfo(schemaTypeInfos, schemaFieldNames);
        }
    }

    public boolean isBounded() {
        return true;
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
        return execEnv.createInput((InputFormat)this.getInputFormat(), this.getReturnType()).name(this.explainSource());
    }

    public TableFunction<Row> getLookupFunction(String[] lookupKeys) {
        return JDBCLookupFunction.builder().setOptions(this.options).setLookupOptions(this.lookupOptions).setFieldTypes(this.returnType.getFieldTypes()).setFieldNames(this.returnType.getFieldNames()).setKeyNames(lookupKeys).build();
    }

    public TypeInformation<Row> getReturnType() {
        return this.returnType;
    }

    public TableSource<Row> projectFields(int[] fields) {
        return new JDBCTableSource(this.options, this.readOptions, this.lookupOptions, this.schema, fields);
    }

    public AsyncTableFunction<Row> getAsyncLookupFunction(String[] lookupKeys) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncEnabled() {
        return false;
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public static Builder builder() {
        return new Builder();
    }

    private JDBCInputFormat getInputFormat() {
        JDBCInputFormat.JDBCInputFormatBuilder builder = JDBCInputFormat.buildJDBCInputFormat().setDrivername(this.options.getDriverName()).setDBUrl(this.options.getDbURL()).setUsername(this.options.getUsername()).setPassword(this.options.getPassword()).setRowTypeInfo(new RowTypeInfo(this.returnType.getFieldTypes(), this.returnType.getFieldNames()));
        if (this.readOptions.getFetchSize() != 0) {
            builder.setFetchSize(this.readOptions.getFetchSize());
        }
        JDBCDialect dialect = this.options.getDialect();
        String query = dialect.getSelectFromStatement(this.options.getTableName(), this.returnType.getFieldNames(), new String[0]);
        if (this.readOptions.getPartitionColumnName().isPresent()) {
            long lowerBound = this.readOptions.getPartitionLowerBound().get();
            long upperBound = this.readOptions.getPartitionUpperBound().get();
            int numPartitions = this.readOptions.getNumPartitions().get();
            builder.setParametersProvider(new NumericBetweenParametersProvider(lowerBound, upperBound).ofBatchNum(numPartitions));
            query = query + " WHERE " + dialect.quoteIdentifier(this.readOptions.getPartitionColumnName().get()) + " BETWEEN ? AND ?";
        }
        builder.setQuery(query);
        return builder.finish();
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCTableSource) {
            JDBCTableSource source = (JDBCTableSource)o;
            return Objects.equals(this.options, source.options) && Objects.equals(this.readOptions, source.readOptions) && Objects.equals(this.lookupOptions, source.lookupOptions) && Objects.equals(this.schema, source.schema) && Arrays.equals(this.selectFields, source.selectFields);
        }
        return false;
    }

    public static class Builder {
        private JDBCOptions options;
        private JDBCReadOptions readOptions;
        private JDBCLookupOptions lookupOptions;
        private TableSchema schema;

        public Builder setOptions(JDBCOptions options) {
            this.options = options;
            return this;
        }

        public Builder setReadOptions(JDBCReadOptions readOptions) {
            this.readOptions = readOptions;
            return this;
        }

        public Builder setLookupOptions(JDBCLookupOptions lookupOptions) {
            this.lookupOptions = lookupOptions;
            return this;
        }

        public Builder setSchema(TableSchema schema) {
            this.schema = schema;
            return this;
        }

        public JDBCTableSource build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.schema, (String)"No schema supplied.");
            if (this.readOptions == null) {
                this.readOptions = JDBCReadOptions.builder().build();
            }
            if (this.lookupOptions == null) {
                this.lookupOptions = JDBCLookupOptions.builder().build();
            }
            return new JDBCTableSource(this.options, this.readOptions, this.lookupOptions, this.schema);
        }
    }
}

