/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.io.Serializable;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.JoinedStreams;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JoinedStreamsTest {
    private DataStream<String> dataStream1;
    private DataStream<String> dataStream2;
    private KeySelector<String, String> keySelector;
    private TumblingEventTimeWindows tsAssigner;
    private JoinFunction<String, String, String> joinFunction;

    @Before
    public void setUp() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        this.dataStream1 = env.fromElements((Object[])new String[]{"a1", "a2", "a3"});
        this.dataStream2 = env.fromElements((Object[])new String[]{"a1", "a2"});
        this.keySelector = (KeySelector & Serializable)element -> element;
        this.tsAssigner = TumblingEventTimeWindows.of((Time)Time.milliseconds((long)1L));
        this.joinFunction = (JoinFunction & Serializable)(first, second) -> first + second;
    }

    @Test
    public void testDelegateToCoGrouped() {
        Time lateness = Time.milliseconds((long)42L);
        JoinedStreams.WithWindow withLateness = this.dataStream1.join(this.dataStream2).where(this.keySelector).equalTo(this.keySelector).window((WindowAssigner)this.tsAssigner).allowedLateness(lateness);
        withLateness.apply(this.joinFunction, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((long)lateness.toMilliseconds(), (long)withLateness.getCoGroupedWindowedStream().getAllowedLateness().toMilliseconds());
    }

    @Test
    public void testSetAllowedLateness() {
        Time lateness = Time.milliseconds((long)42L);
        JoinedStreams.WithWindow withLateness = this.dataStream1.join(this.dataStream2).where(this.keySelector).equalTo(this.keySelector).window((WindowAssigner)this.tsAssigner).allowedLateness(lateness);
        Assert.assertEquals((long)lateness.toMilliseconds(), (long)withLateness.getAllowedLateness().toMilliseconds());
    }
}

