/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.runtime.io.network.partition.consumer.EndOfChannelStateEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.StreamTestSingleInputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.testutils.DummyCheckpointInvokable;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.SyncMailboxExecutor;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.AbstractStreamTaskNetworkInput;
import org.apache.flink.streaming.runtime.io.MockInputGate;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.streaming.runtime.io.StreamTaskNetworkInput;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointBarrierTracker;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.checkpointing.SingleCheckpointBarrierHandler;
import org.apache.flink.streaming.runtime.io.checkpointing.UpstreamRecoveryTracker;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.tasks.SubtaskCheckpointCoordinator;
import org.apache.flink.streaming.runtime.tasks.TestSubtaskCheckpointCoordinator;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class StreamTaskNetworkInputTest {
    private static final int PAGE_SIZE = 1000;
    private final IOManager ioManager = new IOManagerAsync();

    @After
    public void tearDown() throws Exception {
        this.ioManager.close();
    }

    @Test
    public void testIsAvailableWithBufferedDataInDeserializer() throws Exception {
        List<BufferOrEvent> buffers = Collections.singletonList(this.createDataBuffer());
        VerifyRecordsDataOutput output = new VerifyRecordsDataOutput();
        StreamTaskNetworkInput<Long> input = this.createStreamTaskNetworkInput(buffers);
        StreamTaskNetworkInputTest.assertHasNextElement(input, output);
        StreamTaskNetworkInputTest.assertHasNextElement(input, output);
        Assert.assertEquals((long)2L, (long)output.getNumberOfEmittedRecords());
    }

    @Test
    public void testNoDataProcessedAfterCheckpointBarrier() throws Exception {
        CheckpointBarrier barrier = new CheckpointBarrier(0L, 0L, CheckpointOptions.forCheckpointWithDefaultLocation());
        ArrayList<BufferOrEvent> buffers = new ArrayList<BufferOrEvent>(2);
        buffers.add(new BufferOrEvent((AbstractEvent)barrier, new InputChannelInfo(0, 0)));
        buffers.add(this.createDataBuffer());
        VerifyRecordsDataOutput output = new VerifyRecordsDataOutput();
        StreamTaskNetworkInput<Long> input = this.createStreamTaskNetworkInput(buffers);
        StreamTaskNetworkInputTest.assertHasNextElement(input, output);
        Assert.assertEquals((long)0L, (long)output.getNumberOfEmittedRecords());
    }

    private Map<InputChannelInfo, TestRecordDeserializer> createDeserializers(CheckpointableInput inputGate) {
        return inputGate.getChannelInfos().stream().collect(Collectors.toMap(Function.identity(), unused -> new TestRecordDeserializer(this.ioManager.getSpillingDirectoriesPaths())));
    }

    @Test
    public void testSnapshotAfterEndOfPartition() throws Exception {
        int numInputChannels = 1;
        int channelId = 0;
        int checkpointId = 0;
        VerifyRecordsDataOutput output = new VerifyRecordsDataOutput();
        LongSerializer inSerializer = LongSerializer.INSTANCE;
        StreamTestSingleInputGate inputGate = new StreamTestSingleInputGate(numInputChannels, 0, inSerializer, 1024);
        StreamTaskNetworkInput input = new StreamTaskNetworkInput(new CheckpointedInputGate((InputGate)inputGate.getInputGate(), (CheckpointBarrierHandler)SingleCheckpointBarrierHandler.createUnalignedCheckpointBarrierHandler((SubtaskCheckpointCoordinator)TestSubtaskCheckpointCoordinator.INSTANCE, (String)"test", (AbstractInvokable)new DummyCheckpointInvokable(), (Clock)SystemClock.getInstance(), (CheckpointableInput[])new CheckpointableInput[]{inputGate.getInputGate()}), (MailboxExecutor)new SyncMailboxExecutor()), (TypeSerializer)inSerializer, this.ioManager, new StatusWatermarkValve(numInputChannels), 0);
        inputGate.sendEvent((AbstractEvent)new CheckpointBarrier((long)checkpointId, 0L, CheckpointOptions.forCheckpointWithDefaultLocation().toUnaligned()), channelId);
        inputGate.sendElement(new StreamRecord((Object)42L), channelId);
        StreamTaskNetworkInputTest.assertHasNextElement(input, output);
        StreamTaskNetworkInputTest.assertHasNextElement(input, output);
        Assert.assertEquals((long)1L, (long)output.getNumberOfEmittedRecords());
        inputGate.sendEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE, channelId);
        input.emitNext(output);
        CompletableFuture completableFuture = input.prepareSnapshot(ChannelStateWriter.NO_OP, (long)checkpointId);
        completableFuture.join();
    }

    @Test
    public void testReleasingDeserializerTimely() throws Exception {
        int numInputChannels = 2;
        LongSerializer inSerializer = LongSerializer.INSTANCE;
        StreamTestSingleInputGate<Long> inputGate = new StreamTestSingleInputGate<Long>(numInputChannels, 0, (TypeSerializer<Long>)inSerializer, 1024);
        NoOpDataOutput output = new NoOpDataOutput();
        Map<InputChannelInfo, TestRecordDeserializer> deserializers = this.createDeserializers((CheckpointableInput)inputGate.getInputGate());
        HashMap<InputChannelInfo, TestRecordDeserializer> copiedDeserializers = new HashMap<InputChannelInfo, TestRecordDeserializer>(deserializers);
        TestStreamTaskNetworkInput input = new TestStreamTaskNetworkInput(inputGate, inSerializer, numInputChannels, deserializers);
        for (InputChannelInfo channelInfo : inputGate.getInputGate().getChannelInfos()) {
            Assert.assertNotNull((Object)((Object)deserializers.get(channelInfo)));
            inputGate.sendEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE, channelInfo.getInputChannelIdx());
            input.emitNext(output);
            Assert.assertTrue((boolean)((TestRecordDeserializer)((Object)copiedDeserializers.get(channelInfo))).isCleared());
            Assert.assertNull((Object)((Object)deserializers.get(channelInfo)));
        }
    }

    @Test
    public void testInputStatusAfterEndOfRecovery() throws Exception {
        int numInputChannels = 2;
        LongSerializer inSerializer = LongSerializer.INSTANCE;
        StreamTestSingleInputGate<Long> inputGate = new StreamTestSingleInputGate<Long>(numInputChannels, 0, (TypeSerializer<Long>)inSerializer, 1024);
        NoOpDataOutput output = new NoOpDataOutput();
        Map<InputChannelInfo, TestRecordDeserializer> deserializers = this.createDeserializers((CheckpointableInput)inputGate.getInputGate());
        TestStreamTaskNetworkInput input = new TestStreamTaskNetworkInput(inputGate, inSerializer, numInputChannels, deserializers);
        inputGate.sendElement(new StreamRecord((Object)42L), 0);
        Assert.assertThat((Object)input.emitNext(output), (Matcher)Matchers.equalTo((Object)InputStatus.MORE_AVAILABLE));
        inputGate.sendEvent((AbstractEvent)EndOfChannelStateEvent.INSTANCE, 0);
        Assert.assertThat((Object)input.emitNext(output), (Matcher)Matchers.equalTo((Object)InputStatus.MORE_AVAILABLE));
        inputGate.sendEvent((AbstractEvent)EndOfChannelStateEvent.INSTANCE, 1);
        Assert.assertThat((Object)input.emitNext(output), (Matcher)Matchers.equalTo((Object)InputStatus.END_OF_RECOVERY));
    }

    private BufferOrEvent createDataBuffer() throws IOException {
        try (BufferBuilder bufferBuilder = BufferBuilderTestUtils.createEmptyBufferBuilder((int)1000);){
            BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
            this.serializeRecord(42L, bufferBuilder);
            this.serializeRecord(44L, bufferBuilder);
            BufferOrEvent bufferOrEvent = new BufferOrEvent(bufferConsumer.build(), new InputChannelInfo(0, 0));
            return bufferOrEvent;
        }
    }

    private StreamTaskNetworkInput<Long> createStreamTaskNetworkInput(List<BufferOrEvent> buffers) {
        return new StreamTaskNetworkInput(StreamTaskNetworkInputTest.createCheckpointedInputGate((InputGate)new MockInputGate(1, buffers, false)), (TypeSerializer)LongSerializer.INSTANCE, this.ioManager, new StatusWatermarkValve(1), 0);
    }

    private static CheckpointedInputGate createCheckpointedInputGate(InputGate inputGate) {
        return new CheckpointedInputGate(inputGate, (CheckpointBarrierHandler)new CheckpointBarrierTracker(1, (AbstractInvokable)new DummyCheckpointInvokable(), (Clock)SystemClock.getInstance()), (MailboxExecutor)new SyncMailboxExecutor(), UpstreamRecoveryTracker.forInputGate((InputGate)inputGate));
    }

    private void serializeRecord(long value, BufferBuilder bufferBuilder) throws IOException {
        DataOutputSerializer serializer = new DataOutputSerializer(128);
        SerializationDelegate serializationDelegate = new SerializationDelegate((TypeSerializer)new StreamElementSerializer((TypeSerializer)LongSerializer.INSTANCE));
        serializationDelegate.setInstance((Object)new StreamRecord((Object)value));
        ByteBuffer serializedRecord = RecordWriter.serializeRecord((DataOutputSerializer)serializer, (IOReadableWritable)serializationDelegate);
        bufferBuilder.appendAndCommit(serializedRecord);
        Assert.assertFalse((boolean)bufferBuilder.isFull());
    }

    private static <T> void assertHasNextElement(StreamTaskInput<T> input, PushingAsyncDataInput.DataOutput<T> output) throws Exception {
        Assert.assertTrue((boolean)input.getAvailableFuture().isDone());
        InputStatus status = input.emitNext(output);
        Assert.assertThat((Object)status, (Matcher)Matchers.is((Object)InputStatus.MORE_AVAILABLE));
    }

    private static class TestStreamTaskNetworkInput
    extends AbstractStreamTaskNetworkInput<Long, TestRecordDeserializer> {
        public TestStreamTaskNetworkInput(StreamTestSingleInputGate<Long> inputGate, LongSerializer inSerializer, int numInputChannels, Map<InputChannelInfo, TestRecordDeserializer> deserializers) {
            super(StreamTaskNetworkInputTest.createCheckpointedInputGate((InputGate)inputGate.getInputGate()), (TypeSerializer)inSerializer, new StatusWatermarkValve(numInputChannels), 0, deserializers);
        }

        public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws CheckpointException {
            throw new UnsupportedOperationException();
        }
    }

    private static class VerifyRecordsDataOutput<T>
    extends NoOpDataOutput<T> {
        private int numberOfEmittedRecords;

        private VerifyRecordsDataOutput() {
        }

        @Override
        public void emitRecord(StreamRecord<T> record) {
            ++this.numberOfEmittedRecords;
        }

        int getNumberOfEmittedRecords() {
            return this.numberOfEmittedRecords;
        }
    }

    private static class NoOpDataOutput<T>
    implements PushingAsyncDataInput.DataOutput<T> {
        private NoOpDataOutput() {
        }

        public void emitRecord(StreamRecord<T> record) {
        }

        public void emitWatermark(Watermark watermark) {
        }

        public void emitStreamStatus(StreamStatus streamStatus) {
        }

        public void emitLatencyMarker(LatencyMarker latencyMarker) {
        }
    }

    private static class TestRecordDeserializer
    extends SpillingAdaptiveSpanningRecordDeserializer<DeserializationDelegate<StreamElement>> {
        private boolean cleared = false;

        public TestRecordDeserializer(String[] tmpDirectories) {
            super(tmpDirectories);
        }

        public void clear() {
            this.cleared = true;
        }

        public boolean isCleared() {
            return this.cleared;
        }
    }
}

