/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

public class TryThreadLocal<T>
extends ThreadLocal<T> {
    private final T initialValue;

    public static <T> TryThreadLocal<T> of(T initialValue) {
        return new TryThreadLocal<T>(initialValue);
    }

    private TryThreadLocal(T initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    protected final T initialValue() {
        return this.initialValue;
    }

    public Memo push(T value2) {
        Object previous = this.get();
        this.set(value2);
        return () -> {
            if (previous == this.initialValue) {
                this.remove();
            } else {
                this.set(previous);
            }
        };
    }

    public static interface Memo
    extends AutoCloseable {
        @Override
        public void close();
    }
}

