/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.org.antlr.v4.runtime.atn;

import org.apache.flink.table.shaded.org.antlr.v4.runtime.Lexer;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.LexerAction;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.LexerActionType;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.misc.MurmurHash;

public final class LexerChannelAction
implements LexerAction {
    private final int channel;

    public LexerChannelAction(int channel) {
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    @Override
    public LexerActionType getActionType() {
        return LexerActionType.CHANNEL;
    }

    @Override
    public boolean isPositionDependent() {
        return false;
    }

    @Override
    public void execute(Lexer lexer) {
        lexer.setChannel(this.channel);
    }

    public int hashCode() {
        int hash2 = MurmurHash.initialize();
        hash2 = MurmurHash.update(hash2, this.getActionType().ordinal());
        hash2 = MurmurHash.update(hash2, this.channel);
        return MurmurHash.finish(hash2, 2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LexerChannelAction)) {
            return false;
        }
        return this.channel == ((LexerChannelAction)obj).channel;
    }

    public String toString() {
        return String.format("channel(%d)", this.channel);
    }
}

