/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import org.apache.flink.streaming.api.datastream.AllWindowedStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.WindowedStream;
import org.apache.flink.streaming.api.windowing.assigners.EventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.ProcessingTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.SlidingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.PurgingTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionUtils$;
import org.apache.flink.table.plan.logical.LogicalWindow;
import org.apache.flink.table.plan.logical.SessionGroupWindow;
import org.apache.flink.table.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.types.Row;
import scala.MatchError;

public final class DataStreamGroupWindowAggregateBase$ {
    public static DataStreamGroupWindowAggregateBase$ MODULE$;

    static {
        new DataStreamGroupWindowAggregateBase$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WindowedStream<CRow, Row, ? extends Window> org$apache$flink$table$plan$nodes$datastream$DataStreamGroupWindowAggregateBase$$createKeyedWindowedStream(TableConfig config, LogicalWindow groupWindow, KeyedStream<CRow, Row> stream) {
        boolean bl = false;
        TumblingGroupWindow tumblingGroupWindow = null;
        boolean bl2 = false;
        SlidingGroupWindow slidingGroupWindow = null;
        boolean bl3 = false;
        SessionGroupWindow sessionGroupWindow = null;
        LogicalWindow logicalWindow = groupWindow;
        if (logicalWindow instanceof TumblingGroupWindow) {
            bl = true;
            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            PlannerExpression timeField = tumblingGroupWindow.timeAttribute();
            PlannerExpression size = tumblingGroupWindow.size();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size)));
            }
        }
        if (bl) {
            PlannerExpression timeField = tumblingGroupWindow.timeAttribute();
            PlannerExpression size = tumblingGroupWindow.size();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isRowCountLiteral(size)) {
                return stream.countWindow(PlannerExpressionUtils$.MODULE$.toLong(size)).trigger((Trigger)PurgingTrigger.of((Trigger)StateCleaningCountTrigger$.MODULE$.of(config, PlannerExpressionUtils$.MODULE$.toLong(size))));
            }
        }
        if (bl) {
            PlannerExpression timeField = tumblingGroupWindow.timeAttribute();
            PlannerExpression size = tumblingGroupWindow.size();
            if (PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)TumblingEventTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size)));
            }
        }
        if (bl) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            bl2 = true;
            slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(slide)) {
                return stream.window((WindowAssigner)SlidingProcessingTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size), (Time)PlannerExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isRowCountLiteral(size)) {
                return stream.countWindow(PlannerExpressionUtils$.MODULE$.toLong(size), PlannerExpressionUtils$.MODULE$.toLong(slide)).trigger((Trigger)StateCleaningCountTrigger$.MODULE$.of(config, PlannerExpressionUtils$.MODULE$.toLong(slide)));
            }
        }
        if (bl2) {
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size)) {
                return stream.window((WindowAssigner)SlidingEventTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size), (Time)PlannerExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SessionGroupWindow) {
            bl3 = true;
            sessionGroupWindow = (SessionGroupWindow)logicalWindow;
            PlannerExpression timeField = sessionGroupWindow.timeAttribute();
            PlannerExpression gap = sessionGroupWindow.gap();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField)) {
                return stream.window((WindowAssigner)ProcessingTimeSessionWindows.withGap((Time)PlannerExpressionUtils$.MODULE$.toTime(gap)));
            }
        }
        if (!bl3) throw new MatchError((Object)logicalWindow);
        PlannerExpression timeField = sessionGroupWindow.timeAttribute();
        PlannerExpression gap = sessionGroupWindow.gap();
        if (!PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) throw new MatchError((Object)logicalWindow);
        return stream.window((WindowAssigner)EventTimeSessionWindows.withGap((Time)PlannerExpressionUtils$.MODULE$.toTime(gap)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AllWindowedStream<CRow, ? extends Window> org$apache$flink$table$plan$nodes$datastream$DataStreamGroupWindowAggregateBase$$createNonKeyedWindowedStream(TableConfig config, LogicalWindow groupWindow, DataStream<CRow> stream) {
        PlannerExpression size;
        boolean bl = false;
        TumblingGroupWindow tumblingGroupWindow = null;
        boolean bl2 = false;
        SlidingGroupWindow slidingGroupWindow = null;
        boolean bl3 = false;
        SessionGroupWindow sessionGroupWindow = null;
        LogicalWindow logicalWindow = groupWindow;
        if (logicalWindow instanceof TumblingGroupWindow) {
            bl = true;
            tumblingGroupWindow = (TumblingGroupWindow)logicalWindow;
            PlannerExpression timeField = tumblingGroupWindow.timeAttribute();
            PlannerExpression size2 = tumblingGroupWindow.size();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size2)) {
                return stream.windowAll((WindowAssigner)TumblingProcessingTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size2)));
            }
        }
        if (bl) {
            PlannerExpression timeField = tumblingGroupWindow.timeAttribute();
            PlannerExpression size3 = tumblingGroupWindow.size();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isRowCountLiteral(size3)) {
                return stream.countWindowAll(PlannerExpressionUtils$.MODULE$.toLong(size3)).trigger((Trigger)PurgingTrigger.of((Trigger)StateCleaningCountTrigger$.MODULE$.of(config, PlannerExpressionUtils$.MODULE$.toLong(size3))));
            }
        }
        if (bl && TypeCheckUtils$.MODULE$.isTimeInterval((size = tumblingGroupWindow.size()).resultType())) {
            return stream.windowAll((WindowAssigner)TumblingEventTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size)));
        }
        if (bl) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SlidingGroupWindow) {
            bl2 = true;
            slidingGroupWindow = (SlidingGroupWindow)logicalWindow;
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size4 = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size4)) {
                return stream.windowAll((WindowAssigner)SlidingProcessingTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size4), (Time)PlannerExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size5 = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isRowCountLiteral(size5)) {
                return stream.countWindowAll(PlannerExpressionUtils$.MODULE$.toLong(size5), PlannerExpressionUtils$.MODULE$.toLong(slide)).trigger((Trigger)StateCleaningCountTrigger$.MODULE$.of(config, PlannerExpressionUtils$.MODULE$.toLong(slide)));
            }
        }
        if (bl2) {
            PlannerExpression timeField = slidingGroupWindow.timeAttribute();
            PlannerExpression size6 = slidingGroupWindow.size();
            PlannerExpression slide = slidingGroupWindow.slide();
            if (PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(size6)) {
                return stream.windowAll((WindowAssigner)SlidingEventTimeWindows.of((Time)PlannerExpressionUtils$.MODULE$.toTime(size6), (Time)PlannerExpressionUtils$.MODULE$.toTime(slide)));
            }
        }
        if (bl2) {
            throw new UnsupportedOperationException("Event-time grouping windows on row intervals are currently not supported.");
        }
        if (logicalWindow instanceof SessionGroupWindow) {
            bl3 = true;
            sessionGroupWindow = (SessionGroupWindow)logicalWindow;
            PlannerExpression timeField = sessionGroupWindow.timeAttribute();
            PlannerExpression gap = sessionGroupWindow.gap();
            if (PlannerExpressionUtils$.MODULE$.isProctimeAttribute(timeField) && PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(gap)) {
                return stream.windowAll((WindowAssigner)ProcessingTimeSessionWindows.withGap((Time)PlannerExpressionUtils$.MODULE$.toTime(gap)));
            }
        }
        if (!bl3) throw new MatchError((Object)logicalWindow);
        PlannerExpression timeField = sessionGroupWindow.timeAttribute();
        PlannerExpression gap = sessionGroupWindow.gap();
        if (!PlannerExpressionUtils$.MODULE$.isRowtimeAttribute(timeField)) throw new MatchError((Object)logicalWindow);
        if (!PlannerExpressionUtils$.MODULE$.isTimeIntervalLiteral(gap)) throw new MatchError((Object)logicalWindow);
        return stream.windowAll((WindowAssigner)EventTimeSessionWindows.withGap((Time)PlannerExpressionUtils$.MODULE$.toTime(gap)));
    }

    private DataStreamGroupWindowAggregateBase$() {
        MODULE$ = this;
    }
}

