/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.DataSetTimeWindowPropertyCollector;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001=\u0011!\u0006R1uCN+GoU3tg&|gnV5oI><\u0018iZ4SK\u0012,8-Z$s_V\u0004h)\u001e8di&|gN\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0002E\u000b\t\u0005#aQ\"$D\u0001\u0013\u0015\t\u0019B#A\u0005gk:\u001cG/[8og*\u0011QCF\u0001\u0007G>lWn\u001c8\u000b\u0005]A\u0011aA1qS&\u0011\u0011D\u0005\u0002\u0018%&\u001c\u0007n\u0012:pkB\u0014V\rZ;dK\u001a+hn\u0019;j_:\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0005\u0002\u000bQL\b/Z:\n\u0005}a\"a\u0001*poB\u0019\u0011\u0005\n\u0014\u000e\u0003\tR!a\t\u0004\u0002\u000f\r|G-Z4f]&\u0011QE\t\u0002\t\u0007>l\u0007/\u001b7feB\u0011q\u0005K\u0007\u0002\u0005%\u0011\u0011F\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\tYc&D\u0001-\u0015\tic!\u0001\u0003vi&d\u0017BA\u0018-\u0005\u001daunZ4j]\u001eD\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u0011\u0011eM\u0005\u0003i\t\u0012QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u000512.Z=t\u0003:$\u0017iZ4sK\u001e\fG/Z:Be&$\u0018\u0010\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0002J]RD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0017M&t\u0017\r\u001c*po^Kg\u000eZ8x'R\f'\u000f\u001e)pgB\u0019\u0001\bQ\u001c\n\u0005\u0005K$AB(qi&|g\u000e\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003@\u0003Q1\u0017N\\1m%><x+\u001b8e_^,e\u000e\u001a)pg\"AQ\t\u0001B\u0001B\u0003%q(\u0001\rgS:\fGNU8x/&tGm\\<S_^$\u0018.\\3Q_ND\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u0004O\u0006\u0004\bC\u0001\u001dJ\u0013\tQ\u0015H\u0001\u0003M_:<\u0007\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\u0002\u001f%\u001c\u0018J\u001c9vi\u000e{WNY5oK\u0012\u0004\"\u0001\u000f(\n\u0005=K$a\u0002\"p_2,\u0017M\u001c\u0005\u0006#\u0002!\tAU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011M#VKV,Y3j\u0003\"a\n\u0001\t\u000bE\u0002\u0006\u0019\u0001\u001a\t\u000bY\u0002\u0006\u0019A\u001c\t\u000by\u0002\u0006\u0019A \t\u000b\r\u0003\u0006\u0019A \t\u000b\u0015\u0003\u0006\u0019A \t\u000b\u001d\u0003\u0006\u0019\u0001%\t\u000b1\u0003\u0006\u0019A'\t\u0013q\u0003\u0001\u0019!a\u0001\n\u0013i\u0016!C2pY2,7\r^8s+\u0005q\u0006CA\u0014`\u0013\t\u0001'A\u0001\u0012ECR\f7+\u001a;US6,w+\u001b8e_^\u0004&o\u001c9feRL8i\u001c7mK\u000e$xN\u001d\u0005\nE\u0002\u0001\r\u00111A\u0005\n\r\fQbY8mY\u0016\u001cGo\u001c:`I\u0015\fHC\u00013h!\tAT-\u0003\u0002gs\t!QK\\5u\u0011\u001dA\u0017-!AA\u0002y\u000b1\u0001\u001f\u00132\u0011%Q\u0007\u00011A\u0001B\u0003&a,\u0001\u0006d_2dWm\u0019;pe\u0002Bq\u0001\u001c\u0001C\u0002\u0013%Q.A\u000fj]R,'/\\3eS\u0006$XMU8x/&tGm\\<Ti\u0006\u0014H\u000fU8t+\u00059\u0004BB8\u0001A\u0003%q'\u0001\u0010j]R,'/\\3eS\u0006$XMU8x/&tGm\\<Ti\u0006\u0014H\u000fU8tA!9\u0011\u000f\u0001b\u0001\n\u0013i\u0017aG5oi\u0016\u0014X.\u001a3jCR,'k\\<XS:$wn^#oIB{7\u000f\u0003\u0004t\u0001\u0001\u0006IaN\u0001\u001dS:$XM]7fI&\fG/\u001a*po^Kg\u000eZ8x\u000b:$\u0007k\\:!\u0011%)\b\u00011AA\u0002\u0013%a/\u0001\u0004pkR\u0004X\u000f^\u000b\u00025!I\u0001\u0010\u0001a\u0001\u0002\u0004%I!_\u0001\u000b_V$\b/\u001e;`I\u0015\fHC\u00013{\u0011\u001dAw/!AA\u0002iA\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u000f=,H\u000f];uA!Ia\u0010\u0001a\u0001\u0002\u0004%IA^\u0001\rC\u000e\u001cW/\\;mCR|'o\u001d\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019!\u0001\tbG\u000e,X.\u001e7bi>\u00148o\u0018\u0013fcR\u0019A-!\u0002\t\u000f!|\u0018\u0011!a\u00015!Q\u0011\u0011\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u001b\u0005\u001c7-^7vY\u0006$xN]:!\u0011-\ti\u0001\u0001a\u0001\u0002\u0004%I!a\u0004\u0002\u0011\u0019,hn\u0019;j_:,\u0012A\n\u0005\f\u0003'\u0001\u0001\u0019!a\u0001\n\u0013\t)\"\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002e\u0003/A\u0001\u0002[A\t\u0003\u0003\u0005\rA\n\u0005\u000b\u00037\u0001\u0001\u0019!A!B\u00131\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\ty\u0002\u0001C!\u0003C\tAa\u001c9f]R\u0019A-a\t\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\taaY8oM&<\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u0002\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003c\tYCA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003k\u0001A\u0011IA\u001c\u0003\u0019\u0011X\rZ;dKR)A-!\u000f\u0002N!A\u00111HA\u001a\u0001\u0004\ti$A\u0004sK\u000e|'\u000fZ:\u0011\u000b\u0005}\u0012\u0011\n\u000e\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA\u0001\\1oO*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005\u0005#\u0001C%uKJ\f'\r\\3\t\u0011\u0005=\u00131\u0007a\u0001\u0003#\n1a\\;u!\u0015\t\u0019&a\u0016\u001b\u001b\t\t)F\u0003\u0002.\u0011%!\u0011\u0011LA+\u0005%\u0019u\u000e\u001c7fGR|'\u000fC\u0004\u0002^\u0001!\t!a\u0018\u0002)\u0011|WI^1mk\u0006$X-\u00118e\u0007>dG.Z2u)\u001d!\u0017\u0011MA2\u0003OB\u0001\"a\u0014\u0002\\\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003K\nY\u00061\u0001I\u0003-9\u0018N\u001c3poN#\u0018M\u001d;\t\u000f\u0005%\u00141\fa\u0001\u0011\u0006Iq/\u001b8e_^,e\u000e\u001a")
public class DataSetSessionWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final Option<Object> finalRowWindowStartPos;
    private final Option<Object> finalRowWindowEndPos;
    private final Option<Object> finalRowWindowRowtimePos;
    private final long gap;
    private final boolean isInputCombined;
    private DataSetTimeWindowPropertyCollector collector;
    private final int intermediateRowWindowStartPos;
    private final int intermediateRowWindowEndPos;
    private Row output;
    private Row accumulators;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        DataSetSessionWindowAggReduceGroupFunction dataSetSessionWindowAggReduceGroupFunction = this;
        synchronized (dataSetSessionWindowAggReduceGroupFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private DataSetTimeWindowPropertyCollector collector() {
        return this.collector;
    }

    private void collector_$eq(DataSetTimeWindowPropertyCollector x$1) {
        this.collector = x$1;
    }

    private int intermediateRowWindowStartPos() {
        return this.intermediateRowWindowStartPos;
    }

    private int intermediateRowWindowEndPos() {
        return this.intermediateRowWindowEndPos;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
        this.collector_$eq(new DataSetTimeWindowPropertyCollector(this.finalRowWindowStartPos, this.finalRowWindowEndPos, this.finalRowWindowRowtimePos));
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        Long windowStart = null;
        Long windowEnd = null;
        Long currentRowTime = null;
        this.function().resetAccumulator(this.accumulators());
        for (Row record : records) {
            currentRowTime = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowStartPos())));
            if (windowEnd == null || windowEnd != null && Predef$.MODULE$.Long2long(currentRowTime) > Predef$.MODULE$.Long2long(windowEnd)) {
                if (windowEnd != null) {
                    this.doEvaluateAndCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
                    this.function().resetAccumulator(this.accumulators());
                } else {
                    this.function().setForwardedFields(record, this.output());
                }
                windowStart = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowStartPos())));
            }
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            windowEnd = this.isInputCombined ? Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.intermediateRowWindowEndPos()))) : Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentRowTime) + this.gap);
        }
        this.doEvaluateAndCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
    }

    public void doEvaluateAndCollect(Collector<Row> out, long windowStart, long windowEnd) {
        this.function().setAggregationResults(this.accumulators(), this.output());
        if (this.finalRowWindowStartPos.isDefined() || this.finalRowWindowEndPos.isDefined()) {
            this.collector().wrappedCollector_$eq(out);
            this.collector().windowStart_$eq(windowStart);
            this.collector().windowEnd_$eq(windowEnd);
            this.collector().collect(this.output());
        } else {
            out.collect((Object)this.output());
        }
    }

    public DataSetSessionWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, Option<Object> finalRowWindowStartPos, Option<Object> finalRowWindowEndPos, Option<Object> finalRowWindowRowtimePos, long gap, boolean isInputCombined) {
        this.genAggregations = genAggregations;
        this.finalRowWindowStartPos = finalRowWindowStartPos;
        this.finalRowWindowEndPos = finalRowWindowEndPos;
        this.finalRowWindowRowtimePos = finalRowWindowRowtimePos;
        this.gap = gap;
        this.isInputCombined = isInputCombined;
        Compiler.$init$(this);
        Logging.$init$(this);
        this.intermediateRowWindowStartPos = keysAndAggregatesArity;
        this.intermediateRowWindowEndPos = keysAndAggregatesArity + 1;
    }
}

