/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.test.util.CollectionTestEnvironment;
import org.apache.flink.test.util.TestEnvironment;
import org.junit.Assert;
import org.junit.Test;

public abstract class JavaProgramTestBase
extends AbstractTestBase {
    private JobExecutionResult latestExecutionResult;
    private int numberOfTestRepetitions = 1;
    private boolean isCollectionExecution;

    public void setNumberOfTestRepetitions(int numberOfTestRepetitions) {
        this.numberOfTestRepetitions = numberOfTestRepetitions;
    }

    public int getParallelism() {
        return this.isCollectionExecution ? 1 : miniClusterResource.getNumberSlots();
    }

    public JobExecutionResult getLatestExecutionResult() {
        return this.latestExecutionResult;
    }

    public boolean isCollectionExecution() {
        return this.isCollectionExecution;
    }

    protected abstract void testProgram() throws Exception;

    protected void preSubmit() throws Exception {
    }

    protected void postSubmit() throws Exception {
    }

    protected boolean skipCollectionExecution() {
        return false;
    }

    @Test
    public void testJobWithObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        try {
            this.preSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
        }
        TestEnvironment env = miniClusterResource.getTestEnvironment();
        env.getConfig().enableObjectReuse();
        for (int i = 0; i < this.numberOfTestRepetitions; ++i) {
            try {
                this.testProgram();
                this.latestExecutionResult = env.getLastJobExecutionResult();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
            }
            Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
        }
        try {
            this.postSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void testJobWithoutObjectReuse() throws Exception {
        this.isCollectionExecution = false;
        try {
            this.preSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
        }
        TestEnvironment env = miniClusterResource.getTestEnvironment();
        env.getConfig().disableObjectReuse();
        for (int i = 0; i < this.numberOfTestRepetitions; ++i) {
            try {
                this.testProgram();
                this.latestExecutionResult = env.getLastJobExecutionResult();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
            }
            Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
        }
        try {
            this.postSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
        }
    }

    @Test
    public void testJobCollectionExecution() throws Exception {
        if (this.skipCollectionExecution()) {
            return;
        }
        this.isCollectionExecution = true;
        try {
            this.preSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Pre-submit work caused an error: " + e.getMessage()));
        }
        CollectionTestEnvironment env = new CollectionTestEnvironment();
        env.setAsContext();
        try {
            this.testProgram();
            this.latestExecutionResult = env.getLastJobExecutionResult();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Error while calling the test program: " + e.getMessage()));
        }
        finally {
            miniClusterResource.getTestEnvironment().setAsContext();
        }
        Assert.assertNotNull((String)"The test program never triggered an execution.", (Object)this.latestExecutionResult);
        try {
            this.postSubmit();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Post-submit work caused an error: " + e.getMessage()));
        }
    }
}

