/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.cq;

import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.client.internal.QueueManager;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;

public class CqEventImpl
implements CqEvent {
    private final CqQuery cQuery;
    private final Operation baseOp;
    private final Operation queryOp;
    private final Object newValue;
    private final Object key;
    private final byte[] delta;
    private Throwable throwable = null;
    private final QueueManager qManager;
    private final EventID eventId;

    CqEventImpl(CqQuery cQuery, Operation baseOp, Operation cqOp, Object key, Object value, byte[] deltaVal, QueueManager qManager, EventID eventId) {
        this.cQuery = cQuery;
        this.queryOp = cqOp;
        this.baseOp = baseOp;
        this.key = key;
        this.newValue = value;
        this.delta = deltaVal;
        if (this.queryOp == null) {
            this.setException();
        }
        this.qManager = qManager;
        this.eventId = eventId;
    }

    public CqQuery getCq() {
        return this.cQuery;
    }

    public Operation getBaseOperation() {
        return this.baseOp;
    }

    public Operation getQueryOperation() {
        return this.queryOp;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getNewValue() {
        if (this.newValue == null && this.delta != null) {
            throw new InvalidDeltaException();
        }
        return this.newValue;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public byte[] getDeltaValue() {
        return this.delta;
    }

    public void setException() {
        this.throwable = new Throwable(LocalizedStrings.CqEventImpl_EXCEPTION_OCCURED_WHILE_APPLYING_QUERY_ON_A_CACHE_EVENT.toLocalizedString());
    }

    public void setException(String exceptionText) {
        this.throwable = new Throwable(exceptionText);
    }

    public QueueManager getQueueManager() {
        return this.qManager;
    }

    public EventID getEventID() {
        return this.eventId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CqEvent [").append("CqName=").append(this.cQuery.getName()).append("; base operation=").append(this.baseOp).append("; cq operation=").append(this.queryOp).append("; key=").append(this.key).append("; value=").append(this.newValue).append("]");
        return buffer.toString();
    }
}

