/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.internal.cq.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.cq.CqService;
import com.gemstone.gemfire.cache.query.internal.cq.InternalCqQuery;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.command.BaseCQCommand;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.GeodeSecurityUtil;
import java.io.IOException;
import java.util.HashSet;

public class StopCQ
extends BaseCQCommand {
    private static final StopCQ singleton = new StopCQ();

    public static Command getCommand() {
        return singleton;
    }

    private StopCQ() {
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        start = DistributionStats.getStatTime();
        String cqName = msg.getPart(0).getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received stop CQ request from {} cqName: {}", (Object)servConn.getName(), (Object)servConn.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = LocalizedStrings.StopCQ_THE_CQNAME_FOR_THE_CQ_STOP_REQUEST_IS_NULL.toLocalizedString();
            StopCQ.sendCqResponse((int)47, (String)err, (int)msg.getTransactionId(), null, (ServerConnection)servConn);
            return;
        }
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
            String serverCqName = cqName;
            if (id != null) {
                serverCqName = cqService.constructServerCqName(cqName, id);
            }
            InternalCqQuery cqQuery = cqService.getCq(serverCqName);
            GeodeSecurityUtil.authorizeDataManage();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                String queryStr = null;
                HashSet<String> cqRegionNames = null;
                if (cqQuery != null) {
                    queryStr = cqQuery.getQueryString();
                    cqRegionNames = new HashSet<String>();
                    cqRegionNames.add(((CqQueryImpl)cqQuery).getRegionName());
                }
                authzRequest.stopCQAuthorize(cqName, queryStr, cqRegionNames);
            }
            cqService.stopCq(cqName, id);
            if (cqQuery != null) {
                servConn.removeCq(cqName, cqQuery.isDurable());
            }
        }
        catch (CqException cqe) {
            StopCQ.sendCqResponse((int)50, (String)"", (int)msg.getTransactionId(), (Throwable)cqe, (ServerConnection)servConn);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.StopCQ_EXCEPTION_WHILE_STOPPING_CQ_NAMED_0.toLocalizedString(new Object[]{cqName});
            StopCQ.sendCqResponse((int)50, (String)err, (int)msg.getTransactionId(), (Throwable)e, (ServerConnection)servConn);
            return;
        }
        StopCQ.sendCqResponse((int)6, (String)LocalizedStrings.StopCQ_CQ_STOPPED_SUCCESSFULLY.toLocalizedString(), (int)msg.getTransactionId(), null, (ServerConnection)servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessStopCqTime(start - oldStart);
    }
}

