/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestUnsetAndChangeDirectoryEcPolicy {
    public static final Log LOG = LogFactory.getLog(TestUnsetAndChangeDirectoryEcPolicy.class);
    private MiniDFSCluster cluster;
    private Configuration conf = new Configuration();
    private DistributedFileSystem fs;
    private ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripsPerBlock = 2;
    private final int blockSize = 2 * this.cellSize;
    private final int blockGroupSize = this.dataBlocks * this.blockSize;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws IOException {
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setInt("dfs.namenode.replication.max-streams", 0);
        if (ErasureCodeNative.isNativeCodeLoaded()) {
            this.conf.set("io.erasurecode.codec.rs.rawcoders", "rs_native");
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.dataBlocks + this.parityBlocks).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        DFSTestUtil.enableAllECPolicies(this.fs);
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testUnsetEcPolicy() throws Exception {
        boolean numBlocks = true;
        int fileLen = this.blockGroupSize * 1;
        Path dirPath = new Path("/striped");
        Path ecFilePath = new Path(dirPath, "ec_file");
        Path replicateFilePath = new Path(dirPath, "3x_file");
        this.fs.mkdirs(dirPath);
        this.fs.unsetErasureCodingPolicy(dirPath);
        this.fs.setErasureCodingPolicy(dirPath, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFilePath, fileLen, (short)1, 0L);
        this.fs.unsetErasureCodingPolicy(dirPath);
        DFSTestUtil.createFile((FileSystem)this.fs, replicateFilePath, fileLen, (short)1, 0L);
        ErasureCodingPolicy tempEcPolicy = this.fs.getErasureCodingPolicy(ecFilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(replicateFilePath);
        Assert.assertNull((String)"Replicate file should not have erasure coding policy!", (Object)tempEcPolicy);
        tempEcPolicy = this.fs.getErasureCodingPolicy(dirPath);
        Assert.assertNull((String)"Directory should no have erasure coding policy set!", (Object)tempEcPolicy);
        this.fs.delete(dirPath, true);
    }

    @Test
    public void testNestedEcPolicy() throws Exception {
        boolean numBlocks = true;
        int fileLen = this.blockGroupSize * 1;
        Path parentDir = new Path("/ec-6-3");
        Path childDir = new Path("/ec-6-3/ec-3-2");
        Path ec63FilePath = new Path(childDir, "ec_6_3_file");
        Path ec32FilePath = new Path(childDir, "ec_3_2_file");
        Path ec63FilePath2 = new Path(childDir, "ec_6_3_file_2");
        ErasureCodingPolicy ec32Policy = SystemErasureCodingPolicies.getByID((byte)2);
        this.fs.mkdirs(parentDir);
        this.fs.setErasureCodingPolicy(parentDir, this.ecPolicy.getName());
        this.fs.mkdirs(childDir);
        DFSTestUtil.createFile((FileSystem)this.fs, ec63FilePath, fileLen, (short)1, 0L);
        this.fs.setErasureCodingPolicy(childDir, ec32Policy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ec32FilePath, fileLen, (short)1, 0L);
        ErasureCodingPolicy tempEcPolicy = this.fs.getErasureCodingPolicy(ec63FilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(ec32FilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(ec32Policy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(childDir);
        Assert.assertTrue((String)"Directory should have erasure coding policy set!", (boolean)tempEcPolicy.getName().equals(ec32Policy.getName()));
        this.fs.unsetErasureCodingPolicy(childDir);
        DFSTestUtil.createFile((FileSystem)this.fs, ec63FilePath2, fileLen, (short)1, 0L);
        tempEcPolicy = this.fs.getErasureCodingPolicy(ec63FilePath2);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(childDir);
        Assert.assertTrue((String)"Directory should have erasure coding policy set!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        this.fs.delete(parentDir, true);
    }

    @Test
    public void testUnsetRootDirEcPolicy() throws Exception {
        boolean numBlocks = true;
        int fileLen = this.blockGroupSize * 1;
        Path rootPath = new Path("/");
        Path ecFilePath = new Path(rootPath, "ec_file");
        Path replicateFilePath = new Path(rootPath, "rep_file");
        this.fs.unsetErasureCodingPolicy(rootPath);
        this.fs.setErasureCodingPolicy(rootPath, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFilePath, fileLen, (short)1, 0L);
        this.fs.unsetErasureCodingPolicy(rootPath);
        DFSTestUtil.createFile((FileSystem)this.fs, replicateFilePath, fileLen, (short)1, 0L);
        ErasureCodingPolicy tempEcPolicy = this.fs.getErasureCodingPolicy(ecFilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(replicateFilePath);
        Assert.assertNull((String)"Replicate file should not have erasure coding policy!", (Object)tempEcPolicy);
        tempEcPolicy = this.fs.getErasureCodingPolicy(rootPath);
        Assert.assertNull((String)"Directory should not have erasure coding policy set!", (Object)tempEcPolicy);
        this.fs.delete(rootPath, true);
    }

    @Test
    public void testChangeRootDirEcPolicy() throws Exception {
        boolean numBlocks = true;
        int fileLen = this.blockGroupSize * 1;
        Path rootPath = new Path("/");
        Path ec63FilePath = new Path(rootPath, "ec_6_3_file");
        Path ec32FilePath = new Path(rootPath, "ec_3_2_file");
        ErasureCodingPolicy ec32Policy = SystemErasureCodingPolicies.getByID((byte)2);
        this.fs.unsetErasureCodingPolicy(rootPath);
        this.fs.setErasureCodingPolicy(rootPath, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ec63FilePath, fileLen, (short)1, 0L);
        this.fs.setErasureCodingPolicy(rootPath, ec32Policy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ec32FilePath, fileLen, (short)1, 0L);
        ErasureCodingPolicy tempEcPolicy = this.fs.getErasureCodingPolicy(ec63FilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(ec32FilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(ec32Policy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(rootPath);
        Assert.assertTrue((String)"Directory should have erasure coding policy!", (boolean)tempEcPolicy.getName().equals(ec32Policy.getName()));
        this.fs.delete(rootPath, true);
    }

    @Test
    public void testDifferentReplicaFactor() throws Exception {
        boolean numBlocks = true;
        int fileLen = this.blockGroupSize * 1;
        Path ecDirPath = new Path("/striped");
        Path ecFilePath = new Path(ecDirPath, "ec_file");
        Path replicateFilePath = new Path(ecDirPath, "rep_file");
        Path replicateFilePath2 = new Path(ecDirPath, "rep_file2");
        this.fs.mkdirs(ecDirPath);
        this.fs.setErasureCodingPolicy(ecDirPath, this.ecPolicy.getName());
        DFSTestUtil.createFile((FileSystem)this.fs, ecFilePath, fileLen, (short)1, 0L);
        this.fs.unsetErasureCodingPolicy(ecDirPath);
        DFSTestUtil.createFile((FileSystem)this.fs, replicateFilePath, fileLen, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.fs, replicateFilePath2, fileLen, (short)2, 0L);
        ErasureCodingPolicy tempEcPolicy = this.fs.getErasureCodingPolicy(ecFilePath);
        Assert.assertTrue((String)"Erasure coding policy mismatch!", (boolean)tempEcPolicy.getName().equals(this.ecPolicy.getName()));
        tempEcPolicy = this.fs.getErasureCodingPolicy(replicateFilePath);
        Assert.assertNull((String)"Replicate file should not have erasure coding policy!", (Object)tempEcPolicy);
        tempEcPolicy = this.fs.getErasureCodingPolicy(replicateFilePath2);
        Assert.assertNull((String)"Replicate file should not have erasure coding policy!", (Object)tempEcPolicy);
        tempEcPolicy = this.fs.getErasureCodingPolicy(ecDirPath);
        Assert.assertNull((String)"Directory should not have erasure coding policy set!", (Object)tempEcPolicy);
        this.fs.delete(ecDirPath, true);
    }

    @Test
    public void testNonExistentDir() throws Exception {
        Path dirPath = new Path("/striped");
        try {
            this.fs.unsetErasureCodingPolicy(dirPath);
            Assert.fail((String)"FileNotFoundException should be thrown for a non-existent file path");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)("Path not found: " + dirPath), (Throwable)e);
        }
        try {
            this.fs.setErasureCodingPolicy(dirPath, this.ecPolicy.getName());
            Assert.fail((String)"FileNotFoundException should be thrown for a non-existent file path");
        }
        catch (FileNotFoundException e) {
            GenericTestUtils.assertExceptionContains((String)("Path not found: " + dirPath), (Throwable)e);
        }
    }

    @Test
    public void testEcPolicyOnFile() throws Exception {
        Path ecFilePath = new Path("/striped_file");
        int fileLen = this.blockGroupSize * 2;
        DFSTestUtil.createFile((FileSystem)this.fs, ecFilePath, fileLen, (short)1, 0L);
        try {
            this.fs.setErasureCodingPolicy(ecFilePath, this.ecPolicy.getName());
            Assert.fail((String)"IOException should be thrown for setting EC policy on file");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Attempt to set an erasure coding policy for a file " + ecFilePath), (Throwable)e);
        }
        try {
            this.fs.unsetErasureCodingPolicy(ecFilePath);
            Assert.fail((String)"IOException should be thrown for unsetting EC policy on file");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)("Cannot unset an erasure coding policy on a file " + ecFilePath), (Throwable)e);
        }
    }

    @Test
    public void testUnsetEcPolicyInEditLog() throws IOException {
        this.fs.getClient().setErasureCodingPolicy("/", this.ecPolicy.getName());
        Assert.assertEquals((Object)this.ecPolicy, (Object)this.fs.getErasureCodingPolicy(new Path("/")));
        this.fs.getClient().unsetErasureCodingPolicy("/");
        this.cluster.restartNameNode(true);
        Assert.assertNull((Object)this.fs.getErasureCodingPolicy(new Path("/")));
    }
}

