/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowDiskTracker;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSlowDiskTracker {
    public static final Logger LOG = LoggerFactory.getLogger(TestSlowDiskTracker.class);
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private static Configuration conf;
    private SlowDiskTracker tracker;
    private FakeTimer timer;
    private long reportValidityMs;
    private static final long OUTLIERS_REPORT_INTERVAL = 1000L;
    private static final ObjectReader READER;

    @Before
    public void setup() {
        this.timer = new FakeTimer();
        this.tracker = new SlowDiskTracker(conf, (Timer)this.timer);
        this.reportValidityMs = this.tracker.getReportValidityMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeHeartbeatSlowDiskReport() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        try {
            DataNode dn1 = cluster.getDataNodes().get(0);
            DataNode dn2 = cluster.getDataNodes().get(1);
            NameNode nn = cluster.getNameNode(0);
            DatanodeManager datanodeManager = nn.getNamesystem().getBlockManager().getDatanodeManager();
            final SlowDiskTracker slowDiskTracker = datanodeManager.getSlowDiskTracker();
            slowDiskTracker.setReportValidityMs(100000L);
            dn1.getDiskMetrics().addSlowDiskForTesting("disk1", (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.3));
            dn1.getDiskMetrics().addSlowDiskForTesting("disk2", (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.6, (Object)SlowDiskReports.DiskOp.WRITE, (Object)1.1));
            dn2.getDiskMetrics().addSlowDiskForTesting("disk1", (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)0.8));
            dn2.getDiskMetrics().addSlowDiskForTesting("disk2", (Map)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.3));
            String dn1ID = dn1.getDatanodeId().getIpcAddr(false);
            String dn2ID = dn2.getDatanodeId().getIpcAddr(false);
            Thread.sleep(1000L);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return slowDiskTracker.getSlowDisksReport().size() == 4;
                }
            }, (long)1000L, (long)100000L);
            Map<String, SlowDiskTracker.DiskLatency> slowDisksReport = this.getSlowDisksReportForTesting(slowDiskTracker);
            Assert.assertThat((Object)slowDisksReport.size(), (Matcher)Is.is((Object)4));
            Assert.assertTrue((Math.abs(slowDisksReport.get(dn1ID + ":disk1").getLatency(SlowDiskReports.DiskOp.WRITE) - 1.3) < 1.0E-7 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(slowDisksReport.get(dn1ID + ":disk2").getLatency(SlowDiskReports.DiskOp.READ) - 1.6) < 1.0E-7 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(slowDisksReport.get(dn1ID + ":disk2").getLatency(SlowDiskReports.DiskOp.WRITE) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(slowDisksReport.get(dn2ID + ":disk1").getLatency(SlowDiskReports.DiskOp.METADATA) - 0.8) < 1.0E-7 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(slowDisksReport.get(dn2ID + ":disk2").getLatency(SlowDiskReports.DiskOp.WRITE) - 1.3) < 1.0E-7 ? 1 : 0) != 0);
            ArrayList<SlowDiskTracker.DiskLatency> jsonReport = this.getAndDeserializeJson(slowDiskTracker.getSlowDiskReportAsJsonString());
            Assert.assertThat((Object)jsonReport.size(), (Matcher)Is.is((Object)4));
            Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, dn1ID, "disk1", SlowDiskReports.DiskOp.WRITE, 1.3));
            Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, dn1ID, "disk2", SlowDiskReports.DiskOp.READ, 1.6));
            Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, dn1ID, "disk2", SlowDiskReports.DiskOp.WRITE, 1.1));
            Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, dn2ID, "disk1", SlowDiskReports.DiskOp.METADATA, 0.8));
            Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, dn2ID, "disk2", SlowDiskReports.DiskOp.WRITE, 1.3));
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testEmptyReports() {
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        Assert.assertTrue((boolean)this.getSlowDisksReportForTesting(this.tracker).isEmpty());
    }

    @Test
    public void testReportsAreRetrieved() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.1, (Object)SlowDiskReports.DiskOp.READ, (Object)1.8));
        this.addSlowDiskForTesting("dn1", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.3));
        this.addSlowDiskForTesting("dn2", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.1));
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !TestSlowDiskTracker.this.tracker.getSlowDisksReport().isEmpty();
            }
        }, (long)500L, (long)5000L);
        Map<String, SlowDiskTracker.DiskLatency> reports = this.getSlowDisksReportForTesting(this.tracker);
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)3));
        Assert.assertTrue((Math.abs(reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.METADATA) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.READ) - 1.8) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn1:disk2").getLatency(SlowDiskReports.DiskOp.READ) - 1.3) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn2:disk2").getLatency(SlowDiskReports.DiskOp.READ) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
    }

    @Test
    public void testAllReportsAreExpired() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.1, (Object)SlowDiskReports.DiskOp.READ, (Object)1.8));
        this.addSlowDiskForTesting("dn1", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.3));
        this.addSlowDiskForTesting("dn2", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.1));
        this.timer.advance(1L);
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !TestSlowDiskTracker.this.tracker.getSlowDisksReport().isEmpty();
            }
        }, (long)500L, (long)5000L);
        Map<String, SlowDiskTracker.DiskLatency> reports = this.getSlowDisksReportForTesting(this.tracker);
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)3));
        Assert.assertTrue((Math.abs(reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.METADATA) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.READ) - 1.8) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn1:disk2").getLatency(SlowDiskReports.DiskOp.READ) - 1.3) < 1.0E-7 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn2:disk2").getLatency(SlowDiskReports.DiskOp.WRITE) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
        this.timer.advance(this.reportValidityMs);
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestSlowDiskTracker.this.tracker.getSlowDisksReport().isEmpty();
            }
        }, (long)500L, (long)3000L);
        reports = this.getSlowDisksReportForTesting(this.tracker);
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testSomeReportsAreExpired() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.1, (Object)SlowDiskReports.DiskOp.READ, (Object)1.8));
        this.addSlowDiskForTesting("dn1", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.3));
        this.timer.advance(this.reportValidityMs);
        this.addSlowDiskForTesting("dn2", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.1));
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !TestSlowDiskTracker.this.tracker.getSlowDisksReport().isEmpty();
            }
        }, (long)500L, (long)5000L);
        Map<String, SlowDiskTracker.DiskLatency> reports = this.getSlowDisksReportForTesting(this.tracker);
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((Math.abs(reports.get("dn2:disk2").getLatency(SlowDiskReports.DiskOp.WRITE) - 1.1) < 1.0E-7 ? 1 : 0) != 0);
    }

    @Test
    public void testReplacement() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.1, (Object)SlowDiskReports.DiskOp.READ, (Object)1.8));
        this.timer.advance(this.reportValidityMs);
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.4));
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !TestSlowDiskTracker.this.tracker.getSlowDisksReport().isEmpty();
            }
        }, (long)500L, (long)5000L);
        Map<String, SlowDiskTracker.DiskLatency> reports = this.getSlowDisksReportForTesting(this.tracker);
        Assert.assertThat((Object)reports.size(), (Matcher)Is.is((Object)1));
        Assert.assertTrue((reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.METADATA) == null ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(reports.get("dn1:disk1").getLatency(SlowDiskReports.DiskOp.READ) - 1.4) < 1.0E-7 ? 1 : 0) != 0);
    }

    @Test
    public void testGetJson() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.METADATA, (Object)1.1, (Object)SlowDiskReports.DiskOp.READ, (Object)1.8));
        this.addSlowDiskForTesting("dn1", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.3));
        this.addSlowDiskForTesting("dn2", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.1));
        this.addSlowDiskForTesting("dn3", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.1));
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestSlowDiskTracker.this.tracker.getSlowDiskReportAsJsonString() != null;
            }
        }, (long)500L, (long)5000L);
        ArrayList<SlowDiskTracker.DiskLatency> jsonReport = this.getAndDeserializeJson(this.tracker.getSlowDiskReportAsJsonString());
        Assert.assertThat((Object)jsonReport.size(), (Matcher)Is.is((Object)4));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn1", "disk1", SlowDiskReports.DiskOp.METADATA, 1.1));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn1", "disk1", SlowDiskReports.DiskOp.READ, 1.8));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn1", "disk2", SlowDiskReports.DiskOp.READ, 1.3));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn2", "disk2", SlowDiskReports.DiskOp.WRITE, 1.1));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn3", "disk1", SlowDiskReports.DiskOp.WRITE, 1.1));
    }

    @Test
    public void testGetJsonSizeIsLimited() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.1));
        this.addSlowDiskForTesting("dn1", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.2));
        this.addSlowDiskForTesting("dn1", "disk3", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.3));
        this.addSlowDiskForTesting("dn2", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.4));
        this.addSlowDiskForTesting("dn2", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.5));
        this.addSlowDiskForTesting("dn3", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.WRITE, (Object)1.6));
        this.addSlowDiskForTesting("dn3", "disk2", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.7));
        this.addSlowDiskForTesting("dn3", "disk3", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.2));
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestSlowDiskTracker.this.tracker.getSlowDiskReportAsJsonString() != null;
            }
        }, (long)500L, (long)5000L);
        ArrayList<SlowDiskTracker.DiskLatency> jsonReport = this.getAndDeserializeJson(this.tracker.getSlowDiskReportAsJsonString());
        Assert.assertThat((Object)jsonReport.size(), (Matcher)Is.is((Object)5));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn3", "disk2", SlowDiskReports.DiskOp.READ, 1.7));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn3", "disk1", SlowDiskReports.DiskOp.WRITE, 1.6));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn2", "disk2", SlowDiskReports.DiskOp.READ, 1.5));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn2", "disk1", SlowDiskReports.DiskOp.READ, 1.4));
        Assert.assertTrue((boolean)this.isDiskInReports(jsonReport, "dn1", "disk3", SlowDiskReports.DiskOp.READ, 1.3));
        Assert.assertFalse((boolean)this.isDiskInReports(jsonReport, "dn1", "disk1", SlowDiskReports.DiskOp.READ, 1.1));
        Assert.assertFalse((boolean)this.isDiskInReports(jsonReport, "dn1", "disk2", SlowDiskReports.DiskOp.READ, 1.2));
        Assert.assertFalse((boolean)this.isDiskInReports(jsonReport, "dn3", "disk3", SlowDiskReports.DiskOp.READ, 1.2));
    }

    @Test
    public void testEmptyReport() throws Exception {
        this.addSlowDiskForTesting("dn1", "disk1", (Map<SlowDiskReports.DiskOp, Double>)ImmutableMap.of((Object)SlowDiskReports.DiskOp.READ, (Object)1.1));
        this.timer.advance(this.reportValidityMs);
        this.tracker.updateSlowDiskReportAsync(this.timer.monotonicNow());
        Thread.sleep(2000L);
        Assert.assertTrue((this.tracker.getSlowDiskReportAsJsonString() == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveInvalidReport() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        try {
            NameNode nn = cluster.getNameNode(0);
            DatanodeManager datanodeManager = nn.getNamesystem().getBlockManager().getDatanodeManager();
            SlowDiskTracker slowDiskTracker = datanodeManager.getSlowDiskTracker();
            slowDiskTracker.setReportValidityMs(3000L);
            Assert.assertTrue((boolean)slowDiskTracker.getSlowDisksReport().isEmpty());
            slowDiskTracker.addSlowDiskReport("dn1", this.generateSlowDiskReport("disk1", Collections.singletonMap(SlowDiskReports.DiskOp.WRITE, 1.3)));
            slowDiskTracker.addSlowDiskReport("dn2", this.generateSlowDiskReport("disk2", Collections.singletonMap(SlowDiskReports.DiskOp.WRITE, 1.1)));
            GenericTestUtils.waitFor(() -> !slowDiskTracker.getSlowDisksReport().isEmpty(), (long)500L, (long)5000L);
            Map<String, SlowDiskTracker.DiskLatency> slowDisksReport = this.getSlowDisksReportForTesting(slowDiskTracker);
            Assert.assertEquals((long)2L, (long)slowDisksReport.size());
            Thread.sleep(3000L);
            GenericTestUtils.waitFor(() -> slowDiskTracker.getSlowDisksReport().isEmpty(), (long)500L, (long)5000L);
            slowDisksReport = this.getSlowDisksReportForTesting(slowDiskTracker);
            Assert.assertEquals((long)0L, (long)slowDisksReport.size());
        }
        finally {
            cluster.shutdown();
        }
    }

    private boolean isDiskInReports(ArrayList<SlowDiskTracker.DiskLatency> reports, String dataNodeID, String disk, SlowDiskReports.DiskOp diskOp, double latency) {
        String diskID = SlowDiskTracker.getSlowDiskIDForReport((String)dataNodeID, (String)disk);
        for (SlowDiskTracker.DiskLatency diskLatency : reports) {
            if (!diskLatency.getSlowDiskID().equals(diskID)) continue;
            if (diskLatency.getLatency(diskOp) == null) {
                return false;
            }
            if (!(Math.abs(diskLatency.getLatency(diskOp) - latency) < 1.0E-7)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<SlowDiskTracker.DiskLatency> getAndDeserializeJson(String json) throws IOException {
        return (ArrayList)READER.readValue(json);
    }

    private void addSlowDiskForTesting(String dnID, String disk, Map<SlowDiskReports.DiskOp, Double> latencies) {
        HashMap slowDisk = Maps.newHashMap();
        slowDisk.put(disk, latencies);
        SlowDiskReports slowDiskReport = SlowDiskReports.create((Map)slowDisk);
        this.tracker.addSlowDiskReport(dnID, slowDiskReport);
    }

    private SlowDiskReports generateSlowDiskReport(String disk, Map<SlowDiskReports.DiskOp, Double> latencies) {
        HashMap slowDisk = Maps.newHashMap();
        slowDisk.put(disk, latencies);
        SlowDiskReports slowDiskReport = SlowDiskReports.create((Map)slowDisk);
        return slowDiskReport;
    }

    Map<String, SlowDiskTracker.DiskLatency> getSlowDisksReportForTesting(SlowDiskTracker slowDiskTracker) {
        HashMap slowDisksMap = Maps.newHashMap();
        for (SlowDiskTracker.DiskLatency diskLatency : slowDiskTracker.getSlowDisksReport()) {
            slowDisksMap.put(diskLatency.getSlowDiskID(), diskLatency);
        }
        return slowDisksMap;
    }

    static {
        READER = new ObjectMapper().readerFor((TypeReference)new TypeReference<ArrayList<SlowDiskTracker.DiskLatency>>(){});
        conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.datanode.fileio.profiling.sampling.percentage", 100);
        conf.setTimeDuration("dfs.datanode.outliers.report.interval", 1000L, TimeUnit.MILLISECONDS);
    }
}

