/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.math.LongMath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.FsDatasetTestUtils;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImplTestUtils;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetricHelper;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.DataChecksum;

public class SimulatedFSDataset
implements FsDatasetSpi<FsVolumeSpi> {
    public static final int BYTE_MASK = 255;
    private static final int DEFAULT_NUM_SIMULATED_DATA_DIRS = 1;
    public static final String CONFIG_PROPERTY_CAPACITY = "dfs.datanode.simulateddatastorage.capacity";
    public static final long DEFAULT_CAPACITY = 0x20000000000L;
    public static final String CONFIG_PROPERTY_STATE = "dfs.datanode.simulateddatastorage.state";
    private static final DatanodeStorage.State DEFAULT_STATE = DatanodeStorage.State.NORMAL;
    static final byte[] nullCrcFileData;
    private final AutoCloseableLock datasetLock;
    private final FileIoProvider fileIoProvider;
    private final List<SimulatedStorage> storages;
    private final String datanodeUuid;
    private final DataNode datanode;
    private ObjectName mbeanName;

    public static void setFactory(Configuration conf) {
        conf.set("dfs.datanode.fsdataset.factory", Factory.class.getName());
        conf.setClass("org.apache.hadoop.hdfs.server.datanode.SimulatedFSDatasetTestUtilsFactory", TestUtilsFactory.class, FsDatasetTestUtils.Factory.class);
    }

    public static byte simulatedByte(Block b, long offsetInBlk) {
        byte firstByte = (byte)(b.getBlockId() & 0xFFL);
        return (byte)((long)firstByte + offsetInBlk % 29L & 0xFFL);
    }

    public List<SimulatedStorage> getStorages() {
        return this.storages;
    }

    public SimulatedFSDataset(DataStorage storage, Configuration conf) {
        this(null, storage, conf);
    }

    public SimulatedFSDataset(DataNode datanode, DataStorage storage, Configuration conf) {
        int i;
        int storageCount;
        this.datanode = datanode;
        if (storage != null && storage.getNumStorageDirs() > 0) {
            storageCount = storage.getNumStorageDirs();
            for (i = 0; i < storage.getNumStorageDirs(); ++i) {
                DataStorage.createStorageID((Storage.StorageDirectory)storage.getStorageDir(i), (boolean)false, (Configuration)conf);
            }
            this.datanodeUuid = storage.getDatanodeUuid();
        } else {
            storageCount = DataNode.getStorageLocations((Configuration)conf).size();
            this.datanodeUuid = "SimulatedDatanode-" + DataNode.generateUuid();
        }
        this.registerMBean(this.datanodeUuid);
        this.fileIoProvider = new FileIoProvider(conf, datanode);
        this.datasetLock = new AutoCloseableLock();
        this.storages = new ArrayList<SimulatedStorage>();
        for (i = 0; i < storageCount; ++i) {
            this.storages.add(new SimulatedStorage(conf.getLong(CONFIG_PROPERTY_CAPACITY, 0x20000000000L), (DatanodeStorage.State)conf.getEnum(CONFIG_PROPERTY_STATE, (Enum)DEFAULT_STATE), this.fileIoProvider, conf));
        }
    }

    public synchronized void injectBlocks(String bpid, Iterable<? extends Block> injectBlocks) throws IOException {
        ExtendedBlock blk = new ExtendedBlock();
        if (injectBlocks != null) {
            for (Block block : injectBlocks) {
                if (block == null) {
                    throw new NullPointerException("Null blocks in block list");
                }
                blk.set(bpid, block);
                if (!this.isValidBlock(blk)) continue;
                throw new IOException("Block already exists in  block list");
            }
            for (SimulatedStorage simulatedStorage : this.storages) {
                simulatedStorage.addBlockPool(bpid);
            }
            for (Block block : injectBlocks) {
                BInfo binfo = new BInfo(bpid, block, false);
                this.getBlockMap(block, bpid).put(binfo.theBlock, binfo);
            }
        }
    }

    private SimulatedStorage getStorage(Block b) {
        return this.storages.get(LongMath.mod((long)b.getBlockId(), (int)this.storages.size()));
    }

    private Map<Block, BInfo> getBlockMap(Block b, String bpid) throws IOException {
        return this.getStorage(b).getBlockMap(bpid);
    }

    private Map<Block, BInfo> getBlockMap(ExtendedBlock b) throws IOException {
        return this.getBlockMap(b.getLocalBlock(), b.getBlockPoolId());
    }

    public synchronized void finalizeBlock(ExtendedBlock b, boolean fsyncDir) throws IOException {
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        binfo.finalizeBlock(b.getBlockPoolId(), b.getNumBytes());
    }

    public synchronized void unfinalizeBlock(ExtendedBlock b) throws IOException {
        if (this.isValidRbw(b)) {
            this.getBlockMap(b).remove(b.getLocalBlock());
        }
    }

    synchronized BlockListAsLongs getBlockReport(String bpid, SimulatedStorage storage) {
        BlockListAsLongs.Builder report = BlockListAsLongs.builder();
        try {
            for (BInfo b : storage.getBlockMap(bpid).values()) {
                if (!b.isFinalized()) continue;
                report.add((Replica)b);
            }
        }
        catch (IOException ioe) {
            DataNode.LOG.error("Exception while getting block reports", (Throwable)ioe);
        }
        return report.build();
    }

    public synchronized Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String bpid) {
        HashMap<DatanodeStorage, BlockListAsLongs> blockReports = new HashMap<DatanodeStorage, BlockListAsLongs>();
        for (SimulatedStorage storage : this.storages) {
            blockReports.put(storage.getDnStorage(), this.getBlockReport(bpid, storage));
        }
        return blockReports;
    }

    public List<Long> getCacheReport(String bpid) {
        return Collections.emptyList();
    }

    public long getCapacity() {
        long total = 0L;
        for (SimulatedStorage storage : this.storages) {
            total += storage.getCapacity();
        }
        return total;
    }

    public long getDfsUsed() {
        long total = 0L;
        for (SimulatedStorage storage : this.storages) {
            total += storage.getUsed();
        }
        return total;
    }

    public long getBlockPoolUsed(String bpid) throws IOException {
        long total = 0L;
        for (SimulatedStorage storage : this.storages) {
            total += storage.getBlockPoolUsed(bpid);
        }
        return total;
    }

    public long getRemaining() {
        long total = 0L;
        for (SimulatedStorage storage : this.storages) {
            total += storage.getFree();
        }
        return total;
    }

    public int getNumFailedVolumes() {
        int total = 0;
        for (SimulatedStorage storage : this.storages) {
            total += storage.getNumFailedVolumes();
        }
        return total;
    }

    public String[] getFailedStorageLocations() {
        return null;
    }

    public long getLastVolumeFailureDate() {
        return 0L;
    }

    public long getEstimatedCapacityLostTotal() {
        return 0L;
    }

    public VolumeFailureSummary getVolumeFailureSummary() {
        return new VolumeFailureSummary(ArrayUtils.EMPTY_STRING_ARRAY, 0L, 0L);
    }

    public long getCacheUsed() {
        return 0L;
    }

    public long getCacheCapacity() {
        return 0L;
    }

    public long getNumBlocksCached() {
        return 0L;
    }

    public long getNumBlocksFailedToCache() {
        return 0L;
    }

    public long getNumBlocksFailedToUncache() {
        return 0L;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        try {
            DataNodeMetricHelper.getMetrics((MetricsCollector)collector, (FSDatasetMBean)this, (String)"SimulatedFSDataset");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized long getLength(ExtendedBlock b) throws IOException {
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        return binfo.getNumBytes();
    }

    @Deprecated
    public Replica getReplica(String bpid, long blockId) {
        Block b = new Block(blockId);
        try {
            return (Replica)this.getBlockMap(b, bpid).get(b);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public synchronized String getReplicaString(String bpid, long blockId) {
        Replica r = null;
        try {
            Block b = new Block(blockId);
            r = (Replica)this.getBlockMap(b, bpid).get(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Objects.toString(r);
    }

    public Block getStoredBlock(String bpid, long blkid) throws IOException {
        Block b = new Block(blkid);
        try {
            BInfo binfo = this.getBlockMap(b, bpid).get(b);
            if (binfo == null) {
                return null;
            }
            return new Block(blkid, binfo.getGenerationStamp(), binfo.getNumBytes());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public synchronized void invalidate(String bpid, Block[] invalidBlks) throws IOException {
        boolean error = false;
        if (invalidBlks == null) {
            return;
        }
        for (Block b : invalidBlks) {
            if (b == null) continue;
            Map<Block, BInfo> map = this.getBlockMap(b, bpid);
            BInfo binfo = map.get(b);
            if (binfo == null) {
                error = true;
                DataNode.LOG.warn("Invalidate: Missing block");
                continue;
            }
            this.getStorage(b).free(bpid, binfo.getNumBytes());
            map.remove(b);
            if (this.datanode == null) continue;
            this.datanode.notifyNamenodeDeletedBlock(new ExtendedBlock(bpid, b), binfo.getStorageUuid());
        }
        if (error) {
            throw new IOException("Invalidate: Missing blocks.");
        }
    }

    public void cache(String bpid, long[] cacheBlks) {
        throw new UnsupportedOperationException("SimulatedFSDataset does not support cache operation!");
    }

    public void uncache(String bpid, long[] uncacheBlks) {
        throw new UnsupportedOperationException("SimulatedFSDataset does not support uncache operation!");
    }

    public boolean isCached(String bpid, long blockId) {
        return false;
    }

    private BInfo getBInfo(ExtendedBlock b) {
        try {
            return this.getBlockMap(b).get(b.getLocalBlock());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean contains(ExtendedBlock block) {
        return this.getBInfo(block) != null;
    }

    public void checkBlock(ExtendedBlock b, long minLength, HdfsServerConstants.ReplicaState state) throws ReplicaNotFoundException, UnexpectedReplicaStateException {
        BInfo binfo = this.getBInfo(b);
        if (binfo == null) {
            throw new ReplicaNotFoundException(b);
        }
        if (state == HdfsServerConstants.ReplicaState.FINALIZED && !binfo.isFinalized() || state != HdfsServerConstants.ReplicaState.FINALIZED && binfo.isFinalized()) {
            throw new UnexpectedReplicaStateException(b, state);
        }
    }

    public synchronized boolean isValidBlock(ExtendedBlock b) {
        try {
            this.checkBlock(b, 0L, HdfsServerConstants.ReplicaState.FINALIZED);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public synchronized boolean isValidRbw(ExtendedBlock b) {
        try {
            this.checkBlock(b, 0L, HdfsServerConstants.ReplicaState.RBW);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getStorageInfo();
    }

    public synchronized ReplicaHandler append(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null || !binfo.isFinalized()) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        binfo.unfinalizeBlock();
        return new ReplicaHandler((ReplicaInPipeline)binfo, null);
    }

    public synchronized ReplicaHandler recoverAppend(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        Map<Block, BInfo> map = this.getBlockMap(b);
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        if (binfo.isFinalized()) {
            binfo.unfinalizeBlock();
        }
        map.remove(b);
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return new ReplicaHandler((ReplicaInPipeline)binfo, null);
    }

    public Replica recoverClose(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        Map<Block, BInfo> map = this.getBlockMap(b);
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        if (!binfo.isFinalized()) {
            binfo.finalizeBlock(b.getBlockPoolId(), binfo.getNumBytes());
        }
        map.remove(b.getLocalBlock());
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return binfo;
    }

    public synchronized ReplicaHandler recoverRbw(ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        Map<Block, BInfo> map = this.getBlockMap(b);
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " does not exist, and cannot be appended to.");
        }
        if (binfo.isFinalized()) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
        }
        map.remove(b);
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return new ReplicaHandler((ReplicaInPipeline)binfo, null);
    }

    public synchronized ReplicaHandler createRbw(StorageType storageType, String storageId, ExtendedBlock b, boolean allowLazyPersist) throws IOException {
        return this.createTemporary(storageType, storageId, b, false);
    }

    public synchronized ReplicaHandler createTemporary(StorageType storageType, String storageId, ExtendedBlock b, boolean isTransfer) throws IOException {
        if (this.isValidBlock(b)) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
        }
        if (this.isValidRbw(b)) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is being written, and cannot be written to.");
        }
        BInfo binfo = new BInfo(b.getBlockPoolId(), b.getLocalBlock(), true);
        this.getBlockMap(b).put(binfo.theBlock, binfo);
        return new ReplicaHandler((ReplicaInPipeline)binfo, null);
    }

    public synchronized InputStream getBlockInputStream(ExtendedBlock b) throws IOException {
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return binfo.getIStream();
    }

    public synchronized InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
        InputStream result = this.getBlockInputStream(b);
        IOUtils.skipFully((InputStream)result, (long)seekOffset);
        return result;
    }

    public ReplicaInputStreams getTmpInputStreams(ExtendedBlock b, long blkoff, long ckoff) throws IOException {
        throw new IOException("Not supported");
    }

    public synchronized LengthInputStream getMetaDataInputStream(ExtendedBlock b) throws IOException {
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        if (!binfo.finalized) {
            throw new IOException("Block " + b + " is being written, its meta cannot be read");
        }
        SimulatedInputStream sin = binfo.getMetaIStream();
        return new LengthInputStream((InputStream)sin, sin.getLength());
    }

    public void handleVolumeFailures(Set<FsVolumeSpi> failedVolumes) {
    }

    public synchronized void adjustCrcChannelPosition(ExtendedBlock b, ReplicaOutputStreams stream, int checksumSize) throws IOException {
    }

    void registerMBean(String storageId) {
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register((String)"DataNode", (String)("FSDatasetState-" + storageId), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            DataNode.LOG.warn("Error registering FSDatasetState MBean", (Throwable)e);
        }
        DataNode.LOG.info("Registered FSDatasetState MBean");
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
    }

    public String getStorageInfo() {
        return "Simulated FSDataset-" + this.datanodeUuid;
    }

    public boolean hasEnoughResource() {
        return true;
    }

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        ExtendedBlock b = rBlock.getBlock();
        BInfo binfo = this.getBlockMap(b).get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return new ReplicaRecoveryInfo(binfo.getBlockId(), binfo.getBytesOnDisk(), binfo.getGenerationStamp(), binfo.isFinalized() ? HdfsServerConstants.ReplicaState.FINALIZED : HdfsServerConstants.ReplicaState.RBW);
    }

    public Replica updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newBlockId, long newlength) throws IOException {
        return this.getBInfo(oldBlock);
    }

    public long getReplicaVisibleLength(ExtendedBlock block) {
        return block.getNumBytes();
    }

    public void addBlockPool(String bpid, Configuration conf) {
        for (SimulatedStorage storage : this.storages) {
            storage.addBlockPool(bpid);
        }
    }

    public void shutdownBlockPool(String bpid) {
        for (SimulatedStorage storage : this.storages) {
            storage.removeBlockPool(bpid);
        }
    }

    public void deleteBlockPool(String bpid, boolean force) {
    }

    public ReplicaInPipeline convertTemporaryToRbw(ExtendedBlock temporary) throws IOException {
        BInfo r = this.getBlockMap(temporary).get(temporary.getLocalBlock());
        if (r == null) {
            throw new IOException("Block not found, temporary=" + temporary);
        }
        if (r.isFinalized()) {
            throw new IOException("Replica already finalized, temporary=" + temporary + ", r=" + r);
        }
        return r;
    }

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock b) {
        throw new UnsupportedOperationException();
    }

    public void enableTrash(String bpid) {
        throw new UnsupportedOperationException();
    }

    public void clearTrash(String bpid) {
    }

    public boolean trashEnabled(String bpid) {
        return false;
    }

    public void setRollingUpgradeMarker(String bpid) {
    }

    public void clearRollingUpgradeMarker(String bpid) {
    }

    public void checkAndUpdate(String bpid, FsVolumeSpi.ScanInfo info) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FsDatasetSpi.FsVolumeReferences getFsVolumeReferences() {
        ArrayList<SimulatedVolume> volumes = new ArrayList<SimulatedVolume>();
        for (SimulatedStorage storage : this.storages) {
            volumes.add(storage.getVolume());
        }
        return new FsDatasetSpi.FsVolumeReferences(volumes);
    }

    public void addVolume(StorageLocation location, List<NamespaceInfo> nsInfos) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DatanodeStorage getStorage(String storageUuid) {
        for (SimulatedStorage storage : this.storages) {
            if (!storageUuid.equals(storage.getStorageUuid())) continue;
            return storage.getDnStorage();
        }
        return null;
    }

    public StorageReport[] getStorageReports(String bpid) {
        ArrayList<StorageReport> reports = new ArrayList<StorageReport>();
        for (SimulatedStorage storage : this.storages) {
            reports.add(storage.getStorageReport(bpid));
        }
        return reports.toArray(new StorageReport[0]);
    }

    public List<ReplicaInfo> getFinalizedBlocks(String bpid) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getVolumeInfoMap() {
        throw new UnsupportedOperationException();
    }

    public FsVolumeSpi getVolume(ExtendedBlock b) {
        return this.getStorage(b.getLocalBlock()).getVolume();
    }

    public synchronized void removeVolumes(Collection<StorageLocation> volumes, boolean clearFailure) {
        throw new UnsupportedOperationException();
    }

    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock block, ReplicaOutputStreams outs, long offset, long nbytes, int flags) {
        throw new UnsupportedOperationException();
    }

    public void onCompleteLazyPersist(String bpId, long blockId, long creationTime, File[] savedFiles, FsVolumeSpi targetVolume) {
        throw new UnsupportedOperationException();
    }

    public void onFailLazyPersist(String bpId, long blockId) {
        throw new UnsupportedOperationException();
    }

    public ReplicaInfo moveBlockAcrossStorage(ExtendedBlock block, StorageType targetStorageType, String storageId) throws IOException {
        return null;
    }

    public void setPinning(ExtendedBlock b) throws IOException {
        this.getBlockMap(b).get(b.getLocalBlock()).pinned = true;
    }

    public boolean getPinning(ExtendedBlock b) throws IOException {
        return this.getBlockMap(b).get(b.getLocalBlock()).pinned;
    }

    public boolean isDeletingBlock(String bpid, long blockId) {
        throw new UnsupportedOperationException();
    }

    public ReplicaInfo moveBlockAcrossVolumes(ExtendedBlock block, FsVolumeSpi destination) throws IOException {
        return null;
    }

    public AutoCloseableLock acquireDatasetLock() {
        return this.datasetLock.acquire();
    }

    public AutoCloseableLock acquireDatasetReadLock() {
        return this.datasetLock.acquire();
    }

    public Set<? extends Replica> deepCopyReplica(String bpid) throws IOException {
        HashSet<BInfo> replicas = new HashSet<BInfo>();
        for (SimulatedStorage s : this.storages) {
            replicas.addAll(s.getBlockMap(bpid).values());
        }
        return Collections.unmodifiableSet(replicas);
    }

    static {
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)16384);
        byte[] nullCrcHeader = checksum.getHeader();
        nullCrcFileData = new byte[2 + nullCrcHeader.length];
        SimulatedFSDataset.nullCrcFileData[0] = 0;
        SimulatedFSDataset.nullCrcFileData[1] = 1;
        for (int i = 0; i < nullCrcHeader.length; ++i) {
            SimulatedFSDataset.nullCrcFileData[i + 2] = nullCrcHeader[i];
        }
    }

    private static class SimulatedOutputStream
    extends OutputStream {
        long length = 0L;

        SimulatedOutputStream() {
        }

        long getLength() {
            return this.length;
        }

        void setLength(long length) {
            this.length = length;
        }

        @Override
        public void write(int arg0) throws IOException {
            ++this.length;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.length += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.length += (long)len;
        }
    }

    private static class SimulatedInputStream
    extends InputStream {
        final long length;
        int currentPos = 0;
        byte[] data = null;
        Block theBlock = null;

        SimulatedInputStream(long l, Block b) {
            this.length = l;
            this.theBlock = b;
        }

        SimulatedInputStream(byte[] iData) {
            this.data = iData;
            this.length = this.data.length;
        }

        long getLength() {
            return this.length;
        }

        @Override
        public int read() throws IOException {
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            if (this.data != null) {
                return this.data[this.currentPos++];
            }
            return SimulatedFSDataset.simulatedByte(this.theBlock, this.currentPos++) & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (b.length == 0) {
                return 0;
            }
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            int bytesRead = (int)Math.min((long)b.length, this.length - (long)this.currentPos);
            if (this.data != null) {
                System.arraycopy(this.data, this.currentPos, b, 0, bytesRead);
            } else {
                for (int i = 0; i < bytesRead; ++i) {
                    b[i] = SimulatedFSDataset.simulatedByte(this.theBlock, this.currentPos + i);
                }
            }
            this.currentPos += bytesRead;
            return bytesRead;
        }
    }

    static class SimulatedVolume
    implements FsVolumeSpi {
        private final SimulatedStorage storage;
        private final FileIoProvider fileIoProvider;
        private final DataNodeVolumeMetrics metrics;

        SimulatedVolume(SimulatedStorage storage, FileIoProvider fileIoProvider, DataNodeVolumeMetrics metrics) {
            this.storage = storage;
            this.fileIoProvider = fileIoProvider;
            this.metrics = metrics;
        }

        public FsVolumeReference obtainReference() throws ClosedChannelException {
            return new FsVolumeReference(){

                public void close() throws IOException {
                }

                public FsVolumeSpi getVolume() {
                    return this;
                }
            };
        }

        public String getStorageID() {
            return this.storage.getStorageUuid();
        }

        public String[] getBlockPoolList() {
            return new String[0];
        }

        public long getAvailable() throws IOException {
            return this.storage.getCapacity() - this.storage.getUsed();
        }

        public StorageType getStorageType() {
            return StorageType.DISK;
        }

        public boolean isTransientStorage() {
            return false;
        }

        public void reserveSpaceForReplica(long bytesToReserve) {
        }

        public void releaseLockedMemory(long bytesToRelease) {
        }

        public void releaseReservedSpace(long bytesToRelease) {
        }

        public FsVolumeSpi.BlockIterator newBlockIterator(String bpid, String name) {
            throw new UnsupportedOperationException();
        }

        public FsVolumeSpi.BlockIterator loadBlockIterator(String bpid, String name) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FsDatasetSpi getDataset() {
            throw new UnsupportedOperationException();
        }

        public StorageLocation getStorageLocation() {
            try {
                return StorageLocation.parse((String)"[DISK]file:///simulated");
            }
            catch (Exception e) {
                return null;
            }
        }

        public URI getBaseURI() {
            return null;
        }

        public DF getUsageStats(Configuration conf) {
            return null;
        }

        public byte[] loadLastPartialChunkChecksum(File blockFile, File metaFile) throws IOException {
            return null;
        }

        public void compileReport(String bpid, Collection<FsVolumeSpi.ScanInfo> report, DirectoryScanner.ReportCompiler reportCompiler) throws InterruptedException, IOException {
        }

        public FileIoProvider getFileIoProvider() {
            return this.fileIoProvider;
        }

        public DataNodeVolumeMetrics getMetrics() {
            return this.metrics;
        }

        public VolumeCheckResult check(FsVolumeSpi.VolumeCheckContext context) throws Exception {
            return VolumeCheckResult.HEALTHY;
        }
    }

    static class SimulatedStorage {
        private final Map<String, SimulatedBPStorage> map = new ConcurrentHashMap<String, SimulatedBPStorage>();
        private final long capacity;
        private final DatanodeStorage dnStorage;
        private final SimulatedVolume volume;

        synchronized long getFree() {
            return this.capacity - this.getUsed();
        }

        long getCapacity() {
            return this.capacity;
        }

        synchronized long getUsed() {
            long used = 0L;
            for (SimulatedBPStorage bpStorage : this.map.values()) {
                used += bpStorage.getUsed();
            }
            return used;
        }

        synchronized long getBlockPoolUsed(String bpid) throws IOException {
            return this.getBPStorage(bpid).getUsed();
        }

        int getNumFailedVolumes() {
            return 0;
        }

        synchronized boolean alloc(String bpid, long amount) throws IOException {
            if (this.getFree() >= amount) {
                this.getBPStorage(bpid).alloc(amount);
                return true;
            }
            return false;
        }

        synchronized void free(String bpid, long amount) throws IOException {
            this.getBPStorage(bpid).free(amount);
        }

        SimulatedStorage(long cap, DatanodeStorage.State state, FileIoProvider fileIoProvider, Configuration conf) {
            this.capacity = cap;
            this.dnStorage = new DatanodeStorage("SimulatedStorage-" + DatanodeStorage.generateUuid(), state, StorageType.DEFAULT);
            DataNodeVolumeMetrics volumeMetrics = DataNodeVolumeMetrics.create((Configuration)conf, (String)this.dnStorage.getStorageID());
            this.volume = new SimulatedVolume(this, fileIoProvider, volumeMetrics);
        }

        synchronized void addBlockPool(String bpid) {
            SimulatedBPStorage bpStorage = this.map.get(bpid);
            if (bpStorage != null) {
                return;
            }
            this.map.put(bpid, new SimulatedBPStorage());
        }

        synchronized void removeBlockPool(String bpid) {
            this.map.remove(bpid);
        }

        private SimulatedBPStorage getBPStorage(String bpid) throws IOException {
            SimulatedBPStorage bpStorage = this.map.get(bpid);
            if (bpStorage == null) {
                throw new IOException("block pool " + bpid + " not found");
            }
            return bpStorage;
        }

        String getStorageUuid() {
            return this.dnStorage.getStorageID();
        }

        DatanodeStorage getDnStorage() {
            return this.dnStorage;
        }

        synchronized StorageReport getStorageReport(String bpid) {
            return new StorageReport(this.dnStorage, false, this.getCapacity(), this.getUsed(), this.getFree(), this.map.get(bpid).getUsed(), 0L);
        }

        SimulatedVolume getVolume() {
            return this.volume;
        }

        Map<Block, BInfo> getBlockMap(String bpid) throws IOException {
            SimulatedBPStorage bpStorage = this.map.get(bpid);
            if (bpStorage == null) {
                throw new IOException("Nonexistent block pool: " + bpid);
            }
            return bpStorage.getBlockMap();
        }
    }

    private static class SimulatedBPStorage {
        private long used = 0L;
        private final Map<Block, BInfo> blockMap = new TreeMap<Block, BInfo>();

        long getUsed() {
            return this.used;
        }

        void alloc(long amount) {
            this.used += amount;
        }

        void free(long amount) {
            this.used -= amount;
        }

        Map<Block, BInfo> getBlockMap() {
            return this.blockMap;
        }

        SimulatedBPStorage() {
        }
    }

    private class BInfo
    implements ReplicaInPipeline {
        final Block theBlock;
        private boolean finalized = false;
        SimulatedOutputStream oStream = null;
        private long bytesAcked;
        private long bytesRcvd;
        private boolean pinned = false;

        BInfo(String bpid, Block b, boolean forWriting) throws IOException {
            this.theBlock = new Block(b);
            if (this.theBlock.getNumBytes() < 0L) {
                this.theBlock.setNumBytes(0L);
            }
            if (!SimulatedFSDataset.this.getStorage(this.theBlock).alloc(bpid, this.theBlock.getNumBytes())) {
                DataNode.LOG.warn("Lack of free storage on a block alloc");
                throw new IOException("Creating block, no free space available");
            }
            if (forWriting) {
                this.finalized = false;
                this.oStream = new SimulatedOutputStream();
            } else {
                this.finalized = true;
                this.oStream = null;
            }
        }

        public String getStorageUuid() {
            return SimulatedFSDataset.this.getStorage(this.theBlock).getStorageUuid();
        }

        public synchronized long getGenerationStamp() {
            return this.theBlock.getGenerationStamp();
        }

        public synchronized long getNumBytes() {
            if (!this.finalized) {
                return this.bytesRcvd;
            }
            return this.theBlock.getNumBytes();
        }

        public synchronized void setNumBytes(long length) {
            if (!this.finalized) {
                this.bytesRcvd = length;
            } else {
                this.theBlock.setNumBytes(length);
            }
        }

        synchronized SimulatedInputStream getIStream() {
            if (!this.finalized) {
                return new SimulatedInputStream(this.oStream.getLength(), this.theBlock);
            }
            return new SimulatedInputStream(this.theBlock.getNumBytes(), this.theBlock);
        }

        synchronized void finalizeBlock(String bpid, long finalSize) throws IOException {
            if (this.finalized) {
                throw new IOException("Finalizing a block that has already been finalized" + this.theBlock.getBlockId());
            }
            if (this.oStream == null) {
                DataNode.LOG.error("Null oStream on unfinalized block - bug");
                throw new IOException("Unexpected error on finalize");
            }
            if (this.oStream.getLength() != finalSize) {
                DataNode.LOG.warn("Size passed to finalize (" + finalSize + ")does not match what was written:" + this.oStream.getLength());
                throw new IOException("Size passed to finalize does not match the amount of data written");
            }
            long extraLen = finalSize - this.theBlock.getNumBytes();
            if (extraLen > 0L) {
                if (!SimulatedFSDataset.this.getStorage(this.theBlock).alloc(bpid, extraLen)) {
                    DataNode.LOG.warn("Lack of free storage on a block alloc");
                    throw new IOException("Creating block, no free space available");
                }
            } else {
                SimulatedFSDataset.this.getStorage(this.theBlock).free(bpid, -extraLen);
            }
            this.theBlock.setNumBytes(finalSize);
            this.finalized = true;
            this.oStream = null;
        }

        synchronized void unfinalizeBlock() throws IOException {
            if (!this.finalized) {
                throw new IOException("Unfinalized a block that's not finalized " + this.theBlock);
            }
            this.finalized = false;
            this.oStream = new SimulatedOutputStream();
            long blockLen = this.theBlock.getNumBytes();
            this.oStream.setLength(blockLen);
            this.bytesRcvd = blockLen;
            this.bytesAcked = blockLen;
        }

        SimulatedInputStream getMetaIStream() {
            return new SimulatedInputStream(nullCrcFileData);
        }

        synchronized boolean isFinalized() {
            return this.finalized;
        }

        public synchronized ReplicaOutputStreams createStreams(boolean isCreate, DataChecksum requestedChecksum) throws IOException {
            if (this.finalized) {
                throw new IOException("Trying to write to a finalized replica " + this.theBlock);
            }
            SimulatedOutputStream crcStream = new SimulatedOutputStream();
            return new ReplicaOutputStreams((OutputStream)this.oStream, (OutputStream)crcStream, requestedChecksum, (FsVolumeSpi)SimulatedFSDataset.this.getStorage(this.theBlock).getVolume(), SimulatedFSDataset.this.fileIoProvider);
        }

        public OutputStream createRestartMetaStream() throws IOException {
            return new SimulatedOutputStream();
        }

        public synchronized long getBlockId() {
            return this.theBlock.getBlockId();
        }

        public synchronized long getVisibleLength() {
            return this.getBytesAcked();
        }

        public HdfsServerConstants.ReplicaState getState() {
            return this.finalized ? HdfsServerConstants.ReplicaState.FINALIZED : HdfsServerConstants.ReplicaState.RBW;
        }

        public synchronized long getBytesAcked() {
            if (this.finalized) {
                return this.theBlock.getNumBytes();
            }
            return this.bytesAcked;
        }

        public synchronized void setBytesAcked(long bytesAcked) {
            if (!this.finalized) {
                this.bytesAcked = bytesAcked;
            }
        }

        public void releaseAllBytesReserved() {
        }

        public synchronized long getBytesOnDisk() {
            if (this.finalized) {
                return this.theBlock.getNumBytes();
            }
            return this.oStream.getLength();
        }

        public void setLastChecksumAndDataLen(long dataLength, byte[] lastChecksum) {
            this.oStream.setLength(dataLength);
        }

        public ChunkChecksum getLastChecksumAndDataLen() {
            return new ChunkChecksum(this.oStream.getLength(), null);
        }

        public boolean isOnTransientStorage() {
            return false;
        }

        public ReplicaInfo getReplicaInfo() {
            return null;
        }

        public void setWriter(Thread writer) {
        }

        public void interruptThread() {
        }

        public boolean attemptToSetWriter(Thread prevWriter, Thread newWriter) {
            return false;
        }

        public void stopWriter(long xceiverStopTimeout) throws IOException {
        }

        public void waitForMinLength(long minLength, long time, TimeUnit unit) throws IOException {
            long deadLine = System.currentTimeMillis() + unit.toMillis(time);
            do {
                if (this.getBytesOnDisk() >= minLength) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            } while (deadLine > System.currentTimeMillis());
            throw new IOException("Minimum length was not achieved within timeout");
        }
    }

    static class TestUtilsFactory
    extends FsDatasetTestUtils.Factory<FsDatasetTestUtils> {
        TestUtilsFactory() {
        }

        @Override
        public FsDatasetTestUtils newInstance(DataNode datanode) {
            return new FsDatasetImplTestUtils(datanode){

                @Override
                public int getDefaultNumOfDataDirs() {
                    return 1;
                }
            };
        }

        @Override
        public boolean isSimulated() {
            return true;
        }

        @Override
        public int getDefaultNumOfDataDirs() {
            return 1;
        }
    }

    static class Factory
    extends FsDatasetSpi.Factory<SimulatedFSDataset> {
        Factory() {
        }

        public SimulatedFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
            return new SimulatedFSDataset(datanode, storage, conf);
        }

        public boolean isSimulated() {
            return true;
        }
    }
}

