/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestReplicationPolicyExcludeSlowNodes
extends BaseReplicationPolicyTest {
    public TestReplicationPolicyExcludeSlowNodes(String blockPlacementPolicy) {
        this.blockPlacementPolicy = blockPlacementPolicy;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({BlockPlacementPolicyDefault.class.getName()}, {BlockPlacementPolicyWithUpgradeDomain.class.getName()}, {AvailableSpaceBlockPlacementPolicy.class.getName()}, {BlockPlacementPolicyRackFaultTolerant.class.getName()});
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        conf.setBoolean("dfs.datanode.peer.stats.enabled", true);
        conf.setStrings("dfs.namenode.slowpeer.collect.interval", new String[]{"1s"});
        conf.setBoolean("dfs.namenode.block-placement-policy.exclude-slow-nodes.enabled", true);
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3", "/rack4", "/rack5", "/rack6"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetExcludeSlowNodes() throws Exception {
        this.namenode.getNamesystem().writeLock();
        try {
            for (int i = 0; i < this.dataNodes.length; ++i) {
                this.dnManager.addDatanode(this.dataNodes[i]);
            }
            SlowPeerTracker tracker = this.dnManager.getSlowPeerTracker();
            tracker.addReport(this.dataNodes[0].getInfoAddr(), this.dataNodes[3].getInfoAddr());
            tracker.addReport(this.dataNodes[0].getInfoAddr(), this.dataNodes[4].getInfoAddr());
            tracker.addReport(this.dataNodes[1].getInfoAddr(), this.dataNodes[4].getInfoAddr());
            tracker.addReport(this.dataNodes[1].getInfoAddr(), this.dataNodes[5].getInfoAddr());
            tracker.addReport(this.dataNodes[2].getInfoAddr(), this.dataNodes[3].getInfoAddr());
            tracker.addReport(this.dataNodes[2].getInfoAddr(), this.dataNodes[5].getInfoAddr());
            Thread.sleep(3000L);
            Set slowPeers = this.dnManager.getSlowPeersUuidSet();
            Assert.assertEquals((long)3L, (long)slowPeers.size());
            for (int i = 0; i < slowPeers.size(); ++i) {
                Assert.assertTrue((boolean)slowPeers.contains(this.dataNodes[i].getDatanodeUuid()));
            }
            DatanodeDescriptor writerDn = this.dataNodes[0];
            DatanodeStorageInfo[] targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)3L, (long)targets.length);
            for (int i = 0; i < targets.length; ++i) {
                Assert.assertTrue((!slowPeers.contains(targets[i].getDatanodeDescriptor().getDatanodeUuid()) ? 1 : 0) != 0);
            }
        }
        finally {
            this.namenode.getNamesystem().writeUnlock();
        }
        NameNode.LOG.info("Done working on it");
    }
}

