/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestNoDefaultsJobConf
extends HadoopTestCase {
    public TestNoDefaultsJobConf() throws IOException {
        super(2, 8, 1, 1);
    }

    public void testNoDefaults() throws Exception {
        JobConf configuration = new JobConf();
        TestNoDefaultsJobConf.assertTrue((configuration.get("hadoop.tmp.dir", null) != null ? 1 : 0) != 0);
        configuration = new JobConf(false);
        TestNoDefaultsJobConf.assertTrue((configuration.get("hadoop.tmp.dir", null) == null ? 1 : 0) != 0);
        Path inDir = new Path("testing/jobconf/input");
        Path outDir = new Path("testing/jobconf/output");
        FSDataOutputStream os = this.getFileSystem().create(new Path(inDir, "text.txt"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("hello\n");
        wr.write("hello\n");
        ((Writer)wr).close();
        JobConf conf = new JobConf(false);
        conf.set("fs.defaultFS", this.createJobConf().get("fs.defaultFS"));
        conf.setJobName("mr");
        conf.setInputFormat(TextInputFormat.class);
        conf.setMapOutputKeyClass(LongWritable.class);
        conf.setMapOutputValueClass(Text.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient.runJob((JobConf)conf);
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            int counter = 0;
            while (line != null) {
                ++counter;
                TestNoDefaultsJobConf.assertTrue((boolean)line.contains("hello"));
                line = reader.readLine();
            }
            reader.close();
            TestNoDefaultsJobConf.assertEquals((int)2, (int)counter);
        }
    }
}

