/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AccumulatingReducer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.JHLogAnalyzer;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class JHLogAnalyzer {
    private static final Log LOG = LogFactory.getLog(JHLogAnalyzer.class);
    private static final String JHLA_ROOT_DIR = System.getProperty("test.build.data", "stats/JHLA");
    private static final Path INPUT_DIR = new Path(JHLA_ROOT_DIR, "jhla_input");
    private static final String BASE_INPUT_FILE_NAME = "jhla_in_";
    private static final Path OUTPUT_DIR = new Path(JHLA_ROOT_DIR, "jhla_output");
    private static final Path RESULT_FILE = new Path(JHLA_ROOT_DIR, "jhla_result.txt");
    private static final Path DEFAULT_HISTORY_DIR = new Path("history");
    private static final int DEFAULT_TIME_INTERVAL_MSEC = 3600000;

    private static void createControlFile(FileSystem fs, Path jhLogDir) throws IOException {
        LOG.info((Object)("creating control file: JH log dir = " + jhLogDir));
        FileCreateDaemon.access$300((FileSystem)fs, (Path)jhLogDir);
        LOG.info((Object)("created control file: JH log dir = " + jhLogDir));
    }

    private static String getFileName(int fIdx) {
        return "jhla_in_" + Integer.toString(fIdx);
    }

    private static String[] getKeyValue(String t) throws IOException {
        String[] keyVal = t.split("=\"*|\"");
        return keyVal;
    }

    private static void runJHLA(Class<? extends Mapper<Text, LongWritable, Text, Text>> mapperClass, Path outputDir, Configuration fsConfig) throws IOException {
        JobConf job = new JobConf(fsConfig, JHLogAnalyzer.class);
        job.setPartitionerClass(JHLAPartitioner.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT_DIR});
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(mapperClass);
        job.setReducerClass(AccumulatingReducer.class);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outputDir);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setNumReduceTasks(9);
        JobClient.runJob((JobConf)job);
    }

    public static void main(String[] args) {
        Path resFileName = RESULT_FILE;
        Configuration conf = new Configuration();
        try {
            conf.setInt("test.io.file.buffer.size", 0);
            Path historyDir = DEFAULT_HISTORY_DIR;
            String testFile = null;
            boolean cleanup = false;
            boolean initControlFiles = true;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-historyDir")) {
                    historyDir = new Path(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-resFile")) {
                    resFileName = new Path(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-usersIncluded")) {
                    conf.set("jhla.users.included", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-usersExcluded")) {
                    conf.set("jhla.users.excluded", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-gzip")) {
                    conf.set("jhla.compression.class", GzipCodec.class.getCanonicalName());
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobDelimiter")) {
                    conf.set("jhla.job.delimiter.pattern", args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobDelimiterLength")) {
                    conf.setInt("jhla.job.delimiter.length", Integer.parseInt(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-noInit")) {
                    initControlFiles = false;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-test")) {
                    testFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-clean")) {
                    cleanup = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-jobQueue")) {
                    conf.set("mapred.job.queue.name", args[++i]);
                    continue;
                }
                if (args[i].startsWith("-Xmx")) {
                    conf.set("mapred.child.java.opts", args[i]);
                    continue;
                }
                JHLogAnalyzer.printUsage();
            }
            if (cleanup) {
                JHLogAnalyzer.cleanup((Configuration)conf);
                return;
            }
            if (testFile != null) {
                LOG.info((Object)"Start JHLA test ============ ");
                LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
                conf.set("fs.defaultFS", "file:///");
                JHLAMapper map = new JHLAMapper(conf);
                map.parseLogFile((FileSystem)lfs, new Path(testFile), 0L, (OutputCollector)new LoggingCollector(null), Reporter.NULL);
                return;
            }
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (initControlFiles) {
                JHLogAnalyzer.createControlFile((FileSystem)fs, (Path)historyDir);
            }
            long tStart = System.currentTimeMillis();
            JHLogAnalyzer.runJHLA(JHLAMapper.class, (Path)OUTPUT_DIR, (Configuration)conf);
            long execTime = System.currentTimeMillis() - tStart;
            JHLogAnalyzer.analyzeResult((FileSystem)fs, (int)0, (long)execTime, (Path)resFileName);
        }
        catch (IOException e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            System.exit(-1);
        }
    }

    private static void printUsage() {
        String className = JHLogAnalyzer.class.getSimpleName();
        System.err.println("Usage: " + className + "\n\t[-historyDir inputDir] | [-resFile resultFile] |" + "\n\t[-usersIncluded | -usersExcluded userList] |" + "\n\t[-gzip] | [-jobDelimiter pattern] |" + "\n\t[-help | -clean | -test testFile]");
        System.exit(-1);
    }

    private static Collection<String> getUserList(String users) {
        if (users == null) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(users, ",;");
        ArrayList<String> userList = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            userList.add(tokens.nextToken());
        }
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void analyzeResult(FileSystem fs, int testType, long execTime, Path resFileName) throws IOException {
        LOG.info((Object)"Analyzing results ...");
        DataOutputStream out = null;
        BufferedWriter writer = null;
        try {
            out = new DataOutputStream((OutputStream)fs.create(resFileName));
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write("SERIES\tPERIOD\tTYPE\tSLOT_HOUR\n");
            FileStatus[] reduceFiles = fs.listStatus(OUTPUT_DIR);
            assert (reduceFiles.length == 9);
            for (int i = 0; i < 9; ++i) {
                FSDataInputStream in = null;
                BufferedReader lines = null;
                try {
                    String line;
                    in = fs.open(reduceFiles[i].getPath());
                    lines = new BufferedReader(new InputStreamReader((InputStream)in));
                    while ((line = lines.readLine()) != null) {
                        StringTokenizer tokens = new StringTokenizer(line, "\t*");
                        String attr = tokens.nextToken();
                        String dateTime = tokens.nextToken();
                        String taskType = tokens.nextToken();
                        double val = (double)Long.parseLong(tokens.nextToken()) / 3600000.0;
                        writer.write(attr.substring(2));
                        writer.write("\t");
                        writer.write(dateTime);
                        writer.write("\t");
                        writer.write(taskType);
                        writer.write("\t");
                        writer.write(String.valueOf((float)val));
                        writer.newLine();
                    }
                    continue;
                }
                finally {
                    if (lines != null) {
                        lines.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (out != null) {
                out.close();
            }
        }
        LOG.info((Object)"Analyzing results ... done.");
    }

    private static void cleanup(Configuration conf) throws IOException {
        LOG.info((Object)"Cleaning up test files");
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(JHLA_ROOT_DIR), true);
    }

    static /* synthetic */ String access$000(int x0) {
        return JHLogAnalyzer.getFileName((int)x0);
    }

    static /* synthetic */ Path access$100() {
        return INPUT_DIR;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ String[] access$400(String x0) throws IOException {
        return JHLogAnalyzer.getKeyValue((String)x0);
    }

    static /* synthetic */ Collection access$600(String x0) {
        return JHLogAnalyzer.getUserList((String)x0);
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }
}

