/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.DataWriter;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;

class AppendOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(AppendOp.class);

    AppendOp(ConfigExtractor cfg, Random rnd) {
        super(AppendOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getAppendFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<OperationOutput> run(FileSystem fs) {
        List out = super.run(fs);
        OutputStream os = null;
        try {
            Path fn = this.getAppendFile();
            Range appendSizeRange = this.getConfig().getAppendSize();
            if (this.getConfig().shouldAppendUseBlockSize()) {
                appendSizeRange = this.getConfig().getBlockSize();
            }
            long appendSize = Range.betweenPositive((Random)this.getRandom(), (Range)appendSizeRange);
            long timeTaken = 0L;
            long bytesAppended = 0L;
            DataWriter writer = new DataWriter(this.getRandom());
            LOG.info((Object)("Attempting to append to file at " + fn + " of size " + Helper.toByteInfo((long)appendSize)));
            long startTime = Timer.now();
            os = fs.append(fn);
            timeTaken += Timer.elapsed((long)startTime);
            DataWriter.GenerateOutput stats = writer.writeSegment(appendSize, os);
            timeTaken += stats.getTimeTaken();
            startTime = Timer.now();
            os.close();
            os = null;
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", (Object)(bytesAppended += stats.getBytesWritten())));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)(timeTaken += Timer.elapsed((long)startTime))));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
            LOG.info((Object)("Appended " + Helper.toByteInfo((long)bytesAppended) + " to file " + fn + " in " + timeTaken + " milliseconds"));
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", (Object)1L));
            LOG.warn((Object)"Error with appending", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with appending", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Error with closing append stream", (Throwable)e);
                }
            }
        }
        return out;
    }
}

