/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Timer;

class ListOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(ListOp.class);

    ListOp(ConfigExtractor cfg, Random rnd) {
        super(ListOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getDirectory() {
        Path dir = this.getFinder().getDirectory();
        return dir;
    }

    List<OperationOutput> run(FileSystem fs) {
        List out = super.run(fs);
        try {
            Path dir = this.getDirectory();
            long dirEntries = 0L;
            long timeTaken = 0L;
            long startTime = Timer.now();
            FileStatus[] files = fs.listStatus(dir);
            timeTaken = Timer.elapsed((long)startTime);
            dirEntries = files.length;
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)timeTaken));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "dir_entries", (Object)dirEntries));
            LOG.info((Object)("Directory " + dir + " has " + dirEntries + " entries"));
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", (Object)1L));
            LOG.warn((Object)"Error with listing", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with listing", (Throwable)e);
        }
        return out;
    }
}

