/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;

class SleepOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(SleepOp.class);

    SleepOp(ConfigExtractor cfg, Random rnd) {
        super(SleepOp.class.getSimpleName(), cfg, rnd);
    }

    protected long getSleepTime(Range<Long> sleepTime) {
        long sleepMs = Range.betweenPositive((Random)this.getRandom(), sleepTime);
        return sleepMs;
    }

    List<OperationOutput> run(Range<Long> sleepTime) {
        List out = super.run(null);
        try {
            if (sleepTime != null) {
                long sleepMs = this.getSleepTime(sleepTime);
                long startTime = Timer.now();
                this.sleep(sleepMs);
                long elapsedTime = Timer.elapsed((long)startTime);
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)elapsedTime));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
            }
        }
        catch (InterruptedException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with sleeping", (Throwable)e);
        }
        return out;
    }

    List<OperationOutput> run(FileSystem fs) {
        Range sleepTime = this.getConfig().getSleepRange();
        return this.run(sleepTime);
    }

    private void sleep(long ms) throws InterruptedException {
        if (ms <= 0L) {
            return;
        }
        Thread.sleep(ms);
    }
}

