/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class SortValidator
extends Configured
implements Tool {
    private static final IntWritable sortInput = new IntWritable(1);
    private static final IntWritable sortOutput = new IntWritable(2);
    public static String SORT_REDUCES = "mapreduce.sortvalidator.sort.reduce.tasks";
    public static String MAPS_PER_HOST = "mapreduce.sortvalidator.mapsperhost";
    public static String REDUCES_PER_HOST = "mapreduce.sortvalidator.reducesperhost";
    private static final PathFilter sortPathsFilter = new /* Unavailable Anonymous Inner Class!! */;

    static void printUsage() {
        System.err.println("sortvalidate [-m <maps>] [-r <reduces>] [-deep] -sortInput <sort-input-dir> -sortOutput <sort-output-dir>");
        System.exit(1);
    }

    private static IntWritable deduceInputFile(JobConf job) {
        Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)job);
        Path inputFile = new Path(job.get("mapreduce.map.input.file"));
        return inputFile.getParent().equals((Object)inputPaths[0]) ? sortInput : sortOutput;
    }

    private static byte[] pair(BytesWritable a, BytesWritable b) {
        byte[] pairData = new byte[a.getLength() + b.getLength()];
        System.arraycopy(a.getBytes(), 0, pairData, 0, a.getLength());
        System.arraycopy(b.getBytes(), 0, pairData, a.getLength(), b.getLength());
        return pairData;
    }

    public int run(String[] args) throws Exception {
        Configuration defaults = this.getConf();
        int noMaps = -1;
        int noReduces = -1;
        Path sortInput = null;
        Path sortOutput = null;
        boolean deepTest = false;
        for (int i = 0; i < args.length; ++i) {
            try {
                if ("-m".equals(args[i])) {
                    noMaps = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-r".equals(args[i])) {
                    noReduces = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-sortInput".equals(args[i])) {
                    sortInput = new Path(args[++i]);
                    continue;
                }
                if ("-sortOutput".equals(args[i])) {
                    sortOutput = new Path(args[++i]);
                    continue;
                }
                if ("-deep".equals(args[i])) {
                    deepTest = true;
                    continue;
                }
                SortValidator.printUsage();
                return -1;
            }
            catch (NumberFormatException except) {
                System.err.println("ERROR: Integer expected instead of " + args[i]);
                SortValidator.printUsage();
                return -1;
            }
            catch (ArrayIndexOutOfBoundsException except) {
                System.err.println("ERROR: Required parameter missing from " + args[i - 1]);
                SortValidator.printUsage();
                return -1;
            }
        }
        if (sortInput == null || sortOutput == null) {
            SortValidator.printUsage();
            return -2;
        }
        RecordStatsChecker.checkRecords((Configuration)defaults, sortInput, sortOutput);
        if (deepTest) {
            RecordChecker.checkRecords((Configuration)defaults, (int)noMaps, (int)noReduces, sortInput, sortOutput);
        }
        System.out.println("\nSUCCESS! Validated the MapReduce framework's 'sort' successfully.");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SortValidator(), (String[])args);
        System.exit(res);
    }

    static /* synthetic */ IntWritable access$000(JobConf x0) {
        return SortValidator.deduceInputFile((JobConf)x0);
    }

    static /* synthetic */ IntWritable access$100() {
        return sortOutput;
    }

    static /* synthetic */ PathFilter access$300() {
        return sortPathsFilter;
    }

    static /* synthetic */ byte[] access$400(BytesWritable x0, BytesWritable x1) {
        return SortValidator.pair((BytesWritable)x0, (BytesWritable)x1);
    }

    static /* synthetic */ IntWritable access$500() {
        return sortInput;
    }
}

