/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TestCollect;
import org.apache.hadoop.mapred.UtilsForTests;

public class TestCollect
extends TestCase {
    static final Path OUTPUT_DIR = new Path("build/test/test.collect.output");
    static final int NUM_FEEDERS = 10;
    static final int NUM_COLLECTS_PER_THREAD = 1000;

    public void configure(JobConf conf) throws IOException {
        conf.setJobName("TestCollect");
        conf.setJarByClass(TestCollect.class);
        conf.setInputFormat(UtilsForTests.RandomInputFormat.class);
        conf.setOutputKeyClass(IntWritable.class);
        conf.setOutputValueClass(IntWritable.class);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)OUTPUT_DIR);
        conf.set("mapreduce.framework.name", "local");
        conf.setMapperClass(Map.class);
        conf.setReducerClass(Reduce.class);
        conf.setNumMapTasks(1);
        conf.setNumReduceTasks(1);
    }

    public void testCollect() throws IOException {
        JobConf conf = new JobConf();
        this.configure(conf);
        try {
            JobClient.runJob((JobConf)conf);
            if (Reduce.numSeen != 10000) {
                throw new IOException("Collect test failed!! Total does not match.");
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            FileSystem fs = FileSystem.get((Configuration)conf);
            fs.delete(OUTPUT_DIR, true);
        }
    }

    public static void main(String[] args) throws IOException {
        new TestCollect().testCollect();
    }
}

