/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.TestMapProgress;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.util.ReflectionUtils;

public class TestMapProgress
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestMapProgress.class);
    private static String TEST_ROOT_DIR;
    private FileSystem fs = null;
    private TestMapTask map = null;
    private JobID jobId = null;
    private FakeUmbilical fakeUmbilical = new FakeUmbilical();

    private void createInputFile(Path rootDir) throws IOException {
        if (this.fs.exists(rootDir)) {
            this.fs.delete(rootDir, true);
        }
        String str = "The quick brown fox\nThe brown quick fox\nThe fox brown quick\n";
        FSDataOutputStream inpFile = this.fs.create(new Path(rootDir, "part-0"));
        inpFile.writeBytes(str);
        inpFile.close();
    }

    public void testMapProgress() throws Exception {
        JobConf job = new JobConf();
        this.fs = FileSystem.getLocal((Configuration)job);
        Path rootDir = new Path(TEST_ROOT_DIR);
        this.createInputFile(rootDir);
        job.setNumReduceTasks(0);
        TaskAttemptID taskId = TaskAttemptID.forName((String)"attempt_200907082313_0424_m_000000_0");
        job.setClass("mapreduce.job.outputformat.class", NullOutputFormat.class, OutputFormat.class);
        job.set("mapreduce.input.fileinputformat.inputdir", TEST_ROOT_DIR);
        this.jobId = taskId.getJobID();
        JobContextImpl jContext = new JobContextImpl(job, (org.apache.hadoop.mapreduce.JobID)this.jobId);
        InputFormat input = (InputFormat)ReflectionUtils.newInstance((Class)jContext.getInputFormatClass(), (Configuration)job);
        List splits = input.getSplits((JobContext)jContext);
        JobSplitWriter.createSplitFiles((Path)new Path(TEST_ROOT_DIR), (Configuration)job, (FileSystem)new Path(TEST_ROOT_DIR).getFileSystem((Configuration)job), (List)splits);
        JobSplit.TaskSplitMetaInfo[] splitMetaInfo = SplitMetaInfoReader.readSplitMetaInfo((org.apache.hadoop.mapreduce.JobID)this.jobId, (FileSystem)this.fs, (Configuration)job, (Path)new Path(TEST_ROOT_DIR));
        job.setUseNewMapper(true);
        for (int i = 0; i < splitMetaInfo.length; ++i) {
            this.map = new TestMapTask(this, job.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system") + this.jobId + "job.xml", taskId, i, splitMetaInfo[i].getSplitIndex(), 1);
            JobConf localConf = new JobConf((Configuration)job);
            this.map.localizeConfiguration(localConf);
            this.map.setConf((Configuration)localConf);
            this.map.run(localConf, (TaskUmbilicalProtocol)this.fakeUmbilical);
        }
        this.fs.delete(rootDir, true);
    }

    static /* synthetic */ FakeUmbilical access$000(TestMapProgress x0) {
        return x0.fakeUmbilical;
    }

    static /* synthetic */ TestMapTask access$100(TestMapProgress x0) {
        return x0.map;
    }

    static {
        String root = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        TEST_ROOT_DIR = new Path(root, "mapPhaseprogress").toString();
    }
}

