/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapred.TestTaskCommit;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTaskCommit
extends HadoopTestCase {
    Path rootDir = new Path(System.getProperty("test.build.data", "/tmp"), "test");

    public TestTaskCommit() throws IOException {
        super(1, 4, 1, 1);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        FileUtil.fullyDelete((File)new File(this.rootDir.toString()));
    }

    public void testCommitFail() throws IOException {
        Path inDir = new Path(this.rootDir, "./input");
        Path outDir = new Path(this.rootDir, "./output");
        JobConf jobConf = this.createJobConf();
        jobConf.setMaxMapAttempts(1);
        jobConf.setOutputCommitter(CommitterWithCommitFail.class);
        RunningJob rJob = UtilsForTests.runJob((JobConf)jobConf, (Path)inDir, (Path)outDir, (int)1, (int)0);
        rJob.waitForCompletion();
        TestTaskCommit.assertEquals((int)JobStatus.FAILED, (int)rJob.getJobState());
    }

    public void testTaskCleanupDoesNotCommit() throws Exception {
        JobConf job = new JobConf();
        job.setOutputCommitter(CommitterWithoutCleanup.class);
        Path outDir = new Path(this.rootDir, "output");
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        String dummyAttemptID = "attempt_200707121733_0001_m_000000_0";
        TaskAttemptID attemptID = TaskAttemptID.forName((String)dummyAttemptID);
        CommitterWithoutCleanup committer = new CommitterWithoutCleanup();
        JobContextImpl jContext = new JobContextImpl(job, (org.apache.hadoop.mapreduce.JobID)attemptID.getJobID());
        committer.setupJob((JobContext)jContext);
        dummyAttemptID = "attempt_200707121733_0001_m_000001_0";
        attemptID = TaskAttemptID.forName((String)dummyAttemptID);
        MapTask task = new MapTask(null, attemptID, 0, null, 1);
        task.setConf((Configuration)job);
        task.localizeConfiguration(job);
        task.initialize(job, attemptID.getJobID(), Reporter.NULL, false);
        String file = "test.txt";
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)job);
        TextOutputFormat theOutputFormat = new TextOutputFormat();
        RecordWriter theRecordWriter = theOutputFormat.getRecordWriter((FileSystem)localFs, job, file, (Progressable)Reporter.NULL);
        theRecordWriter.write((Object)new Text("key"), (Object)new Text("value"));
        theRecordWriter.close(Reporter.NULL);
        task.setTaskCleanupTask();
        MyUmbilical umbilical = new MyUmbilical(this, null);
        task.run(job, (TaskUmbilicalProtocol)umbilical);
        TestTaskCommit.assertTrue((String)"Task did not succeed", (boolean)umbilical.taskDone);
    }

    public void testCommitRequiredForMapTask() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        TestTaskCommit.assertTrue((String)"MapTask should need commit", (boolean)testTask.isCommitRequired());
    }

    public void testCommitRequiredForReduceTask() throws Exception {
        Task testTask = this.createDummyTask(TaskType.REDUCE);
        TestTaskCommit.assertTrue((String)"ReduceTask should need commit", (boolean)testTask.isCommitRequired());
    }

    public void testCommitNotRequiredForJobSetup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        testTask.setJobSetupTask();
        TestTaskCommit.assertFalse((String)"Job setup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    public void testCommitNotRequiredForJobCleanup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.MAP);
        testTask.setJobCleanupTask();
        TestTaskCommit.assertFalse((String)"Job cleanup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    public void testCommitNotRequiredForTaskCleanup() throws Exception {
        Task testTask = this.createDummyTask(TaskType.REDUCE);
        testTask.setTaskCleanupTask();
        TestTaskCommit.assertFalse((String)"Task cleanup task should not need commit", (boolean)testTask.isCommitRequired());
    }

    private Task createDummyTask(TaskType type) throws IOException, ClassNotFoundException, InterruptedException {
        JobConf conf = new JobConf();
        conf.setOutputCommitter(CommitterThatAlwaysRequiresCommit.class);
        Path outDir = new Path(this.rootDir, "output");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobID jobId = JobID.forName((String)"job_201002121132_0001");
        Object testTask = type == TaskType.MAP ? new MapTask() : new ReduceTask();
        testTask.setConf((Configuration)conf);
        testTask.initialize(conf, jobId, Reporter.NULL, false);
        return testTask;
    }

    public static void main(String[] argv) throws Exception {
        TestTaskCommit td = new TestTaskCommit();
        td.testCommitFail();
    }
}

