/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TestTextInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTextInputFormat {
    private static final Log LOG = LogFactory.getLog((String)TestTextInputFormat.class.getName());
    private static int MAX_LENGTH = 10000;
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500000L)
    public void testFormat() throws Exception {
        JobConf job = new JobConf((Configuration)defaultConf);
        Path file = new Path(workDir, "test.txt");
        Reporter reporter = Reporter.NULL;
        int seed = new Random().nextInt();
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        for (int length = 0; length < MAX_LENGTH; length += random.nextInt(MAX_LENGTH / 10) + 1) {
            LOG.debug((Object)("creating; entries = " + length));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            TextInputFormat format = new TextInputFormat();
            format.configure(job);
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(MAX_LENGTH / 20) + 1;
                LOG.debug((Object)("splitting: requesting = " + numSplits));
                InputSplit[] splits = format.getSplits(job, numSplits);
                LOG.debug((Object)("splitting: got =        " + splits.length));
                if (length == 0) {
                    Assert.assertEquals((String)"Files of length 0 are not returned from FileInputFormat.getSplits().", (long)1L, (long)splits.length);
                    Assert.assertEquals((String)"Empty file length == 0", (long)0L, (long)splits[0].getLength());
                }
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits[j]));
                    try (RecordReader reader = format.getRecordReader(splits[j], job, reporter);){
                        int count = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            if (bits.get(v)) {
                                LOG.warn((Object)("conflict with " + v + " in split " + j + " at position " + reader.getPos()));
                            }
                            Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++count;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits[j] + " count=" + count));
                        continue;
                    }
                }
                Assert.assertEquals((String)"Some keys in no partition.", (long)length, (long)bits.cardinality());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=900000L)
    public void testSplitableCodecs() throws IOException {
        JobConf conf = new JobConf((Configuration)defaultConf);
        int seed = new Random().nextInt();
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName("org.apache.hadoop.io.compress.BZip2Codec"), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        Path file = new Path(workDir, "test" + codec.getDefaultExtension());
        Reporter reporter = Reporter.NULL;
        LOG.info((Object)("seed = " + seed));
        Random random = new Random(seed);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{workDir});
        int MAX_LENGTH = 500000;
        for (int length = 250000; length < 500000; length += random.nextInt(125000) + 1) {
            LOG.info((Object)("creating; entries = " + length));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)localFs.create(file)));){
                for (int i = 0; i < length; ++i) {
                    writer.write(Integer.toString(i));
                    writer.write("\n");
                }
            }
            TextInputFormat format = new TextInputFormat();
            format.configure(conf);
            LongWritable key = new LongWritable();
            Text value = new Text();
            for (int i = 0; i < 3; ++i) {
                int numSplits = random.nextInt(250) + 1;
                LOG.info((Object)("splitting: requesting = " + numSplits));
                InputSplit[] splits = format.getSplits(conf, numSplits);
                LOG.info((Object)("splitting: got =        " + splits.length));
                BitSet bits = new BitSet(length);
                for (int j = 0; j < splits.length; ++j) {
                    LOG.debug((Object)("split[" + j + "]= " + splits[j]));
                    try (RecordReader reader = format.getRecordReader(splits[j], conf, reporter);){
                        int counter = 0;
                        while (reader.next((Object)key, (Object)value)) {
                            int v = Integer.parseInt(value.toString());
                            LOG.debug((Object)("read " + v));
                            if (bits.get(v)) {
                                LOG.warn((Object)("conflict with " + v + " in split " + j + " at position " + reader.getPos()));
                            }
                            Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                            bits.set(v);
                            ++counter;
                        }
                        if (counter > 0) {
                            LOG.info((Object)("splits[" + j + "]=" + splits[j] + " count=" + counter));
                            continue;
                        }
                        LOG.debug((Object)("splits[" + j + "]=" + splits[j] + " count=" + counter));
                        continue;
                    }
                }
                Assert.assertEquals((String)"Some keys in no partition.", (long)length, (long)bits.cardinality());
            }
        }
    }

    private static LineReader makeStream(String str) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), (Configuration)defaultConf);
    }

    private static LineReader makeStream(String str, int bufsz) throws IOException {
        return new LineReader((InputStream)new ByteArrayInputStream(str.getBytes("UTF-8")), bufsz);
    }

    @Test(timeout=5000L)
    public void testUTF8() throws Exception {
        LineReader in = TestTextInputFormat.makeStream((String)"abcd\u20acbdcd\u20ac");
        Text line = new Text();
        in.readLine(line);
        Assert.assertEquals((String)"readLine changed utf8 characters", (Object)"abcd\u20acbdcd\u20ac", (Object)line.toString());
        in = TestTextInputFormat.makeStream((String)"abc\u200axyz");
        in.readLine(line);
        Assert.assertEquals((String)"split on fake newline", (Object)"abc\u200axyz", (Object)line.toString());
    }

    @Test(timeout=5000L)
    public void testNewLines() throws Exception {
        String STR = "a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee";
        int STRLENBYTES = "a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee".getBytes().length;
        Text out = new Text();
        for (int bufsz = 1; bufsz < STRLENBYTES + 1; ++bufsz) {
            LineReader in = TestTextInputFormat.makeStream((String)"a\nbb\n\nccc\rdddd\r\r\r\n\r\neeeee", (int)bufsz);
            int c = 0;
            c += in.readLine(out);
            Assert.assertEquals((String)("line1 length, bufsz:" + bufsz), (long)1L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line2 length, bufsz:" + bufsz), (long)2L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line3 length, bufsz:" + bufsz), (long)0L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line4 length, bufsz:" + bufsz), (long)3L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line5 length, bufsz:" + bufsz), (long)4L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line6 length, bufsz:" + bufsz), (long)0L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line7 length, bufsz:" + bufsz), (long)0L, (long)out.getLength());
            c += in.readLine(out);
            Assert.assertEquals((String)("line8 length, bufsz:" + bufsz), (long)0L, (long)out.getLength());
            Assert.assertEquals((String)("line9 length, bufsz:" + bufsz), (long)5L, (long)out.getLength());
            Assert.assertEquals((String)("end of file, bufsz: " + bufsz), (long)0L, (long)in.readLine(out));
            Assert.assertEquals((String)("total bytes, bufsz: " + bufsz), (long)(c += in.readLine(out)), (long)STRLENBYTES);
        }
    }

    @Test(timeout=5000L)
    public void testMaxLineLength() throws Exception {
        String STR = "a\nbb\n\nccc\rdddd\r\neeeee";
        int STRLENBYTES = "a\nbb\n\nccc\rdddd\r\neeeee".getBytes().length;
        Text out = new Text();
        for (int bufsz = 1; bufsz < STRLENBYTES + 1; ++bufsz) {
            LineReader in = TestTextInputFormat.makeStream((String)"a\nbb\n\nccc\rdddd\r\neeeee", (int)bufsz);
            int c = 0;
            c += in.readLine(out, 1);
            Assert.assertEquals((String)("line1 length, bufsz: " + bufsz), (long)1L, (long)out.getLength());
            c += in.readLine(out, 1);
            Assert.assertEquals((String)("line2 length, bufsz: " + bufsz), (long)1L, (long)out.getLength());
            c += in.readLine(out, 1);
            Assert.assertEquals((String)("line3 length, bufsz: " + bufsz), (long)0L, (long)out.getLength());
            c += in.readLine(out, 3);
            Assert.assertEquals((String)("line4 length, bufsz: " + bufsz), (long)3L, (long)out.getLength());
            c += in.readLine(out, 10);
            Assert.assertEquals((String)("line5 length, bufsz: " + bufsz), (long)4L, (long)out.getLength());
            Assert.assertEquals((String)("line5 length, bufsz: " + bufsz), (long)5L, (long)out.getLength());
            Assert.assertEquals((String)("end of file, bufsz: " + bufsz), (long)0L, (long)in.readLine(out));
            Assert.assertEquals((String)("total bytes, bufsz: " + bufsz), (long)(c += in.readLine(out, 8)), (long)STRLENBYTES);
        }
    }

    @Test(timeout=5000L)
    public void testMRMaxLine() throws Exception {
        int MAXPOS = 0x100000;
        int MAXLINE = 10240;
        int BUF = 65536;
        1 infNull = new /* Unavailable Anonymous Inner Class!! */;
        LongWritable key = new LongWritable();
        Text val = new Text();
        LOG.info((Object)"Reading a line from /dev/null");
        Configuration conf = new Configuration(false);
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", 10240);
        conf.setInt("io.file.buffer.size", 65536);
        LineRecordReader lrr = new LineRecordReader((InputStream)infNull, 0L, 0x100000L, conf);
        Assert.assertFalse((String)"Read a line from null", (boolean)lrr.next(key, val));
        infNull.reset();
        lrr = new LineRecordReader((InputStream)infNull, 0L, 10240L, 0x100000);
        Assert.assertFalse((String)"Read a line from null", (boolean)lrr.next(key, val));
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(TextInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        reader.close();
        return result;
    }

    @Test(timeout=5000L)
    public void testGzip() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, (String)"the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        TestTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, (String)"this is a test\nof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List results = TestTextInputFormat.readSplit((TextInputFormat)format, (InputSplit)splits[0], (JobConf)job);
        Assert.assertEquals((String)"splits[0] length", (long)6L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)" dog", (Object)((Text)results.get(5)).toString());
        results = TestTextInputFormat.readSplit((TextInputFormat)format, (InputSplit)splits[1], (JobConf)job);
        Assert.assertEquals((String)"splits[1] length", (long)2L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"this is a test", (Object)((Text)results.get(0)).toString());
        Assert.assertEquals((String)"splits[1][1]", (Object)"of gzip", (Object)((Text)results.get(1)).toString());
    }

    @Test(timeout=5000L)
    public void testGzipEmpty() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "empty.gz"), (CompressionCodec)gzip, (String)"");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        TextInputFormat format = new TextInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 100);
        Assert.assertEquals((String)"Compressed files of length 0 are not returned from FileInputFormat.getSplits().", (long)1L, (long)splits.length);
        List results = TestTextInputFormat.readSplit((TextInputFormat)format, (InputSplit)splits[0], (JobConf)job);
        Assert.assertEquals((String)"Compressed empty file length == 0", (long)0L, (long)results.size());
    }

    private static String unquote(String in) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                ch = in.charAt(++i);
                switch (ch) {
                    case 'n': {
                        result.append('\n');
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        break;
                    }
                    default: {
                        result.append(ch);
                        break;
                    }
                }
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            System.out.println("Working on " + arg);
            LineReader reader = TestTextInputFormat.makeStream((String)TestTextInputFormat.unquote((String)arg));
            Text line = new Text();
            int size = reader.readLine(line);
            while (size > 0) {
                System.out.println("Got: " + line.toString());
                size = reader.readLine(line);
            }
            reader.close();
        }
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestTextInputFormat").makeQualified(localFs);
        voidReporter = Reporter.NULL;
    }
}

