/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.lib;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.ChainMapper;
import org.apache.hadoop.mapred.lib.ChainReducer;
import org.apache.hadoop.mapred.lib.TestChainMapReduce;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestChainMapReduce
extends HadoopTestCase {
    private static Path getFlagDir(boolean local) {
        Path flagDir = new Path("testing/chain/flags");
        if (local) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            flagDir = new Path(localPathRoot, flagDir);
        }
        return flagDir;
    }

    private static void cleanFlags(JobConf conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(TestChainMapReduce.getFlagDir((boolean)conf.getBoolean("localFS", true)), true);
        fs.mkdirs(TestChainMapReduce.getFlagDir((boolean)conf.getBoolean("localFS", true)));
    }

    private static void writeFlag(JobConf conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (TestChainMapReduce.getFlag((JobConf)conf, (String)flag)) {
            TestChainMapReduce.fail((String)("Flag " + flag + " already exists"));
        }
        FSDataOutputStream file = fs.create(new Path(TestChainMapReduce.getFlagDir((boolean)conf.getBoolean("localFS", true)), flag));
        file.close();
    }

    private static boolean getFlag(JobConf conf, String flag) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        return fs.exists(new Path(TestChainMapReduce.getFlagDir((boolean)conf.getBoolean("localFS", true)), flag));
    }

    public TestChainMapReduce() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testChain() throws Exception {
        Path inDir = new Path("testing/chain/input");
        Path outDir = new Path("testing/chain/output");
        if (this.isLocalFS()) {
            String localPathRoot = System.getProperty("test.build.data", "/tmp").replace(' ', '+');
            inDir = new Path(localPathRoot, inDir);
            outDir = new Path(localPathRoot, outDir);
        }
        JobConf conf = this.createJobConf();
        conf.setBoolean("localFS", this.isLocalFS());
        conf.setInt("mapreduce.job.maps", 1);
        TestChainMapReduce.cleanFlags((JobConf)conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("1\n2\n");
        file.close();
        conf.setJobName("chain");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(TextOutputFormat.class);
        conf.set("a", "X");
        JobConf mapAConf = new JobConf(false);
        mapAConf.set("a", "A");
        ChainMapper.addMapper((JobConf)conf, AMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)mapAConf);
        ChainMapper.addMapper((JobConf)conf, BMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)false, null);
        JobConf reduceConf = new JobConf(false);
        reduceConf.set("a", "C");
        ChainReducer.setReducer((JobConf)conf, CReduce.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)reduceConf);
        ChainReducer.addMapper((JobConf)conf, DMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)false, null);
        JobConf mapEConf = new JobConf(false);
        mapEConf.set("a", "E");
        ChainReducer.addMapper((JobConf)conf, EMap.class, LongWritable.class, Text.class, LongWritable.class, Text.class, (boolean)true, (JobConf)mapEConf);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        JobClient jc = new JobClient(conf);
        RunningJob job = jc.submitJob(conf);
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"configure.A"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"configure.B"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"configure.C"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"configure.D"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"configure.E"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.A.value.1"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.A.value.2"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.B.value.1"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.B.value.2"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"reduce.C.value.2"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"reduce.C.value.1"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.D.value.1"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.D.value.2"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.E.value.1"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"map.E.value.2"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"close.A"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"close.B"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"close.C"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"close.D"));
        TestChainMapReduce.assertTrue((boolean)TestChainMapReduce.getFlag((JobConf)conf, (String)"close.E"));
    }

    static /* synthetic */ void access$000(JobConf x0, String x1) throws IOException {
        TestChainMapReduce.writeFlag((JobConf)x0, (String)x1);
    }
}

