/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.lib.partition.BinaryPartitioner;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestBinaryPartitioner
extends TestCase {
    public void testDefaultOffsets() {
        Configuration conf = new Configuration();
        BinaryPartitioner partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        int partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        int partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        key2 = new BytesWritable(new byte[]{6, 2, 3, 4, 5});
        partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
        key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 6});
        partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }

    public void testCustomOffsets() {
        Configuration conf = new Configuration();
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{6, 2, 3, 7, 8});
        BinaryPartitioner.setOffsets((Configuration)conf, (int)1, (int)-3);
        BinaryPartitioner partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        int partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        int partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        BinaryPartitioner.setOffsets((Configuration)conf, (int)1, (int)2);
        partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
        BinaryPartitioner.setOffsets((Configuration)conf, (int)-4, (int)-3);
        partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertEquals((int)partition1, (int)partition2);
    }

    public void testLowerBound() {
        Configuration conf = new Configuration();
        BinaryPartitioner.setLeftOffset((Configuration)conf, (int)0);
        BinaryPartitioner partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{6, 2, 3, 4, 5});
        int partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        int partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }

    public void testUpperBound() {
        Configuration conf = new Configuration();
        BinaryPartitioner.setRightOffset((Configuration)conf, (int)4);
        BinaryPartitioner partitioner = (BinaryPartitioner)ReflectionUtils.newInstance(BinaryPartitioner.class, (Configuration)conf);
        BytesWritable key1 = new BytesWritable(new byte[]{1, 2, 3, 4, 5});
        BytesWritable key2 = new BytesWritable(new byte[]{1, 2, 3, 4, 6});
        int partition1 = partitioner.getPartition((BinaryComparable)key1, null, 10);
        int partition2 = partitioner.getPartition((BinaryComparable)key2, null, 10);
        TestBinaryPartitioner.assertTrue((partition1 != partition2 ? 1 : 0) != 0);
    }
}

