/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.security.CredentialsTestJob;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class CredentialsTestJob
extends Configured
implements Tool {
    private static final int NUM_OF_KEYS = 10;

    private static void checkSecrets(Credentials ts) {
        if (ts == null) {
            throw new RuntimeException("The credentials are not available");
        }
        for (int i = 0; i < 10; ++i) {
            String secretName = "alias" + i;
            byte[] secretValue = ts.getSecretKey(new Text(secretName));
            System.out.println(secretValue);
            if (secretValue == null) {
                throw new RuntimeException("The key " + secretName + " is not available. ");
            }
            String secretValueStr = new String(secretValue);
            if (("password" + i).equals(secretValueStr)) continue;
            throw new RuntimeException("The key " + secretName + " is not correct. Expected value is " + "password" + i + ". Actual value is " + secretValueStr);
        }
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new CredentialsTestJob(), (String[])args);
        System.exit(res);
    }

    public Job createJob() throws IOException {
        Configuration conf = this.getConf();
        conf.setInt("mapreduce.job.maps", 1);
        Job job = Job.getInstance((Configuration)conf, (String)"test");
        job.setNumReduceTasks(1);
        job.setJarByClass(CredentialsTestJob.class);
        job.setNumReduceTasks(1);
        job.setMapperClass(CredentialsTestMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(CredentialsTestReducer.class);
        job.setInputFormatClass(SleepJob.SleepInputFormat.class);
        job.setPartitionerClass(SleepJob.SleepJobPartitioner.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setSpeculativeExecution(false);
        job.setJobName("test job");
        FileInputFormat.addInputPath((Job)job, (Path)new Path("ignored"));
        return job;
    }

    public int run(String[] args) throws Exception {
        Job job = this.createJob();
        return job.waitForCompletion(true) ? 0 : 1;
    }

    static /* synthetic */ void access$000(Credentials x0) {
        CredentialsTestJob.checkSecrets((Credentials)x0);
    }
}

