/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FadvisedChunkedFile;
import org.apache.hadoop.mapred.FadvisedFileRegion;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.proto.ShuffleHandlerRecoveryProtos;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.eclipse.jetty.http.HttpHeader;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Options;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.CharsetUtil;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleHandler
extends AuxiliaryService {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleHandler.class);
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)(ShuffleHandler.class.getName() + ".audit"));
    public static final String SHUFFLE_MANAGE_OS_CACHE = "mapreduce.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_READAHEAD_BYTES = "mapreduce.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    public static final String MAX_WEIGHT = "mapreduce.shuffle.pathcache.max-weight";
    public static final int DEFAULT_MAX_WEIGHT = 0xA00000;
    public static final String EXPIRE_AFTER_ACCESS_MINUTES = "mapreduce.shuffle.pathcache.expire-after-access-minutes";
    public static final int DEFAULT_EXPIRE_AFTER_ACCESS_MINUTES = 5;
    public static final String CONCURRENCY_LEVEL = "mapreduce.shuffle.pathcache.concurrency-level";
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private static final String STATE_DB_NAME = "mapreduce_shuffle_state";
    private static final String STATE_DB_SCHEMA_VERSION_KEY = "shuffle-schema-version";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    private static final String DATA_FILE_NAME = "file.out";
    private static final String INDEX_FILE_NAME = "file.out.index";
    public static final HttpResponseStatus TOO_MANY_REQ_STATUS = new HttpResponseStatus(429, "TOO MANY REQUESTS");
    public static final long FETCH_RETRY_DELAY = 1000L;
    public static final String RETRY_AFTER_HEADER = "Retry-After";
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    protected HttpPipelineFactory pipelineFact;
    private int sslFileBufferSize;
    private boolean manageOsCache;
    private int readaheadLength;
    private int maxShuffleConnections;
    private int shuffleBufferSize;
    private boolean shuffleTransferToAllowed;
    private int maxSessionOpenFiles;
    private ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    private Map<String, String> userRsrc;
    private JobTokenSecretManager secretManager;
    private DB stateDb = null;
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce_shuffle";
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 13562;
    public static final String SHUFFLE_LISTEN_QUEUE_SIZE = "mapreduce.shuffle.listen.queue.size";
    public static final int DEFAULT_SHUFFLE_LISTEN_QUEUE_SIZE = 128;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = "mapreduce.shuffle.connection-keep-alive.enable";
    public static final boolean DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED = false;
    public static final String SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = "mapreduce.shuffle.connection-keep-alive.timeout";
    public static final int DEFAULT_SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT = 5;
    public static final String SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = "mapreduce.shuffle.mapoutput-info.meta.cache.size";
    public static final int DEFAULT_SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE = 1000;
    public static final String CONNECTION_CLOSE = "close";
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "mapreduce.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    public static final String SHUFFLE_BUFFER_SIZE = "mapreduce.shuffle.transfer.buffer.size";
    public static final int DEFAULT_SHUFFLE_BUFFER_SIZE = 131072;
    public static final String SHUFFLE_TRANSFERTO_ALLOWED = "mapreduce.shuffle.transferTo.allowed";
    public static final boolean DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = true;
    public static final boolean WINDOWS_DEFAULT_SHUFFLE_TRANSFERTO_ALLOWED = false;
    private static final String TIMEOUT_HANDLER = "timeout";
    public static final String SHUFFLE_MAX_SESSION_OPEN_FILES = "mapreduce.shuffle.max.session-open-files";
    public static final int DEFAULT_SHUFFLE_MAX_SESSION_OPEN_FILES = 3;
    boolean connectionKeepAliveEnabled = false;
    private int connectionKeepAliveTimeOut;
    private int mapOutputMetaInfoCacheSize;
    private Timer timer;
    private final MetricsSystem ms;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super(MAPREDUCE_SHUFFLE_SERVICEID);
        this.ms = ms;
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String user = context.getUser();
        ApplicationId appId = context.getApplicationId();
        ByteBuffer secret = context.getApplicationDataForService();
        try {
            Token<JobTokenIdentifier> jt = ShuffleHandler.deserializeServiceData(secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            this.recordJobShuffleInfo(jobId, user, jt);
        }
        catch (IOException e) {
            LOG.error("Error during initApp", (Throwable)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        ApplicationId appId = context.getApplicationId();
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        try {
            this.removeJobShuffleInfo(jobId);
        }
        catch (IOException e) {
            LOG.error("Error during stopApp", (Throwable)e);
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.manageOsCache = conf.getBoolean(SHUFFLE_MANAGE_OS_CACHE, true);
        this.readaheadLength = conf.getInt(SHUFFLE_READAHEAD_BYTES, 0x400000);
        this.maxShuffleConnections = conf.getInt(MAX_SHUFFLE_CONNECTIONS, 0);
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        this.shuffleBufferSize = conf.getInt(SHUFFLE_BUFFER_SIZE, 131072);
        this.shuffleTransferToAllowed = conf.getBoolean(SHUFFLE_TRANSFERTO_ALLOWED, !Shell.WINDOWS);
        this.maxSessionOpenFiles = conf.getInt(SHUFFLE_MAX_SESSION_OPEN_FILES, 3);
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)HadoopExecutors.newCachedThreadPool((ThreadFactory)bossFactory), (Executor)HadoopExecutors.newCachedThreadPool((ThreadFactory)workerFactory), maxShuffleThreads);
        super.serviceInit(new Configuration(conf));
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        this.userRsrc = new ConcurrentHashMap<String, String>();
        this.secretManager = new JobTokenSecretManager();
        this.recoverState(conf);
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        this.timer = new HashedWheelTimer();
        try {
            this.pipelineFact = new HttpPipelineFactory(conf, this.timer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        bootstrap.setOption("backlog", (Object)conf.getInt(SHUFFLE_LISTEN_QUEUE_SIZE, 128));
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFact);
        this.port = conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 13562);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        this.pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info(this.getName() + " listening on port " + this.port);
        super.serviceStart();
        this.sslFileBufferSize = conf.getInt(SUFFLE_SSL_FILE_BUFFER_SIZE_KEY, 61440);
        this.connectionKeepAliveEnabled = conf.getBoolean(SHUFFLE_CONNECTION_KEEP_ALIVE_ENABLED, false);
        this.connectionKeepAliveTimeOut = Math.max(1, conf.getInt(SHUFFLE_CONNECTION_KEEP_ALIVE_TIME_OUT, 5));
        this.mapOutputMetaInfoCacheSize = Math.max(1, conf.getInt(SHUFFLE_MAPOUTPUT_META_INFO_CACHE_SIZE, 1000));
    }

    protected void serviceStop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.selector != null) {
            ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
            bootstrap.releaseExternalResources();
        }
        if (this.pipelineFact != null) {
            this.pipelineFact.destroy();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.stateDb != null) {
            this.stateDb.close();
        }
        this.ms.unregisterSource(ShuffleMetrics.class.getSimpleName());
        super.serviceStop();
    }

    public synchronized ByteBuffer getMetaData() {
        try {
            return ShuffleHandler.serializeMetaData(this.port);
        }
        catch (IOException e) {
            LOG.error("Error during getMeta", (Throwable)e);
            return null;
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return new Shuffle(conf);
    }

    private void recoverState(Configuration conf) throws IOException {
        Path recoveryRoot = this.getRecoveryPath();
        if (recoveryRoot != null) {
            this.startStore(recoveryRoot);
            Pattern jobPattern = Pattern.compile("job_[0-9]+_[0-9]+");
            try (LeveldbIterator iter = null;){
                iter = new LeveldbIterator(this.stateDb);
                iter.seek(JniDBFactory.bytes((String)"job"));
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                    if (!jobPattern.matcher(key).matches()) {
                        break;
                    }
                    this.recoverJobShuffleInfo(key, (byte[])entry.getValue());
                }
            }
        }
    }

    private void startStore(Path recoveryRoot) throws IOException {
        Options options = new Options();
        options.createIfMissing(false);
        Path dbPath = new Path(recoveryRoot, STATE_DB_NAME);
        LOG.info("Using state database at " + dbPath + " for recovery");
        File dbfile = new File(dbPath.toString());
        try {
            this.stateDb = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info("Creating state database at " + dbfile);
                options.createIfMissing(true);
                try {
                    this.stateDb = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            throw e;
        }
        this.checkVersion();
    }

    @VisibleForTesting
    Version loadVersion() throws IOException {
        byte[] data = this.stateDb.get(JniDBFactory.bytes((String)STATE_DB_SCHEMA_VERSION_KEY));
        if (data == null || data.length == 0) {
            return this.getCurrentVersion();
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        return version;
    }

    private void storeSchemaVersion(Version version) throws IOException {
        String key = STATE_DB_SCHEMA_VERSION_KEY;
        byte[] data = ((VersionPBImpl)version).getProto().toByteArray();
        try {
            this.stateDb.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void storeVersion() throws IOException {
        this.storeSchemaVersion(CURRENT_VERSION_INFO);
    }

    @VisibleForTesting
    void storeVersion(Version version) throws IOException {
        this.storeSchemaVersion(version);
    }

    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info("Loaded state DB schema version info " + loadedVersion);
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new IOException("Incompatible version for state DB schema: expecting DB schema version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing state DB schema version info " + this.getCurrentVersion());
        this.storeVersion();
    }

    private void addJobToken(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) {
        this.userRsrc.put(jobId.toString(), user);
        this.secretManager.addTokenForJob(jobId.toString(), jobToken);
        LOG.info("Added token for " + jobId.toString());
    }

    private void recoverJobShuffleInfo(String jobIdStr, byte[] data) throws IOException {
        JobID jobId;
        try {
            jobId = JobID.forName((String)jobIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Bad job ID " + jobIdStr + " in state store", e);
        }
        ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.parseFrom(data);
        String user = proto.getUser();
        SecurityProtos.TokenProto tokenProto = proto.getJobToken();
        Token jobToken = new Token(tokenProto.getIdentifier().toByteArray(), tokenProto.getPassword().toByteArray(), new Text(tokenProto.getKind()), new Text(tokenProto.getService()));
        this.addJobToken(jobId, user, (Token<JobTokenIdentifier>)jobToken);
    }

    private void recordJobShuffleInfo(JobID jobId, String user, Token<JobTokenIdentifier> jobToken) throws IOException {
        if (this.stateDb != null) {
            SecurityProtos.TokenProto tokenProto = SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])jobToken.getIdentifier())).setPassword(ByteString.copyFrom((byte[])jobToken.getPassword())).setKind(jobToken.getKind().toString()).setService(jobToken.getService().toString()).build();
            ShuffleHandlerRecoveryProtos.JobShuffleInfoProto proto = ShuffleHandlerRecoveryProtos.JobShuffleInfoProto.newBuilder().setUser(user).setJobToken(tokenProto).build();
            try {
                this.stateDb.put(JniDBFactory.bytes((String)jobId.toString()), proto.toByteArray());
            }
            catch (DBException e) {
                throw new IOException("Error storing " + jobId, e);
            }
        }
        this.addJobToken(jobId, user, jobToken);
    }

    private void removeJobShuffleInfo(JobID jobId) throws IOException {
        String jobIdStr = jobId.toString();
        this.secretManager.removeTokenForJob(jobIdStr);
        this.userRsrc.remove(jobIdStr);
        if (this.stateDb != null) {
            try {
                this.stateDb.delete(JniDBFactory.bytes((String)jobIdStr));
            }
            catch (DBException e) {
                throw new IOException("Unable to remove " + jobId + " from state store", e);
            }
        }
    }

    static class AttemptPathIdentifier {
        private final String jobId;
        private final String user;
        private final String attemptId;

        public AttemptPathIdentifier(String jobId, String user, String attemptId) {
            this.jobId = jobId;
            this.user = user;
            this.attemptId = attemptId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttemptPathIdentifier that = (AttemptPathIdentifier)o;
            if (!this.attemptId.equals(that.attemptId)) {
                return false;
            }
            return this.jobId.equals(that.jobId);
        }

        public int hashCode() {
            int result = this.jobId.hashCode();
            result = 31 * result + this.attemptId.hashCode();
            return result;
        }

        public String toString() {
            return "AttemptPathIdentifier{attemptId='" + this.attemptId + '\'' + ", jobId='" + this.jobId + '\'' + '}';
        }
    }

    static class AttemptPathInfo {
        private final Path indexPath;
        private final Path dataPath;

        public AttemptPathInfo(Path indexPath, Path dataPath) {
            this.indexPath = indexPath;
            this.dataPath = dataPath;
        }
    }

    class Shuffle
    extends SimpleChannelUpstreamHandler {
        private final IndexCache indexCache;
        private final LoadingCache<AttemptPathIdentifier, AttemptPathInfo> pathCache;
        private int port;

        Shuffle(Configuration conf) {
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 13562);
            this.indexCache = new IndexCache(new JobConf(conf));
            this.pathCache = CacheBuilder.newBuilder().expireAfterAccess((long)conf.getInt(ShuffleHandler.EXPIRE_AFTER_ACCESS_MINUTES, 5), TimeUnit.MINUTES).softValues().concurrencyLevel(conf.getInt(ShuffleHandler.CONCURRENCY_LEVEL, 16)).removalListener(notification -> LOG.debug("PathCache Eviction: {}, Reason={}", notification.getKey(), (Object)notification.getCause())).maximumWeight((long)conf.getInt(ShuffleHandler.MAX_WEIGHT, 0xA00000)).weigher((key, value) -> ((AttemptPathIdentifier)key).jobId.length() + ((AttemptPathIdentifier)key).user.length() + ((AttemptPathIdentifier)key).attemptId.length() + ((AttemptPathInfo)value).indexPath.toString().length() + ((AttemptPathInfo)value).dataPath.toString().length()).build((CacheLoader)new CacheLoader<AttemptPathIdentifier, AttemptPathInfo>(){

                public AttemptPathInfo load(AttemptPathIdentifier key) throws Exception {
                    String base = Shuffle.this.getBaseLocation(key.jobId, key.user);
                    String attemptBase = base + key.attemptId;
                    Path indexFileName = ShuffleHandler.this.getAuxiliaryLocalPathHandler().getLocalPathForRead(attemptBase + "/" + ShuffleHandler.INDEX_FILE_NAME);
                    Path mapOutputFileName = ShuffleHandler.this.getAuxiliaryLocalPathHandler().getLocalPathForRead(attemptBase + "/" + ShuffleHandler.DATA_FILE_NAME);
                    LOG.debug("Loaded : {} via loader", (Object)key);
                    return new AttemptPathInfo(indexFileName, mapOutputFileName);
                }
            });
        }

        public void setPort(int port) {
            this.port = port;
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
            super.channelOpen(ctx, evt);
            if (ShuffleHandler.this.maxShuffleConnections > 0 && ShuffleHandler.this.accepted.size() >= ShuffleHandler.this.maxShuffleConnections) {
                LOG.info(String.format("Current number of shuffle connections (%d) is greater than or equal to the max allowed shuffle connections (%d)", ShuffleHandler.this.accepted.size(), ShuffleHandler.this.maxShuffleConnections));
                HashMap<String, String> headers = new HashMap<String, String>(1);
                headers.put(ShuffleHandler.RETRY_AFTER_HEADER, String.valueOf(1000L));
                this.sendError(ctx, "", TOO_MANY_REQ_STATUS, headers);
                return;
            }
            ShuffleHandler.this.accepted.add((Object)evt.getChannel());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)evt.getMessage();
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (!"mapreduce".equals(request.headers() != null ? request.headers().get("name") : null) || !"1.0.0".equals(request.headers() != null ? request.headers().get("version") : null)) {
                this.sendError(ctx, "Incompatible shuffle request version", HttpResponseStatus.BAD_REQUEST);
            }
            Map q = new QueryStringDecoder(request.getUri()).getParameters();
            List keepAliveList = (List)q.get("keepAlive");
            boolean keepAliveParam = false;
            if (keepAliveList != null && keepAliveList.size() == 1) {
                keepAliveParam = Boolean.valueOf((String)keepAliveList.get(0));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("KeepAliveParam : " + keepAliveList + " : " + keepAliveParam);
                }
            }
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            if (LOG.isDebugEnabled()) {
                LOG.debug("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ + "\n  keepAlive: " + keepAliveParam);
            }
            if (mapIds == null || reduceQ == null || jobQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn("Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            HashMap<String, MapOutputInfo> mapOutputInfoMap = new HashMap<String, MapOutputInfo>();
            Channel ch = evt.getChannel();
            ChannelPipeline pipeline = ch.getPipeline();
            TimeoutHandler timeoutHandler = (TimeoutHandler)pipeline.get(ShuffleHandler.TIMEOUT_HANDLER);
            timeoutHandler.setEnabledTimeout(false);
            String user = (String)ShuffleHandler.this.userRsrc.get(jobId);
            try {
                this.populateHeaders(mapIds, jobId, user, reduceId, request, (HttpResponse)response, keepAliveParam, mapOutputInfoMap);
            }
            catch (IOException e) {
                ch.write((Object)response);
                LOG.error("Shuffle error in populating headers :", (Throwable)e);
                String errorMessage = this.getErrorMessage(e);
                this.sendError(ctx, errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                return;
            }
            ch.write((Object)response);
            boolean keepAlive = keepAliveParam || ShuffleHandler.this.connectionKeepAliveEnabled;
            ReduceContext reduceContext = new ReduceContext(mapIds, reduceId, ctx, user, mapOutputInfoMap, jobId, keepAlive);
            for (int i = 0; i < Math.min(ShuffleHandler.this.maxSessionOpenFiles, mapIds.size()); ++i) {
                ChannelFuture nextMap = this.sendMap(reduceContext);
                if (nextMap != null) continue;
                return;
            }
        }

        public ChannelFuture sendMap(ReduceContext reduceContext) throws Exception {
            ChannelFuture nextMap = null;
            if (reduceContext.getMapsToSend().get() < reduceContext.getMapIds().size()) {
                int nextIndex = reduceContext.getMapsToSend().getAndIncrement();
                String mapId = reduceContext.getMapIds().get(nextIndex);
                try {
                    MapOutputInfo info = reduceContext.getInfoMap().get(mapId);
                    if (info == null) {
                        info = this.getMapOutputInfo(mapId, reduceContext.getReduceId(), reduceContext.getJobId(), reduceContext.getUser());
                    }
                    if (null == (nextMap = this.sendMapOutput(reduceContext.getCtx(), reduceContext.getCtx().getChannel(), reduceContext.getUser(), mapId, reduceContext.getReduceId(), info))) {
                        this.sendError(reduceContext.getCtx(), HttpResponseStatus.NOT_FOUND);
                        return null;
                    }
                    nextMap.addListener((ChannelFutureListener)new ReduceMapFileCount(reduceContext));
                }
                catch (IOException e) {
                    if (e instanceof DiskChecker.DiskErrorException) {
                        LOG.error("Shuffle error :" + e);
                    } else {
                        LOG.error("Shuffle error :", (Throwable)e);
                    }
                    String errorMessage = this.getErrorMessage(e);
                    this.sendError(reduceContext.getCtx(), errorMessage, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return null;
                }
            }
            return nextMap;
        }

        private String getErrorMessage(Throwable t) {
            StringBuffer sb = new StringBuffer(t.getMessage());
            while (t.getCause() != null) {
                sb.append(t.getCause().getMessage());
                t = t.getCause();
            }
            return sb.toString();
        }

        private String getBaseLocation(String jobId, String user) {
            JobID jobID = JobID.forName((String)jobId);
            ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(jobID.getJtIdentifier()), (int)jobID.getId());
            String baseStr = "usercache/" + user + "/" + "appcache" + "/" + appID.toString() + "/output/";
            return baseStr;
        }

        protected MapOutputInfo getMapOutputInfo(String mapId, int reduce, String jobId, String user) throws IOException {
            AttemptPathInfo pathInfo;
            try {
                AttemptPathIdentifier identifier = new AttemptPathIdentifier(jobId, user, mapId);
                pathInfo = (AttemptPathInfo)this.pathCache.get((Object)identifier);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Retrieved pathInfo for " + identifier + " check for corresponding loaded messages to determine whether it was loaded or cached");
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            IndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, pathInfo.indexPath, user);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getMapOutputInfo: jobId=" + jobId + ", mapId=" + mapId + ",dataFile=" + pathInfo.dataPath + ", indexFile=" + pathInfo.indexPath);
            }
            MapOutputInfo outputInfo = new MapOutputInfo(pathInfo.dataPath, info);
            return outputInfo;
        }

        protected void populateHeaders(List<String> mapIds, String jobId, String user, int reduce, HttpRequest request, HttpResponse response, boolean keepAliveParam, Map<String, MapOutputInfo> mapOutputInfoMap) throws IOException {
            long contentLength = 0L;
            for (String mapId : mapIds) {
                MapOutputInfo outputInfo = this.getMapOutputInfo(mapId, reduce, jobId, user);
                if (mapOutputInfoMap.size() < ShuffleHandler.this.mapOutputMetaInfoCacheSize) {
                    mapOutputInfoMap.put(mapId, outputInfo);
                }
                ShuffleHeader header = new ShuffleHeader(mapId, outputInfo.indexRecord.partLength, outputInfo.indexRecord.rawLength, reduce);
                DataOutputBuffer dob = new DataOutputBuffer();
                header.write((DataOutput)dob);
                contentLength += outputInfo.indexRecord.partLength;
                contentLength += (long)dob.getLength();
            }
            this.setResponseHeaders(response, keepAliveParam, contentLength);
            if (AUDITLOG.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder("shuffle for ");
                sb.append(jobId).append(" reducer ").append(reduce);
                sb.append(" length ").append(contentLength);
                sb.append(" mappers: ").append(mapIds);
                AUDITLOG.debug(sb.toString());
            }
        }

        protected void setResponseHeaders(HttpResponse response, boolean keepAliveParam, long contentLength) {
            if (!ShuffleHandler.this.connectionKeepAliveEnabled && !keepAliveParam) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Setting connection close header...");
                }
                response.headers().set(HttpHeader.CONNECTION.asString(), (Object)ShuffleHandler.CONNECTION_CLOSE);
            } else {
                response.headers().set(HttpHeader.CONTENT_LENGTH.asString(), (Object)String.valueOf(contentLength));
                response.headers().set(HttpHeader.CONNECTION.asString(), (Object)HttpHeader.KEEP_ALIVE.asString());
                response.headers().set(HttpHeader.KEEP_ALIVE.asString(), (Object)("timeout=" + ShuffleHandler.this.connectionKeepAliveTimeOut));
                LOG.info("Content Length in shuffle : " + contentLength);
            }
        }

        protected void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = ShuffleHandler.this.secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info("Request for unknown token " + appid);
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.headers().get("UrlHash");
            if (urlHashStr == null) {
                LOG.info("Missing header hash for " + appid);
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(Charsets.UTF_8), (SecretKey)tokenSecret);
            response.headers().set("ReplyHash", (Object)reply);
            response.headers().set("name", (Object)"mapreduce");
            response.headers().set("version", (Object)"1.0.0");
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String mapId, int reduce, MapOutputInfo mapOutputInfo) throws IOException {
            ChannelFuture writeFuture;
            RandomAccessFile spill;
            IndexRecord info = mapOutputInfo.indexRecord;
            ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.write((Object)ChannelBuffers.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputInfo.mapOutputFileName.toString());
            try {
                spill = SecureIOUtils.openForRandomRead((File)spillfile, (String)"r", (String)user, null);
            }
            catch (FileNotFoundException e) {
                LOG.info(spillfile + " not found");
                return null;
            }
            if (ch.getPipeline().get(SslHandler.class) == null) {
                final FadvisedFileRegion partition = new FadvisedFileRegion(spill, info.startOffset, info.partLength, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath(), ShuffleHandler.this.shuffleBufferSize, ShuffleHandler.this.shuffleTransferToAllowed);
                writeFuture = ch.write((Object)partition);
                writeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            partition.transferSuccessful();
                        }
                        partition.releaseExternalResources();
                    }
                });
            } else {
                FadvisedChunkedFile chunk = new FadvisedChunkedFile(spill, info.startOffset, info.partLength, ShuffleHandler.this.sslFileBufferSize, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath());
                writeFuture = ch.write((Object)chunk);
            }
            ShuffleHandler.this.metrics.shuffleConnections.incr();
            ShuffleHandler.this.metrics.shuffleOutputBytes.incr(info.partLength);
            return writeFuture;
        }

        protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        protected void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            this.sendError(ctx, message, status, Collections.emptyMap());
        }

        protected void sendError(ChannelHandlerContext ctx, String msg, HttpResponseStatus status, Map<String, String> headers) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.headers().set("name", (Object)"mapreduce");
            response.headers().set("version", (Object)"1.0.0");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                response.headers().set(header.getKey(), (Object)header.getValue());
            }
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)msg, (Charset)CharsetUtil.UTF_8));
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (cause instanceof IOException) {
                if (cause instanceof ClosedChannelException) {
                    LOG.debug("Ignoring closed channel error", cause);
                    return;
                }
                String message = String.valueOf(cause.getMessage());
                if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                    LOG.debug("Ignoring client socket close", cause);
                    return;
                }
            }
            LOG.error("Shuffle error: ", cause);
            if (ch.isConnected()) {
                LOG.error("Shuffle error " + e);
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }

        class MapOutputInfo {
            final Path mapOutputFileName;
            final IndexRecord indexRecord;

            MapOutputInfo(Path mapOutputFileName, IndexRecord indexRecord) {
                this.mapOutputFileName = mapOutputFileName;
                this.indexRecord = indexRecord;
            }
        }
    }

    class HttpPipelineFactory
    implements ChannelPipelineFactory {
        final Shuffle SHUFFLE;
        private SSLFactory sslFactory;
        private final ChannelHandler idleStateHandler;

        public HttpPipelineFactory(Configuration conf, Timer timer) throws Exception {
            this.SHUFFLE = ShuffleHandler.this.getShuffle(conf);
            if (conf.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
                LOG.info("Encrypted shuffle is enabled.");
                this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
                this.sslFactory.init();
            }
            this.idleStateHandler = new IdleStateHandler(timer, 0, ShuffleHandler.this.connectionKeepAliveTimeOut, 0);
        }

        public Shuffle getSHUFFLE() {
            return this.SHUFFLE;
        }

        public void destroy() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslFactory != null) {
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslFactory.createSSLEngine()));
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("shuffle", (ChannelHandler)this.SHUFFLE);
            pipeline.addLast("idle", this.idleStateHandler);
            pipeline.addLast(ShuffleHandler.TIMEOUT_HANDLER, (ChannelHandler)new TimeoutHandler());
            return pipeline;
        }
    }

    static class TimeoutHandler
    extends IdleStateAwareChannelHandler {
        private boolean enabledTimeout;

        TimeoutHandler() {
        }

        void setEnabledTimeout(boolean enabledTimeout) {
            this.enabledTimeout = enabledTimeout;
        }

        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            if (e.getState() == IdleState.WRITER_IDLE && this.enabledTimeout) {
                e.getChannel().close();
            }
        }
    }

    private static class ReduceContext {
        private List<String> mapIds;
        private AtomicInteger mapsToWait;
        private AtomicInteger mapsToSend;
        private int reduceId;
        private ChannelHandlerContext ctx;
        private String user;
        private Map<String, Shuffle.MapOutputInfo> infoMap;
        private String jobId;
        private final boolean keepAlive;

        public ReduceContext(List<String> mapIds, int rId, ChannelHandlerContext context, String usr, Map<String, Shuffle.MapOutputInfo> mapOutputInfoMap, String jobId, boolean keepAlive) {
            this.mapIds = mapIds;
            this.reduceId = rId;
            this.mapsToWait = new AtomicInteger(mapIds.size());
            this.mapsToSend = new AtomicInteger(0);
            this.ctx = context;
            this.user = usr;
            this.infoMap = mapOutputInfoMap;
            this.jobId = jobId;
            this.keepAlive = keepAlive;
        }

        public int getReduceId() {
            return this.reduceId;
        }

        public ChannelHandlerContext getCtx() {
            return this.ctx;
        }

        public String getUser() {
            return this.user;
        }

        public Map<String, Shuffle.MapOutputInfo> getInfoMap() {
            return this.infoMap;
        }

        public String getJobId() {
            return this.jobId;
        }

        public List<String> getMapIds() {
            return this.mapIds;
        }

        public AtomicInteger getMapsToSend() {
            return this.mapsToSend;
        }

        public AtomicInteger getMapsToWait() {
            return this.mapsToWait;
        }

        public boolean getKeepAlive() {
            return this.keepAlive;
        }
    }

    class ReduceMapFileCount
    implements ChannelFutureListener {
        private ReduceContext reduceContext;

        public ReduceMapFileCount(ReduceContext rc) {
            this.reduceContext = rc;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                future.getChannel().close();
                return;
            }
            int waitCount = this.reduceContext.getMapsToWait().decrementAndGet();
            if (waitCount == 0) {
                ShuffleHandler.this.metrics.operationComplete(future);
                if (this.reduceContext.getKeepAlive()) {
                    ChannelPipeline pipeline = future.getChannel().getPipeline();
                    TimeoutHandler timeoutHandler = (TimeoutHandler)pipeline.get(ShuffleHandler.TIMEOUT_HANDLER);
                    timeoutHandler.setEnabledTimeout(true);
                } else {
                    future.getChannel().close();
                }
            } else {
                ShuffleHandler.this.pipelineFact.getSHUFFLE().sendMap(this.reduceContext);
            }
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

