/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.metrics.AMRMClientRelayerMetrics;
import org.apache.hadoop.yarn.server.scheduler.ResourceRequestSet;
import org.apache.hadoop.yarn.server.scheduler.ResourceRequestSetKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMRMClientRelayer
implements ApplicationMasterProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientRelayer.class);
    private ApplicationMasterProtocol rmClient;
    private RegisterApplicationMasterRequest amRegistrationRequest;
    private Map<ResourceRequestSetKey, ResourceRequestSet> remotePendingAsks = new HashMap<ResourceRequestSetKey, ResourceRequestSet>();
    private Set<ResourceRequest> ask = new TreeSet<ResourceRequest>((Comparator<ResourceRequest>)new ResourceRequest.ResourceRequestComparator());
    private Map<Long, Integer> pendingCountForMetrics = new HashMap<Long, Integer>();
    private Map<Long, Long> askTimeStamp = new HashMap<Long, Long>();
    private Set<ContainerId> knownContainers = new HashSet<ContainerId>();
    private Set<ContainerId> remotePendingRelease = new HashSet<ContainerId>();
    private Set<ContainerId> release = new HashSet<ContainerId>();
    private Set<String> remoteBlacklistedNodes = new HashSet<String>();
    private Set<String> blacklistAdditions = new HashSet<String>();
    private Set<String> blacklistRemovals = new HashSet<String>();
    private Map<ContainerId, UpdateContainerRequest> remotePendingChange = new HashMap<ContainerId, UpdateContainerRequest>();
    private Map<ContainerId, UpdateContainerRequest> change = new HashMap<ContainerId, UpdateContainerRequest>();
    private Map<ContainerId, Long> changeTimeStamp = new HashMap<ContainerId, Long>();
    private Map<Set<String>, List<SchedulingRequest>> remotePendingSchedRequest = new HashMap<Set<String>, List<SchedulingRequest>>();
    private List<SchedulingRequest> schedulingRequest = new ArrayList<SchedulingRequest>();
    private ApplicationId appId;
    private volatile int resetResponseId = -1;
    private String rmId = "";
    private volatile boolean shutdown = false;
    private AMRMClientRelayerMetrics metrics = AMRMClientRelayerMetrics.getInstance();

    public AMRMClientRelayer(ApplicationMasterProtocol rmClient, ApplicationId appId, String rmId) {
        this.rmClient = rmClient;
        this.appId = appId;
        this.rmId = rmId;
    }

    public void setAMRegistrationRequest(RegisterApplicationMasterRequest registerRequest) {
        this.amRegistrationRequest = registerRequest;
    }

    public String getRMIdentifier() {
        return this.rmId;
    }

    public void setRMClient(ApplicationMasterProtocol client) {
        this.rmClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        AMRMClientRelayer aMRMClientRelayer = this;
        synchronized (aMRMClientRelayer) {
            if (this.shutdown) {
                LOG.warn("Shutdown called twice for AMRMClientRelayer for RM " + this.rmId);
                return;
            }
            this.shutdown = true;
            for (Map.Entry<ResourceRequestSetKey, ResourceRequestSet> entry : this.remotePendingAsks.entrySet()) {
                ResourceRequestSetKey key = entry.getKey();
                if (key.getAllocationRequestId() == 0L) {
                    this.metrics.decrClientPending(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), entry.getValue().getNumContainers());
                    continue;
                }
                this.askTimeStamp.remove(key.getAllocationRequestId());
                Integer pending = this.pendingCountForMetrics.remove(key.getAllocationRequestId());
                if (pending == null) {
                    throw new YarnRuntimeException("pendingCountForMetrics not found for key " + key + " during shutdown");
                }
                this.metrics.decrClientPending(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), (int)pending);
            }
            for (UpdateContainerRequest req : this.remotePendingChange.values()) {
                this.metrics.decrClientPending(this.rmId, req.getContainerUpdateType(), 1);
            }
        }
        if (this.rmClient != null) {
            try {
                RPC.stopProxy((Object)this.rmClient);
                this.rmClient = null;
            }
            catch (HadoopIllegalArgumentException hadoopIllegalArgumentException) {
                // empty catch block
            }
        }
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        this.amRegistrationRequest = request;
        return this.rmClient.registerApplicationMaster(request);
    }

    private void reRegisterApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        try {
            this.registerApplicationMaster(request);
        }
        catch (InvalidApplicationMasterRequestException e) {
            if (e.getMessage().contains("Application Master is already registered : ")) {
                LOG.info("Concurrent thread successfully re-registered, moving on.");
            }
            throw e;
        }
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        try {
            return this.rmClient.finishApplicationMaster(request);
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.warn("Out of sync with RM " + this.rmId + " for " + this.appId + ", hence resyncing.");
            this.reRegisterApplicationMaster(this.amRegistrationRequest);
            return this.finishApplicationMaster(request);
        }
    }

    private void addNewAllocateRequest(AllocateRequest allocateRequest) throws YarnException {
        this.addNewAsks(allocateRequest.getAskList());
        if (allocateRequest.getReleaseList() != null) {
            this.remotePendingRelease.addAll(allocateRequest.getReleaseList());
            this.release.addAll(allocateRequest.getReleaseList());
        }
        if (allocateRequest.getResourceBlacklistRequest() != null) {
            if (allocateRequest.getResourceBlacklistRequest().getBlacklistAdditions() != null) {
                this.remoteBlacklistedNodes.addAll(allocateRequest.getResourceBlacklistRequest().getBlacklistAdditions());
                this.blacklistAdditions.addAll(allocateRequest.getResourceBlacklistRequest().getBlacklistAdditions());
            }
            if (allocateRequest.getResourceBlacklistRequest().getBlacklistRemovals() != null) {
                this.remoteBlacklistedNodes.removeAll(allocateRequest.getResourceBlacklistRequest().getBlacklistRemovals());
                this.blacklistRemovals.addAll(allocateRequest.getResourceBlacklistRequest().getBlacklistRemovals());
            }
        }
        if (allocateRequest.getUpdateRequests() != null) {
            for (UpdateContainerRequest update : allocateRequest.getUpdateRequests()) {
                UpdateContainerRequest req = this.remotePendingChange.put(update.getContainerId(), update);
                this.changeTimeStamp.put(update.getContainerId(), System.currentTimeMillis());
                if (req == null) {
                    this.metrics.incrClientPending(this.rmId, update.getContainerUpdateType(), 1);
                } else if (req.getContainerUpdateType() != update.getContainerUpdateType()) {
                    this.metrics.decrClientPending(this.rmId, req.getContainerUpdateType(), 1);
                    this.metrics.incrClientPending(this.rmId, update.getContainerUpdateType(), 1);
                }
                this.change.put(update.getContainerId(), update);
            }
        }
        if (allocateRequest.getSchedulingRequests() != null) {
            AMRMClientUtils.addToOutstandingSchedulingRequests((Collection)allocateRequest.getSchedulingRequests(), this.remotePendingSchedRequest);
            this.schedulingRequest.addAll(allocateRequest.getSchedulingRequests());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest allocateRequest) throws YarnException, IOException {
        Object askList;
        AllocateResponse allocateResponse = null;
        long startTime = System.currentTimeMillis();
        AMRMClientRelayer aMRMClientRelayer = this;
        synchronized (aMRMClientRelayer) {
            if (this.shutdown) {
                throw new YarnException("Allocate called after AMRMClientRelayer for RM " + this.rmId + " shutdown.");
            }
            this.addNewAllocateRequest(allocateRequest);
            askList = new ArrayList<ResourceRequest>(this.ask.size());
            for (ResourceRequest resourceRequest : this.ask) {
                ((ArrayList)askList).add(ResourceRequest.clone((ResourceRequest)resourceRequest));
            }
            allocateRequest = AllocateRequest.newBuilder().responseId(allocateRequest.getResponseId()).progress(allocateRequest.getProgress()).askList(askList).releaseList(new ArrayList<ContainerId>(this.release)).resourceBlacklistRequest(ResourceBlacklistRequest.newInstance(new ArrayList<String>(this.blacklistAdditions), new ArrayList<String>(this.blacklistRemovals))).updateRequests(new ArrayList<UpdateContainerRequest>(this.change.values())).schedulingRequests(new ArrayList<SchedulingRequest>(this.schedulingRequest)).build();
            if (this.resetResponseId != -1) {
                LOG.info("Override allocate responseId from " + allocateRequest.getResponseId() + " to " + this.resetResponseId + " for " + this.appId);
                allocateRequest.setResponseId(this.resetResponseId);
            }
        }
        try {
            allocateResponse = this.rmClient.allocate(allocateRequest);
            this.resetResponseId = -1;
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.warn("ApplicationMaster is out of sync with RM " + this.rmId + " for " + this.appId + ", hence resyncing.");
            this.metrics.incrRMMasterSlaveSwitch(this.rmId);
            askList = this;
            synchronized (askList) {
                for (ResourceRequestSet resourceRequestSet : this.remotePendingAsks.values()) {
                    for (ResourceRequest rr : resourceRequestSet.getRRs()) {
                        this.addResourceRequestToAsk(rr);
                    }
                }
                this.release.addAll(this.remotePendingRelease);
                this.blacklistAdditions.addAll(this.remoteBlacklistedNodes);
                this.change.putAll(this.remotePendingChange);
                for (List list : this.remotePendingSchedRequest.values()) {
                    this.schedulingRequest.addAll(list);
                }
            }
            this.reRegisterApplicationMaster(this.amRegistrationRequest);
            allocateRequest.setResponseId(0);
            allocateResponse = this.allocate(allocateRequest);
            return allocateResponse;
        }
        catch (Throwable t) {
            this.metrics.addHeartbeatFailure(this.rmId, System.currentTimeMillis() - startTime);
            if (t instanceof InvalidApplicationMasterRequestException) {
                int responseId = AMRMClientUtils.parseExpectedResponseIdFromException((String)t.getMessage());
                if (responseId != -1) {
                    this.resetResponseId = responseId;
                    LOG.info("ResponseId out of sync with RM, expect " + responseId + " but " + allocateRequest.getResponseId() + " used by " + this.appId + ". Will override in the next allocate.");
                } else {
                    LOG.warn("Failed to parse expected responseId out of exception for " + this.appId);
                }
            }
            throw t;
        }
        aMRMClientRelayer = this;
        synchronized (aMRMClientRelayer) {
            if (this.shutdown) {
                throw new YarnException("Allocate call succeeded for " + this.appId + " after AMRMClientRelayer for RM " + this.rmId + " shutdown.");
            }
            this.updateMetrics(allocateResponse, startTime);
            AMRMClientUtils.removeFromOutstandingSchedulingRequests((Collection)allocateResponse.getAllocatedContainers(), this.remotePendingSchedRequest);
            AMRMClientUtils.removeFromOutstandingSchedulingRequests((Collection)allocateResponse.getContainersFromPreviousAttempts(), this.remotePendingSchedRequest);
            this.ask.clear();
            this.release.clear();
            this.blacklistAdditions.clear();
            this.blacklistRemovals.clear();
            this.change.clear();
            this.schedulingRequest.clear();
            return allocateResponse;
        }
    }

    private void updateMetrics(AllocateResponse allocateResponse, long startTime) {
        UpdateContainerRequest req;
        this.metrics.addHeartbeatSuccess(this.rmId, System.currentTimeMillis() - startTime);
        if (allocateResponse.getAllocatedContainers() != null) {
            for (Container container : allocateResponse.getAllocatedContainers()) {
                Integer count;
                if (!this.knownContainers.add(container.getId())) continue;
                this.metrics.addFulfilledQPS(this.rmId, AMRMClientRelayerMetrics.getRequestType(container.getExecutionType()), 1L);
                if (container.getAllocationRequestId() == 0L || (count = this.pendingCountForMetrics.get(container.getAllocationRequestId())) == null || count <= 0) continue;
                count = count - 1;
                this.pendingCountForMetrics.put(container.getAllocationRequestId(), count);
                this.metrics.decrClientPending(this.rmId, AMRMClientRelayerMetrics.getRequestType(container.getExecutionType()), 1);
                this.metrics.addFulfillLatency(this.rmId, AMRMClientRelayerMetrics.getRequestType(container.getExecutionType()), System.currentTimeMillis() - this.askTimeStamp.get(container.getAllocationRequestId()));
            }
        }
        if (allocateResponse.getCompletedContainersStatuses() != null) {
            for (Container container : allocateResponse.getCompletedContainersStatuses()) {
                this.remotePendingRelease.remove(container.getContainerId());
                req = this.remotePendingChange.remove(container.getContainerId());
                if (req != null) {
                    this.metrics.decrClientPending(this.rmId, req.getContainerUpdateType(), 1);
                }
                this.knownContainers.remove(container.getContainerId());
            }
        }
        if (allocateResponse.getUpdatedContainers() != null) {
            for (UpdatedContainer updatedContainer : allocateResponse.getUpdatedContainers()) {
                req = this.remotePendingChange.remove(updatedContainer.getContainer().getId());
                if (req == null) continue;
                this.metrics.decrClientPending(this.rmId, req.getContainerUpdateType(), 1);
                this.metrics.addFulfillLatency(this.rmId, req.getContainerUpdateType(), System.currentTimeMillis() - this.changeTimeStamp.remove(req.getContainerId()));
                this.metrics.addFulfilledQPS(this.rmId, req.getContainerUpdateType(), 1L);
            }
        }
    }

    private void addNewAsks(List<ResourceRequest> asks) throws YarnException {
        HashSet<ResourceRequestSetKey> touchedKeys = new HashSet<ResourceRequestSetKey>();
        HashSet<ResourceRequestSetKey> nonZeroNewKeys = new HashSet<ResourceRequestSetKey>();
        for (ResourceRequest rr : asks) {
            this.addResourceRequestToAsk(rr);
            ResourceRequestSetKey key = new ResourceRequestSetKey(rr);
            touchedKeys.add(key);
            ResourceRequestSet askSet = this.remotePendingAsks.get(key);
            if (askSet == null) {
                askSet = new ResourceRequestSet(key);
                this.remotePendingAsks.put(key, askSet);
                if (key.getAllocationRequestId() != 0L) {
                    nonZeroNewKeys.add(key);
                }
            }
            int numContainers = askSet.getNumContainers();
            askSet.addAndOverrideRR(rr);
            int deltaContainers = askSet.getNumContainers() - numContainers;
            if (key.getAllocationRequestId() == 0L) {
                if (deltaContainers == 0) continue;
                this.metrics.incrClientPending(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), deltaContainers);
                if (deltaContainers <= 0) continue;
                this.metrics.addRequestedQPS(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), deltaContainers);
                continue;
            }
            if (deltaContainers <= 0 || numContainers == 0) continue;
            throw new YarnException("Received new ask (" + askSet.getNumContainers() + ") on top of existing (" + numContainers + ") in key " + key);
        }
        for (ResourceRequestSetKey key : touchedKeys) {
            ResourceRequestSet askSet = this.remotePendingAsks.get(key);
            if (askSet.getNumContainers() == 0) {
                this.remotePendingAsks.remove(key);
                continue;
            }
            askSet.cleanupZeroNonAnyRR();
        }
        for (ResourceRequestSetKey key : nonZeroNewKeys) {
            if (!this.remotePendingAsks.containsKey(key)) continue;
            this.askTimeStamp.put(key.getAllocationRequestId(), System.currentTimeMillis());
            int count = this.remotePendingAsks.get(key).getNumContainers();
            this.pendingCountForMetrics.put(key.getAllocationRequestId(), count);
            this.metrics.incrClientPending(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), count);
            this.metrics.addRequestedQPS(this.rmId, AMRMClientRelayerMetrics.getRequestType(key.getExeType()), count);
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        this.ask.remove(remoteRequest);
        this.ask.add(remoteRequest);
    }

    @VisibleForTesting
    protected Map<ResourceRequestSetKey, ResourceRequestSet> getRemotePendingAsks() {
        return this.remotePendingAsks;
    }
}

