/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppProxy
extends AbstractService {
    public static final String FETCHER_ATTRIBUTE = "AppUrlFetcher";
    public static final String IS_SECURITY_ENABLED_ATTRIBUTE = "IsSecurityEnabled";
    public static final String PROXY_HOST_ATTRIBUTE = "proxyHost";
    public static final String PROXY_CA = "ProxyCA";
    private static final Logger LOG = LoggerFactory.getLogger(WebAppProxy.class);
    private HttpServer2 proxyServer = null;
    private String bindAddress = null;
    private int port = 0;
    private AccessControlList acl = null;
    private AppReportFetcher fetcher = null;
    private boolean isSecurityEnabled = false;
    private String proxyHost = null;

    public WebAppProxy() {
        super(WebAppProxy.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String bindHost;
        String auth = conf.get("hadoop.security.authentication");
        if (auth == null || "simple".equals(auth)) {
            this.isSecurityEnabled = false;
        } else if ("kerberos".equals(auth)) {
            this.isSecurityEnabled = true;
        } else {
            LOG.warn("Unrecognized attribute value for hadoop.security.authentication of " + auth);
        }
        String proxy = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        String[] proxyParts = proxy.split(":");
        this.proxyHost = proxyParts[0];
        this.fetcher = new AppReportFetcher(conf);
        this.bindAddress = conf.get("yarn.web-proxy.address");
        if (this.bindAddress == null || this.bindAddress.isEmpty()) {
            throw new YarnRuntimeException("yarn.web-proxy.address is not set so the proxy will not run.");
        }
        String[] parts = StringUtils.split((String)this.bindAddress, (char)':');
        this.port = 0;
        if (parts.length == 2) {
            this.bindAddress = parts[0];
            this.port = Integer.parseInt(parts[1]);
        }
        if ((bindHost = conf.getTrimmed("yarn.web-proxy.bind-host", null)) != null) {
            LOG.debug("{} is set, will be used to run proxy.", (Object)"yarn.web-proxy.bind-host");
            this.bindAddress = bindHost;
        }
        LOG.info("Instantiating Proxy at {}:{}", (Object)this.bindAddress, (Object)this.port);
        this.acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            Configuration conf = this.getConfig();
            HttpServer2.Builder b = new HttpServer2.Builder().setName("proxy").addEndpoint(URI.create(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + this.bindAddress + ":" + this.port)).setFindPort(this.port == 0).setConf(this.getConfig()).setACL(this.acl);
            if (YarnConfiguration.useHttps((Configuration)conf)) {
                WebAppUtils.loadSslConfiguration((HttpServer2.Builder)b);
            }
            this.proxyServer = b.build();
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.proxyServer.setAttribute(FETCHER_ATTRIBUTE, (Object)this.fetcher);
            this.proxyServer.setAttribute(IS_SECURITY_ENABLED_ATTRIBUTE, (Object)this.isSecurityEnabled);
            this.proxyServer.setAttribute(PROXY_HOST_ATTRIBUTE, (Object)this.proxyHost);
            this.proxyServer.start();
        }
        catch (IOException e) {
            LOG.error("Could not start proxy web server", (Throwable)e);
            throw e;
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.proxyServer != null) {
            try {
                this.proxyServer.stop();
            }
            catch (Exception e) {
                LOG.error("Error stopping proxy web server", (Throwable)e);
                throw new YarnRuntimeException("Error stopping proxy web server", (Throwable)e);
            }
        }
        if (this.fetcher != null) {
            this.fetcher.stop();
        }
        super.serviceStop();
    }

    public void join() {
        if (this.proxyServer != null) {
            try {
                this.proxyServer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    String getBindAddress() {
        return this.bindAddress + ":" + this.port;
    }
}

