/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.protobuf.Message;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ResultSerialization
extends Configured
implements Serialization<Result> {
    private static final Log LOG = LogFactory.getLog(ResultSerialization.class);
    public static final String IMPORT_FORMAT_VER = "hbase.import.version";

    public boolean accept(Class<?> c) {
        return Result.class.isAssignableFrom(c);
    }

    public Deserializer<Result> getDeserializer(Class<Result> c) {
        String inputVersion;
        Configuration conf = this.getConf();
        if (conf != null && (inputVersion = conf.get(IMPORT_FORMAT_VER)) != null && inputVersion.equals("0.94")) {
            LOG.info((Object)"Load exported file using deserializer for HBase 0.94 format");
            return new Result94Deserializer();
        }
        return new ResultDeserializer();
    }

    public Serializer<Result> getSerializer(Class<Result> c) {
        return new ResultSerializer();
    }

    private static class ResultSerializer
    implements Serializer<Result> {
        private OutputStream out;

        private ResultSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Result result) throws IOException {
            ProtobufUtil.toResult((Result)result).writeDelimitedTo(this.out);
        }
    }

    private static class ResultDeserializer
    implements Deserializer<Result> {
        private InputStream in;

        private ResultDeserializer() {
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Result deserialize(Result mutation) throws IOException {
            ClientProtos.Result.Builder builder = ClientProtos.Result.newBuilder();
            ProtobufUtil.mergeDelimitedFrom((Message.Builder)builder, (InputStream)this.in);
            ClientProtos.Result proto = builder.build();
            return ProtobufUtil.toResult((ClientProtos.Result)proto);
        }

        public void open(InputStream in) throws IOException {
            this.in = in;
        }
    }

    private static class Result94Deserializer
    implements Deserializer<Result> {
        private DataInputStream in;

        private Result94Deserializer() {
        }

        public void close() throws IOException {
            this.in.close();
        }

        public Result deserialize(Result mutation) throws IOException {
            int keyLength;
            int totalBuffer = this.in.readInt();
            if (totalBuffer == 0) {
                return Result.EMPTY_RESULT;
            }
            byte[] buf = new byte[totalBuffer];
            this.readChunked(this.in, buf, 0, totalBuffer);
            ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
            for (int offset = 0; offset < totalBuffer; offset += keyLength) {
                keyLength = Bytes.toInt((byte[])buf, (int)offset);
                kvs.add(new KeyValue(buf, offset += 4, keyLength));
            }
            return Result.create(kvs);
        }

        public void open(InputStream in) throws IOException {
            if (!(in instanceof DataInputStream)) {
                throw new IOException("Wrong input stream instance passed in");
            }
            this.in = (DataInputStream)in;
        }

        private void readChunked(DataInput in, byte[] dest, int ofs, int len) throws IOException {
            int maxRead = 8192;
            while (ofs < len) {
                in.readFully(dest, ofs, Math.min(len - ofs, maxRead));
                ofs += maxRead;
            }
        }
    }
}

