/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
public abstract class AbstractMultiOutputCompactor<T extends AbstractMultiFileWriter>
extends Compactor<T> {
    private static final Log LOG = LogFactory.getLog(AbstractMultiOutputCompactor.class);

    public AbstractMultiOutputCompactor(Configuration conf, Store store) {
        super(conf, store);
    }

    protected void initMultiWriter(AbstractMultiFileWriter writer, InternalScanner scanner, final Compactor.FileDetails fd, final boolean shouldDropBehind) {
        AbstractMultiFileWriter.WriterFactory writerFactory = new AbstractMultiFileWriter.WriterFactory(){

            @Override
            public StoreFile.Writer createWriter() throws IOException {
                return AbstractMultiOutputCompactor.this.createTmpWriter(fd, shouldDropBehind);
            }
        };
        StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
        writer.init(storeScanner, writerFactory);
    }

    @Override
    protected void abortWriter(T writer) throws IOException {
        FileSystem fs = this.store.getFileSystem();
        for (Path leftoverFile : ((AbstractMultiFileWriter)writer).abortWriters()) {
            try {
                fs.delete(leftoverFile, false);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to delete the leftover file " + leftoverFile + " after an unfinished compaction."), (Throwable)e);
            }
        }
    }
}

